/*
 * Decompiled with CFR 0.152.
 */
package kamon.jdbc;

import com.typesafe.config.Config;
import java.util.concurrent.TimeUnit;
import kamon.Kamon$;
import kamon.OnReconfigureHook;
import kamon.jdbc.Jdbc;
import kamon.util.DynamicAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;

public final class Jdbc$ {
    public static final Jdbc$ MODULE$;
    private final Logger logger;
    private volatile long slowQueryThresholdMicroseconds;
    private volatile Jdbc.SlowQueryProcessor slowQueryProcessor;
    private volatile Jdbc.SqlErrorProcessor sqlErrorProcessor;

    static {
        new Jdbc$();
    }

    private Logger logger() {
        return this.logger;
    }

    private long slowQueryThresholdMicroseconds() {
        return this.slowQueryThresholdMicroseconds;
    }

    private void slowQueryThresholdMicroseconds_$eq(long x$1) {
        this.slowQueryThresholdMicroseconds = x$1;
    }

    private Jdbc.SlowQueryProcessor slowQueryProcessor() {
        return this.slowQueryProcessor;
    }

    private void slowQueryProcessor_$eq(Jdbc.SlowQueryProcessor x$1) {
        this.slowQueryProcessor = x$1;
    }

    private Jdbc.SqlErrorProcessor sqlErrorProcessor() {
        return this.sqlErrorProcessor;
    }

    private void sqlErrorProcessor_$eq(Jdbc.SqlErrorProcessor x$1) {
        this.sqlErrorProcessor = x$1;
    }

    public void kamon$jdbc$Jdbc$$loadConfiguration(Config config) {
        try {
            Config jdbcConfig = config.getConfig("kamon.jdbc");
            DynamicAccess dynamic = new DynamicAccess(this.getClass().getClassLoader());
            String slowQueryProcessorFQCN = jdbcConfig.getString("slow-query-processor");
            this.slowQueryProcessor_$eq((Jdbc.SlowQueryProcessor)dynamic.createInstanceFor(slowQueryProcessorFQCN, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Jdbc.SlowQueryProcessor.class)).get());
            this.slowQueryThresholdMicroseconds_$eq(jdbcConfig.getDuration("slow-query-threshold", TimeUnit.MICROSECONDS));
            String sqlErrorProcessorFQCN = jdbcConfig.getString("sql-error-processor");
            this.sqlErrorProcessor_$eq((Jdbc.SqlErrorProcessor)dynamic.createInstanceFor(sqlErrorProcessorFQCN, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Jdbc.SqlErrorProcessor.class)).get());
        }
        catch (Throwable throwable) {
            this.logger().error("The kamon-jdbc module failed to load configuration", throwable);
        }
    }

    public void onStatementFinish(String statement, long elapsedTimeMicroseconds) {
        if (elapsedTimeMicroseconds > this.slowQueryThresholdMicroseconds()) {
            this.slowQueryProcessor().process(statement, elapsedTimeMicroseconds, this.slowQueryThresholdMicroseconds());
        }
    }

    public void onStatementError(String statement, Throwable error) {
        this.sqlErrorProcessor().process(statement, error);
    }

    private Jdbc$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.slowQueryThresholdMicroseconds = 2000000L;
        this.slowQueryProcessor = new Jdbc.SlowQueryProcessor.Default();
        this.sqlErrorProcessor = new Jdbc.SqlErrorProcessor.Default();
        this.kamon$jdbc$Jdbc$$loadConfiguration(Kamon$.MODULE$.config());
        Kamon$.MODULE$.onReconfigure(new OnReconfigureHook(){

            public void onReconfigure(Config newConfig) {
                Jdbc$.MODULE$.kamon$jdbc$Jdbc$$loadConfiguration(newConfig);
            }
        });
    }
}

