/*
 * Decompiled with CFR 0.152.
 */
package kamon.jdbc.instrumentation;

import java.sql.PreparedStatement;
import java.sql.Statement;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kamon.Kamon$;
import kamon.jdbc.Jdbc$;
import kamon.jdbc.Metrics;
import kamon.jdbc.Metrics$Statements$;
import kamon.jdbc.instrumentation.Mixin;
import kamon.jdbc.instrumentation.Mixin$HasConnectionPoolMetrics$;
import kamon.jdbc.instrumentation.StatementInstrumentation$StatementTypes$;
import kamon.metric.RangeSampler;
import kamon.trace.Span;
import kamon.trace.SpanCustomizer;
import kamon.trace.SpanCustomizer$;
import kamon.trace.Tracer;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.DeclareMixin;
import org.aspectj.lang.annotation.Pointcut;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@Aspect
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0001\u0003\u0001%\u0011\u0001d\u0015;bi\u0016lWM\u001c;J]N$(/^7f]R\fG/[8o\u0015\t\u0019A!A\bj]N$(/^7f]R\fG/[8o\u0015\t)a!\u0001\u0003kI\n\u001c'\"A\u0004\u0002\u000b-\fWn\u001c8\u0004\u0001M\u0011\u0001A\u0003\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bE\u0001A\u0011\u0001\n\u0002\rqJg.\u001b;?)\u0005\u0019\u0002C\u0001\u000b\u0001\u001b\u0005\u0011\u0001\"\u0002\f\u0001\t\u00039\u0012\u0001K7jq&t\u0007*Y:D_:tWm\u0019;j_:\u0004vn\u001c7Ue\u0006\u001c7.\u001a:U_N#\u0018\r^3nK:$X#\u0001\r\u0011\u0005eabB\u0001\u000b\u001b\u0013\tY\"!A\u0003NSbLg.\u0003\u0002\u001e=\tA\u0002*Y:D_:tWm\u0019;j_:\u0004vn\u001c7NKR\u0014\u0018nY:\u000b\u0005m\u0011\u0001\u0006B\u000b!Y5\u0002\"!\t\u0016\u000e\u0003\tR!a\t\u0013\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002&M\u0005!A.\u00198h\u0015\t9\u0003&A\u0004bgB,7\r\u001e6\u000b\u0003%\n1a\u001c:h\u0013\tY#E\u0001\u0007EK\u000ed\u0017M]3NSbLg.A\u0003wC2,X-I\u0001/\u0003MQ\u0017M^1/gFdgf\u0015;bi\u0016lWM\u001c;,\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003u\u0019H/\u0019;f[\u0016tG/\u0012=fGV$XmV5uQ\u0006\u0013x-^7f]R\u001cHc\u0001\u001a6}A\u00111bM\u0005\u0003i1\u0011A!\u00168ji\")ag\fa\u0001o\u0005\u00191/\u001d7\u0011\u0005aZdBA\u0006:\u0013\tQD\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e\r\u0011\u0015yt\u00061\u0001A\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0005\u0002B\u000b6\t!I\u0003\u00027\u0007*\tA)\u0001\u0003kCZ\f\u0017B\u0001$C\u0005%\u0019F/\u0019;f[\u0016tG\u000f\u000b\u00030\u00112Z\u0005CA\u0011J\u0013\tQ%E\u0001\u0005Q_&tGoY;uC\u0005a\u0015\u0001T3yK\u000e,H/[8oQ)\u0002#.\u0019<b]M\fHNL*uCR,W.\u001a8uW9*\u00070Z2vi\u0016DcFL\u0015*A\u00192\u0003%\u0019:hg\"\u001a\u0018\u000f\\\u0015!M\u0019\u0002C\u000f[5tQM$\u0018\r^3nK:$\u0018\u0006C\u0003O\u0001\u0011\u0005q*\u0001\u0011ti\u0006$X-\\3oi\u0016CXmY;uK^KG\u000f[8vi\u0006\u0013x-^7f]R\u001cHC\u0001\u001aQ\u0011\u0015yT\n1\u0001R!\t\t%+\u0003\u0002T\u0005\n\t\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;)\t5CE&V\u0011\u0002-\u0006)U\r_3dkRLwN\u001c\u0015+A)\fg/\u0019\u0018tc2t\u0003K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;,]\u0015DXmY;uK\"J\u0013\u0006\t\u0014'AQD\u0017n\u001d\u0015ti\u0006$X-\\3oi&BQ\u0001\u0017\u0001\u0005\u0002e\u000b1%\u0019:pk:$7\u000b^1uK6,g\u000e^#yK\u000e,H/Z,ji\"\f%oZ;nK:$8\u000f\u0006\u0003[;\u000e$\u0007CA\u0006\\\u0013\taFBA\u0002B]fDQAX,A\u0002}\u000b1\u0001\u001d6q!\t\u0001\u0017-D\u0001%\u0013\t\u0011GEA\nQe>\u001cW-\u001a3j]\u001eTu.\u001b8Q_&tG\u000fC\u00037/\u0002\u0007q\u0007C\u0003@/\u0002\u0007\u0001\t\u000b\u0003XM2J\u0007CA\u0011h\u0013\tA'E\u0001\u0004Be>,h\u000eZ\u0011\u0002U\u0006i3\u000f^1uK6,g\u000e^#yK\u000e,H/Z,ji\"\f%oZ;nK:$8\u000fK:rY2\u00023\u000f^1uK6,g\u000e^\u0015\t\u000b1\u0004A\u0011A7\u0002M\u0005\u0014x.\u001e8e'R\fG/Z7f]R,\u00050Z2vi\u0016<\u0016\u000e\u001e5pkR\f%oZ;nK:$8\u000fF\u0002[]>DQAX6A\u0002}CQaP6A\u0002ECCa\u001b4-c\u0006\n!/A\u0016ti\u0006$X-\\3oi\u0016CXmY;uK^KG\u000f[8vi\u0006\u0013x-^7f]R\u001c\bf\u001d;bi\u0016lWM\u001c;*\u0011\u0015!\b\u0001\"\u0001v\u0003\t\u001aH/\u0019;f[\u0016tG/\u0012=fGV$X-U;fef<\u0016\u000e\u001e5Be\u001e,X.\u001a8ugR\u0019!G^<\t\u000bY\u001a\b\u0019A\u001c\t\u000b}\u001a\b\u0019\u0001!)\tMDE&_\u0011\u0002u\u0006\tV\r_3dkRLwN\u001c\u0015+A)\fg/\u0019\u0018tc2t3\u000b^1uK6,g\u000e^\u0016/Kb,7-\u001e;f#V,'/\u001f\u0015/]%J\u0003E\n\u0014!CJ<7\u000fK:rY&\u0002cE\n\u0011uQ&\u001c\bf\u001d;bi\u0016lWM\u001c;*\u0011\u0015a\b\u0001\"\u0001~\u0003\u0015\u001aH/\u0019;f[\u0016tG/\u0012=fGV$X-U;fef<\u0016\u000e\u001e5pkR\f%oZ;nK:$8\u000f\u0006\u00023}\")qh\u001fa\u0001#\"*1\u0010\u0013\u0017\u0002\u0002\u0005\u0012\u00111A\u0001KKb,7-\u001e;j_:D#\u0006\t6bm\u0006t3/\u001d7/!J,\u0007/\u0019:fIN#\u0018\r^3nK:$8FL3yK\u000e,H/Z)vKJL\b&K\u0015!M\u0019\u0002C\u000f[5tQM$\u0018\r^3nK:$\u0018\u0006C\u0004\u0002\b\u0001!\t!!\u0003\u0002Q\u0005\u0014x.\u001e8e'R\fG/Z7f]R,\u00050Z2vi\u0016\fV/\u001a:z/&$\b.\u0011:hk6,g\u000e^:\u0015\u000fi\u000bY!!\u0004\u0002\u0010!1a,!\u0002A\u0002}CaANA\u0003\u0001\u00049\u0004BB \u0002\u0006\u0001\u0007\u0001\t\u000b\u0004\u0002\u0006\u0019d\u00131C\u0011\u0003\u0003+\t!g\u001d;bi\u0016lWM\u001c;Fq\u0016\u001cW\u000f^3Rk\u0016\u0014\u0018pV5uQ\u0006\u0013x-^7f]R\u001c\bf]9mY\u0001\u001aH/\u0019;f[\u0016tG/\u000b\u0005\b\u00033\u0001A\u0011AA\u000e\u0003-\n'o\\;oIN#\u0018\r^3nK:$X\t_3dkR,\u0017+^3ss^KG\u000f[8vi\u0006\u0013x-^7f]R\u001cH#\u0002.\u0002\u001e\u0005}\u0001B\u00020\u0002\u0018\u0001\u0007q\f\u0003\u0004@\u0003/\u0001\r!\u0015\u0015\u0007\u0003/1G&a\t\"\u0005\u0005\u0015\u0012\u0001M:uCR,W.\u001a8u\u000bb,7-\u001e;f#V,'/_,ji\"|W\u000f^!sOVlWM\u001c;tQM$\u0018\r^3nK:$\u0018\u0006C\u0004\u0002*\u0001!\t!a\u000b\u0002GM$\u0018\r^3nK:$X\t_3dkR,W\u000b\u001d3bi\u0016<\u0016\u000e\u001e5Be\u001e,X.\u001a8ugR)!'!\f\u00020!1a'a\nA\u0002]BaaPA\u0014\u0001\u0004\u0001\u0005FBA\u0014\u00112\n\u0019$\t\u0002\u00026\u0005\u0011V\r_3dkRLwN\u001c\u0015+A)\fg/\u0019\u0018tc2t3\u000b^1uK6,g\u000e^\u0016/Kb,7-\u001e;f+B$\u0017\r^3)]9J\u0013\u0006\t\u0014'A\u0005\u0014xm\u001d\u0015tc2L\u0003E\n\u0014!i\"L7\u000fK:uCR,W.\u001a8uS!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0012AJ:uCR,W.\u001a8u\u000bb,7-\u001e;f+B$\u0017\r^3XSRDw.\u001e;Be\u001e,X.\u001a8ugR\u0019!'!\u0010\t\r}\n9\u00041\u0001RQ\u0019\t9\u0004\u0013\u0017\u0002B\u0005\u0012\u00111I\u0001LKb,7-\u001e;j_:D#\u0006\t6bm\u0006t3/\u001d7/!J,\u0007/\u0019:fIN#\u0018\r^3nK:$8FL3yK\u000e,H/Z+qI\u0006$X\rK\u0015*A\u00192\u0003\u0005\u001e5jg\"\u001aH/\u0019;f[\u0016tG/\u000b\u0005\b\u0003\u000f\u0002A\u0011AA%\u0003%\n'o\\;oIN#\u0018\r^3nK:$X\t_3dkR,W\u000b\u001d3bi\u0016<\u0016\u000e\u001e5Be\u001e,X.\u001a8ugR9!,a\u0013\u0002N\u0005=\u0003B\u00020\u0002F\u0001\u0007q\f\u0003\u00047\u0003\u000b\u0002\ra\u000e\u0005\u0007\u007f\u0005\u0015\u0003\u0019\u0001!)\r\u0005\u0015c\rLA*C\t\t)&A\u001ati\u0006$X-\\3oi\u0016CXmY;uKV\u0003H-\u0019;f/&$\b.\u0011:hk6,g\u000e^:)gFdG\u0006I:uCR,W.\u001a8uS!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0013\u0001L1s_VtGm\u0015;bi\u0016lWM\u001c;Fq\u0016\u001cW\u000f^3Va\u0012\fG/Z,ji\"|W\u000f^!sOVlWM\u001c;t)\u0015Q\u0016QLA0\u0011\u0019q\u0016q\u000ba\u0001?\"1q(a\u0016A\u0002ECc!a\u0016gY\u0005\r\u0014EAA3\u0003E\u001aH/\u0019;f[\u0016tG/\u0012=fGV$X-\u00169eCR,w+\u001b;i_V$\u0018I]4v[\u0016tGo\u001d\u0015ti\u0006$X-\\3oi&Bq!!\u001b\u0001\t\u0003\tY'A\u000bti\u0006$X-\\3oi\u0016CXmY;uK\n\u000bGo\u00195\u0015\u0007I\ni\u0007\u0003\u0004@\u0003O\u0002\r\u0001\u0011\u0015\u0007\u0003OBE&!\u001d\"\u0005\u0005M\u0014! \u0015fq\u0016\u001cW\u000f^5p]\"R\u0003E[1wC:\u001a\u0018\u000f\u001c\u0018Ti\u0006$X-\\3oi.rS\r_3dkR,')\u0019;dQ\"J\u0013\u0006\t?}A\u0015DXmY;uS>t\u0007F\u000b\u0011kCZ\fgf]9m]M#\u0018\r^3nK:$8FL3yK\u000e,H/\u001a'be\u001e,')\u0019;dQ\"J\u0013&\u000b\u0011!M\u0019\u0002C\u000f[5tQM$\u0018\r^3nK:$\u0018\u0006C\u0004\u0002x\u0001!\t!!\u001f\u00027\u0005\u0014x.\u001e8e'R\fG/Z7f]R,\u00050Z2vi\u0016\u0014\u0015\r^2i)\u0015Q\u00161PA?\u0011\u0019q\u0016Q\u000fa\u0001?\"1q(!\u001eA\u0002\u0001Cc!!\u001egY\u0005\u0005\u0015EAAB\u0003\u0001\u001aH/\u0019;f[\u0016tG/\u0012=fGV$XMQ1uG\"D3\u000f^1uK6,g\u000e^\u0015\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\u0006)AO]1dWRI!,a#\u0002\u000e\u0006E\u00151\u0013\u0005\u0007=\u0006\u0015\u0005\u0019A0\t\u000f\u0005=\u0015Q\u0011a\u00015\u00061A/\u0019:hKRDaANAC\u0001\u00049\u0004bBAK\u0003\u000b\u0003\raN\u0001\u000egR\fG/Z7f]R$\u0016\u0010]3)\u0007\u0001\tI\nE\u0002\"\u00037K1!!(#\u0005\u0019\t5\u000f]3di\u001e9\u0011\u0011\u0015\u0002\t\u0002\u0005\r\u0016\u0001G*uCR,W.\u001a8u\u0013:\u001cHO];nK:$\u0018\r^5p]B\u0019A#!*\u0007\r\u0005\u0011\u0001\u0012AAT'\r\t)K\u0003\u0005\b#\u0005\u0015F\u0011AAV)\t\t\u0019k\u0002\u0005\u00020\u0006\u0015\u0006\u0012AAY\u00039\u0019F/\u0019;f[\u0016tG\u000fV=qKN\u0004B!a-\u000266\u0011\u0011Q\u0015\u0004\t\u0003o\u000b)\u000b#\u0001\u0002:\nq1\u000b^1uK6,g\u000e\u001e+za\u0016\u001c8cAA[\u0015!9\u0011#!.\u0005\u0002\u0005uFCAAY\u0011)\t\t-!.C\u0002\u0013\u0005\u00111Y\u0001\u0006#V,'/_\u000b\u0003\u0003\u000b\u0004B!a2\u0002L6\u0011\u0011\u0011\u001a\u0006\u0003K\rK1\u0001PAe\u0011%\ty-!.!\u0002\u0013\t)-\u0001\u0004Rk\u0016\u0014\u0018\u0010\t\u0005\u000b\u0003'\f)L1A\u0005\u0002\u0005\r\u0017AB+qI\u0006$X\rC\u0005\u0002X\u0006U\u0006\u0015!\u0003\u0002F\u00069Q\u000b\u001d3bi\u0016\u0004\u0003BCAn\u0003k\u0013\r\u0011\"\u0001\u0002D\u0006)!)\u0019;dQ\"I\u0011q\\A[A\u0003%\u0011QY\u0001\u0007\u0005\u0006$8\r\u001b\u0011\t\u0015\u0005\r\u0018Q\u0017b\u0001\n\u0003\t\u0019-\u0001\bHK:,'/[2Fq\u0016\u001cW\u000f^3\t\u0013\u0005\u001d\u0018Q\u0017Q\u0001\n\u0005\u0015\u0017aD$f]\u0016\u0014\u0018nY#yK\u000e,H/\u001a\u0011")
public class StatementInstrumentation {
    @DeclareMixin(value="java.sql.Statement+")
    public Mixin.HasConnectionPoolMetrics mixinHasConnectionPoolTrackerToStatement() {
        return Mixin$HasConnectionPoolMetrics$.MODULE$.apply();
    }

    @Pointcut(value="execution(* java.sql.Statement+.execute(..)) && args(sql) && this(statement)")
    public void statementExecuteWithArguments(String sql, Statement statement) {
    }

    @Pointcut(value="execution(* java.sql.PreparedStatement+.execute()) && this(statement)")
    public void statementExecuteWithoutArguments(PreparedStatement statement) {
    }

    @Around(value="statementExecuteWithArguments(sql, statement)")
    public Object aroundStatementExecuteWithArguments(ProceedingJoinPoint pjp, String sql, Statement statement) {
        return this.track(pjp, statement, sql, StatementInstrumentation$StatementTypes$.MODULE$.GenericExecute());
    }

    @Around(value="statementExecuteWithoutArguments(statement)")
    public Object aroundStatementExecuteWithoutArguments(ProceedingJoinPoint pjp, PreparedStatement statement) {
        return this.track(pjp, statement, statement.toString(), StatementInstrumentation$StatementTypes$.MODULE$.GenericExecute());
    }

    @Pointcut(value="execution(* java.sql.Statement+.executeQuery(..)) && args(sql) && this(statement)")
    public void statementExecuteQueryWithArguments(String sql, Statement statement) {
    }

    @Pointcut(value="execution(* java.sql.PreparedStatement+.executeQuery()) && this(statement)")
    public void statementExecuteQueryWithoutArguments(PreparedStatement statement) {
    }

    @Around(value="statementExecuteQueryWithArguments(sql, statement)")
    public Object aroundStatementExecuteQueryWithArguments(ProceedingJoinPoint pjp, String sql, Statement statement) {
        return this.track(pjp, statement, sql, StatementInstrumentation$StatementTypes$.MODULE$.Query());
    }

    @Around(value="statementExecuteQueryWithoutArguments(statement)")
    public Object aroundStatementExecuteQueryWithoutArguments(ProceedingJoinPoint pjp, PreparedStatement statement) {
        return this.track(pjp, statement, statement.toString(), StatementInstrumentation$StatementTypes$.MODULE$.Query());
    }

    @Pointcut(value="execution(* java.sql.Statement+.executeUpdate(..)) && args(sql) && this(statement)")
    public void statementExecuteUpdateWithArguments(String sql, Statement statement) {
    }

    @Pointcut(value="execution(* java.sql.PreparedStatement+.executeUpdate()) && this(statement)")
    public void statementExecuteUpdateWithoutArguments(PreparedStatement statement) {
    }

    @Around(value="statementExecuteUpdateWithArguments(sql, statement)")
    public Object aroundStatementExecuteUpdateWithArguments(ProceedingJoinPoint pjp, String sql, Statement statement) {
        return this.track(pjp, statement, sql, StatementInstrumentation$StatementTypes$.MODULE$.Update());
    }

    @Around(value="statementExecuteUpdateWithoutArguments(statement)")
    public Object aroundStatementExecuteUpdateWithoutArguments(ProceedingJoinPoint pjp, PreparedStatement statement) {
        return this.track(pjp, statement, statement.toString(), StatementInstrumentation$StatementTypes$.MODULE$.Update());
    }

    @Pointcut(value="(execution(* java.sql.Statement+.executeBatch()) || execution(* java.sql.Statement+.executeLargeBatch()))  && this(statement)")
    public void statementExecuteBatch(Statement statement) {
    }

    @Around(value="statementExecuteBatch(statement)")
    public Object aroundStatementExecuteBatch(ProceedingJoinPoint pjp, Statement statement) {
        return this.track(pjp, statement, statement.toString(), StatementInstrumentation$StatementTypes$.MODULE$.Batch());
    }

    /*
     * WARNING - void declaration
     */
    public Object track(ProceedingJoinPoint pjp, Object target, String sql, String statementType) {
        Object object;
        Map poolTags = (Map)Option$.MODULE$.apply((Object)((Mixin.HasConnectionPoolMetrics)target).connectionPoolMetrics()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply(Metrics.ConnectionPoolMetrics x$1) {
                return x$1.tags();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        });
        RangeSampler inFlight = (RangeSampler)Metrics$Statements$.MODULE$.InFlight().refine(poolTags);
        inFlight.increment();
        Instant startTimestamp = Kamon$.MODULE$.clock().instant();
        SpanCustomizer spanCustomizer = (SpanCustomizer)Kamon$.MODULE$.currentContext().get(SpanCustomizer$.MODULE$.ContextKey());
        Tracer.SpanBuilder builder = Kamon$.MODULE$.buildSpan(statementType).withFrom(startTimestamp).withTag("component", "jdbc").withTag("db.statement", sql);
        poolTags.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final Tracer.SpanBuilder builder$1;

            public final Tracer.SpanBuilder apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    Tracer.SpanBuilder spanBuilder = this.builder$1.withTag(key, value);
                    return spanBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        Span span = spanCustomizer.customize(builder).start();
        try {
            object = pjp.proceed();
        }
        catch (Throwable throwable) {
            void var8_9;
            try {
                var8_9.addError("error.object", throwable);
                Jdbc$.MODULE$.onStatementError(sql, throwable);
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var6_6;
                void var7_7;
                Instant endTimestamp = Kamon$.MODULE$.clock().instant();
                long elapsedTime = var7_7.until(endTimestamp, ChronoUnit.MICROS);
                var8_9.finish(endTimestamp);
                var6_6.decrement();
                Jdbc$.MODULE$.onStatementFinish(sql, elapsedTime);
                throw throwable2;
            }
        }
        Instant endTimestamp = Kamon$.MODULE$.clock().instant();
        long elapsedTime = startTimestamp.until(endTimestamp, ChronoUnit.MICROS);
        span.finish(endTimestamp);
        inFlight.decrement();
        Jdbc$.MODULE$.onStatementFinish(sql, elapsedTime);
        return object;
    }
}

