/*
 * =========================================================================================
 * Copyright © 2013-2017 the kamon project <http://kamon.io/>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 * =========================================================================================
 */

package kamon.logback

import ch.qos.logback.classic.pattern.ClassicConverter
import ch.qos.logback.classic.spi.ILoggingEvent
import kamon.Kamon
import kamon.trace.{IdentityProvider, Span}

class LogbackTraceIDConverter extends ClassicConverter {

  override def convert(event: ILoggingEvent): String = {
    val currentSpan = Kamon.currentContext().get(Span.ContextKey)
    val traceID = currentSpan.context().traceID

    if(traceID == IdentityProvider.NoIdentifier)
      "undefined"
    else
      traceID.string
  }
}
