/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.pekko.http;

import kamon.Kamon;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.http.HttpClientInstrumentation;
import kamon.instrumentation.http.HttpMessage;
import kamon.instrumentation.pekko.http.PekkoHttpClientInstrumentation;
import kamon.instrumentation.pekko.http.PekkoHttpInstrumentation;
import kamon.trace.Span;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import scala.concurrent.Future;

public class HttpExtSingleRequestAdvice {
    @Advice.OnMethodEnter
    public static void onEnter(@Advice.Argument(value=0, readOnly=false) HttpRequest httpRequest, @Advice.Local(value="handler") HttpClientInstrumentation.RequestHandler<HttpRequest> requestHandler, @Advice.Local(value="scope") Storage.Scope scope) {
        HttpMessage.RequestBuilder<HttpRequest> requestBuilder = PekkoHttpInstrumentation.toRequestBuilder(httpRequest);
        requestHandler = PekkoHttpClientInstrumentation.httpClientInstrumentation().createHandler(requestBuilder, Kamon.currentContext());
        httpRequest = (HttpRequest)requestHandler.request();
        scope = Kamon.storeContext((Context)Kamon.currentContext().withEntry(Span.Key(), (Object)requestHandler.span()));
    }

    @Advice.OnMethodExit
    public static void onExit(@Advice.Return Future<HttpResponse> future, @Advice.Local(value="handler") HttpClientInstrumentation.RequestHandler<HttpRequest> requestHandler, @Advice.Local(value="scope") Storage.Scope scope) {
        PekkoHttpClientInstrumentation.handleResponse(future, requestHandler);
        scope.close();
    }
}

