/*
 * Decompiled with CFR 0.152.
 */
package kamon.prometheus;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001Y4AAD\b\u0001)!A1\u0004\u0001BC\u0002\u0013\u0005A\u0004\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u001e\u0011!I\u0003A!A!\u0002\u0013Q\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u0011M\u0002!\u0011!Q\u0001\n)BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u0010\u0001C\u0002\u0013\u0005Q\b\u0003\u0004E\u0001\u0001\u0006IA\u0010\u0005\u0006i\u0001!\t!\u0012\u0005\u0006#\u0002!IA\u0015\u0005\u0006C\u0002!\tA\u0019\u0005\u0006a\u0002!\t!\u001d\u0005\u0006i\u0002!I!\u001e\u0002\u000b\u0011R$\bo\u00117jK:$(B\u0001\t\u0012\u0003)\u0001(o\\7fi\",Wo\u001d\u0006\u0002%\u0005)1.Y7p]\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u00061\u0011\r]5Ve2,\u0012!\b\t\u0003=\u0015r!aH\u0012\u0011\u0005\u0001:R\"A\u0011\u000b\u0005\t\u001a\u0012A\u0002\u001fs_>$h(\u0003\u0002%/\u00051\u0001K]3eK\u001aL!AJ\u0014\u0003\rM#(/\u001b8h\u0015\t!s#A\u0004ba&,&\u000f\u001c\u0011\u0002\u001d\r|gN\\3diRKW.Z8viB\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\u0005i&lWMC\u00010\u0003\u0011Q\u0017M^1\n\u0005Eb#\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\u0017I,\u0017\r\u001a+j[\u0016|W\u000f^\u0001\roJLG/\u001a+j[\u0016|W\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bYB\u0014HO\u001e\u0011\u0005]\u0002Q\"A\b\t\u000bm1\u0001\u0019A\u000f\t\u000b%2\u0001\u0019\u0001\u0016\t\u000bI2\u0001\u0019\u0001\u0016\t\u000bM2\u0001\u0019\u0001\u0016\u0002\u0015!$H\u000f]\"mS\u0016tG/F\u0001?!\ty$)D\u0001A\u0015\u0005\t\u0015aB8lQR$\boM\u0005\u0003\u0007\u0002\u0013AbT6IiR\u00048\t\\5f]R\f1\u0002\u001b;ua\u000ec\u0017.\u001a8uAQ\u0011aG\u0012\u0005\u0006\u000f&\u0001\r\u0001S\u0001\u0007G>tg-[4\u0011\u0005%{U\"\u0001&\u000b\u0005\u001d[%B\u0001'N\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001(\u0002\u0007\r|W.\u0003\u0002Q\u0015\n11i\u001c8gS\u001e\f\u0011\u0002Z8SKF,Xm\u001d;\u0015\u0005Mc\u0006c\u0001+X36\tQK\u0003\u0002W/\u0005!Q\u000f^5m\u0013\tAVKA\u0002Uef\u0004\"a\u0010.\n\u0005m\u0003%\u0001\u0003*fgB|gn]3\t\u000buS\u0001\u0019\u00010\u0002\u000fI,\u0017/^3tiB\u0011qhX\u0005\u0003A\u0002\u0013qAU3rk\u0016\u001cH/\u0001\te_6+G\u000f[8e/&$\bNQ8esR!1\r\u001a4i!\r!v+\b\u0005\u0006K.\u0001\r!H\u0001\u0007[\u0016$\bn\u001c3\t\u000b\u001d\\\u0001\u0019A\u000f\u0002\u0017\r|g\u000e^3oiRK\b/\u001a\u0005\u0006S.\u0001\rA[\u0001\fG>tG/\u001a8u\u0005>$\u0017\u0010E\u0002\u0017W6L!\u0001\\\f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Yq\u0017BA8\u0018\u0005\u0011\u0011\u0015\u0010^3\u0002\r\u0011|\u0007k\\:u)\r\u0019'o\u001d\u0005\u0006O2\u0001\r!\b\u0005\u0006S2\u0001\rA[\u0001\u0011GJ,\u0017\r^3IiR\u00048\t\\5f]R$\u0012A\u0010")
public class HttpClient {
    private final String apiUrl;
    private final Duration connectTimeout;
    private final Duration readTimeout;
    private final Duration writeTimeout;
    private final OkHttpClient httpClient;

    public String apiUrl() {
        return this.apiUrl;
    }

    public OkHttpClient httpClient() {
        return this.httpClient;
    }

    private Try<Response> doRequest(Request request) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.httpClient().newCall(request).execute());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Try<String> doMethodWithBody(String method, String contentType, byte[] contentBody) {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])contentBody);
        Request request = new Request.Builder().url(this.apiUrl()).method(method, body).build();
        boolean bl = false;
        Failure failure = null;
        Try<Response> try_ = this.doRequest(request);
        if (try_ instanceof Success) {
            Response response = (Response)((Success)try_).value();
            String responseBody = response.body().string();
            response.close();
            return response.isSuccessful() ? new Success((Object)responseBody) : new Failure((Throwable)new Exception(new StringBuilder(74).append("Failed to ").append(method).append(" metrics to Prometheus Pushgateway with status code [").append(response.code()).append("], ").append("Body: [").append(responseBody).append("]").toString()));
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable f = failure.exception();
            if (f.getCause() != null) {
                return new Failure(f.getCause());
            }
        }
        if (!bl) throw new MatchError(try_);
        return failure;
    }

    public Try<String> doPost(String contentType, byte[] contentBody) {
        return this.doMethodWithBody("POST", contentType, contentBody);
    }

    private OkHttpClient createHttpClient() {
        return new OkHttpClient.Builder().connectTimeout(this.connectTimeout.toMillis(), TimeUnit.MILLISECONDS).readTimeout(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS).writeTimeout(this.writeTimeout.toMillis(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(false).build();
    }

    public HttpClient(String apiUrl, Duration connectTimeout, Duration readTimeout, Duration writeTimeout) {
        this.apiUrl = apiUrl;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.httpClient = this.createHttpClient();
    }

    public HttpClient(Config config) {
        this(config.getString("api-url"), config.getDuration("connect-timeout"), config.getDuration("read-timeout"), config.getDuration("write-timeout"));
    }
}

