/*
 * Decompiled with CFR 0.152.
 */
package kamon.prometheus;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kamon.metric.Distribution;
import kamon.metric.Instrument;
import kamon.metric.MeasurementUnit;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import kamon.metric.MetricSnapshot;
import kamon.prometheus.PrometheusSettings;
import kamon.prometheus.ScrapeDataBuilder$;
import kamon.tag.Tag;
import kamon.tag.TagSet;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001\u0002\u0012$\u0001!B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!)q\b\u0001C\u0001\u0001\"9A\t\u0001b\u0001\n\u0013)\u0005B\u0002(\u0001A\u0003%a\tC\u0004P\u0001\t\u0007I\u0011\u0002)\t\r]\u0003\u0001\u0015!\u0003R\u0011\u001dA\u0006A1A\u0005\neCa!\u0018\u0001!\u0002\u0013Q\u0006\"\u00020\u0001\t\u0003y\u0006\"B6\u0001\t\u0003a\u0007bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\ti\u0003\u0001C\u0005\u0003_Aq!!\u000f\u0001\t\u0013\tY\u0004C\u0004\u0002@\u0001!I!!\u0011\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H!I\u0011\u0011\f\u0001\u0012\u0002\u0013%\u00111\f\u0005\b\u0003c\u0002A\u0011BA:\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u0002(\u0002!I!!+\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBA`\u0001\u0011%\u0011\u0011\u0019\u0005\b\u0003\u000f\u0004A\u0011BAe\u0011\u001d\t)\u000e\u0001C\u0005\u0003/Dq!a7\u0001\t\u0013\ti\u000eC\u0004\u0002b\u0002!I!a9\b\u0013\u0005%8%!A\t\u0002\u0005-h\u0001\u0003\u0012$\u0003\u0003E\t!!<\t\r}zB\u0011AAx\u0011%\t\tpHI\u0001\n\u0003\t\u0019PA\tTGJ\f\u0007/\u001a#bi\u0006\u0014U/\u001b7eKJT!\u0001J\u0013\u0002\u0015A\u0014x.\\3uQ\u0016,8OC\u0001'\u0003\u0015Y\u0017-\\8o\u0007\u0001\u0019\"\u0001A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g\u0003A\u0001(o\\7fi\",Wo]\"p]\u001aLw\r\u0005\u00022k9\u0011!gM\u0007\u0002G%\u0011AgI\u0001\u0013!J|W.\u001a;iKV\u001c8+\u001a;uS:<7/\u0003\u00027o\t9q)\u001a8fe&\u001c'B\u0001\u001b$\u0003=)gN^5s_:lWM\u001c;UC\u001e\u001c\bC\u0001\u001e>\u001b\u0005Y$B\u0001\u001f&\u0003\r!\u0018mZ\u0005\u0003}m\u0012a\u0001V1h'\u0016$\u0018A\u0002\u001fj]&$h\bF\u0002B\u0005\u000e\u0003\"A\r\u0001\t\u000b=\u001a\u0001\u0019\u0001\u0019\t\u000fa\u001a\u0001\u0013!a\u0001s\u0005AqLY;jY\u0012,'/F\u0001G!\t9E*D\u0001I\u0015\tI%*\u0001\u0003mC:<'\"A&\u0002\t)\fg/Y\u0005\u0003\u001b\"\u0013Qb\u0015;sS:<')^5mI\u0016\u0014\u0018!C0ck&dG-\u001a:!\u0003UyF-Z2j[\u0006dgi\u001c:nCR\u001c\u00160\u001c2pYN,\u0012!\u0015\t\u0003%Vk\u0011a\u0015\u0006\u0003)*\u000bA\u0001^3yi&\u0011ak\u0015\u0002\u0015\t\u0016\u001c\u0017.\\1m\r>\u0014X.\u0019;Ts6\u0014w\u000e\\:\u0002-}#WmY5nC24uN]7biNKXNY8mg\u0002\nQb\u00188v[\n,'OR8s[\u0006$X#\u0001.\u0011\u0005I[\u0016B\u0001/T\u00055!UmY5nC24uN]7bi\u0006qqL\\;nE\u0016\u0014hi\u001c:nCR\u0004\u0013!\u00022vS2$G#\u00011\u0011\u0005\u0005DgB\u00012g!\t\u00197&D\u0001e\u0015\t)w%\u0001\u0004=e>|GOP\u0005\u0003O.\na\u0001\u0015:fI\u00164\u0017BA5k\u0005\u0019\u0019FO]5oO*\u0011qmK\u0001\u000fCB\u0004XM\u001c3D_VtG/\u001a:t)\t\tU\u000eC\u0003o\u0017\u0001\u0007q.\u0001\u0005d_VtG/\u001a:t!\r\u0001X\u000f\u001f\b\u0003cNt!a\u0019:\n\u00031J!\u0001^\u0016\u0002\u000fA\f7m[1hK&\u0011ao\u001e\u0002\u0004'\u0016\f(B\u0001;,!\u0011Ix0!\u0002\u000f\u0005ilX\"A>\u000b\u0005q,\u0013AB7fiJL7-\u0003\u0002\u007fw\u0006qQ*\u001a;sS\u000e\u001cf.\u00199tQ>$\u0018\u0002BA\u0001\u0003\u0007\u0011aAV1mk\u0016\u001c(B\u0001@|!\rQ\u0013qA\u0005\u0004\u0003\u0013Y#\u0001\u0002'p]\u001e\fA\"\u00199qK:$w)Y;hKN$2!QA\b\u0011\u001d\t\t\u0002\u0004a\u0001\u0003'\taaZ1vO\u0016\u001c\b\u0003\u00029v\u0003+\u0001B!_@\u0002\u0018A\u0019!&!\u0007\n\u0007\u0005m1F\u0001\u0004E_V\u0014G.Z\u0001\u0011CB\u0004XM\u001c3ISN$xn\u001a:b[N$2!QA\u0011\u0011\u001d\t\u0019#\u0004a\u0001\u0003K\t!\u0002[5ti><'/Y7t!\u0011\u0001X/a\n\u0011\u0007e\fI#\u0003\u0003\u0002,\u0005\r!!\u0004#jgR\u0014\u0018NY;uS>t7/A\nbaB,g\u000eZ\"pk:$XM]'fiJL7\r\u0006\u0003\u00022\u0005]\u0002c\u0001\u0016\u00024%\u0019\u0011QG\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0006y:\u0001\r\u0001_\u0001\u0012CB\u0004XM\u001c3HCV<W-T3ue&\u001cG\u0003BA\u0019\u0003{Aa\u0001`\bA\u0002\u0005U\u0011\u0001G1qa\u0016tG\rR5tiJL'-\u001e;j_:lU\r\u001e:jGR!\u0011\u0011GA\"\u0011\u0019a\b\u00031\u0001\u0002(\u0005!\u0012\r\u001d9f]\u0012$\u0016.\\3TKJLWMV1mk\u0016$\"\"!\r\u0002J\u00055\u0013\u0011KA+\u0011\u0019\tY%\u0005a\u0001A\u0006!a.Y7f\u0011\u0019\ty%\u0005a\u0001s\u0005!A/Y4t\u0011\u0019\t\u0019&\u0005a\u0001A\u0006)a/\u00197vK\"A\u0011qK\t\u0011\u0002\u0003\u0007\u0001-\u0001\u0004tk\u001a4\u0017\u000e_\u0001\u001fCB\u0004XM\u001c3US6,7+\u001a:jKZ\u000bG.^3%I\u00164\u0017-\u001e7uIQ*\"!!\u0018+\u0007\u0001\fyf\u000b\u0002\u0002bA!\u00111MA7\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014!C;oG\",7m[3e\u0015\r\tYgK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA8\u0003K\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003i\u0011Xm]8mm\u0016\u0014UoY6fi\u000e{gNZ5hkJ\fG/[8o)\u0019\t)(a\u001f\u0002\u0000A!\u0001/^A<!\r9\u0015\u0011P\u0005\u0004\u00037A\u0005BBA?'\u0001\u0007\u0001-\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016Dq!!!\u0014\u0001\u0004\t\u0019)\u0001\u0003v]&$\bc\u0001>\u0002\u0006&\u0019\u0011qQ>\u0003\u001f5+\u0017m];sK6,g\u000e^+oSR\fa#\u00199qK:$\u0007*[:u_\u001e\u0014\u0018-\u001c\"vG.,Go\u001d\u000b\r\u0003c\ti)a$\u0002\u0012\u0006m\u0015Q\u0014\u0005\u0007\u0003\u0017\"\u0002\u0019\u00011\t\r\u0005=C\u00031\u0001:\u0011\u001d\t\u0019\n\u0006a\u0001\u0003+\u000bA\u0002Z5tiJL'-\u001e;j_:\u00042A_AL\u0013\r\tIj\u001f\u0002\r\t&\u001cHO]5ckRLwN\u001c\u0005\b\u0003\u0003#\u0002\u0019AAB\u0011\u001d\ty\n\u0006a\u0001\u0003k\nqAY;dW\u0016$8/\u0001\u0006baB,g\u000e\u001a+bON$B!!\r\u0002&\"1\u0011qJ\u000bA\u0002e\nQb\u001d;sS:<\u0017NZ=UC\u001e\u001cH\u0003BA\u0019\u0003WCa!a\u0014\u0017\u0001\u0004I\u0014\u0001D1qa\u0016tG\rV1hgR{GCBA\u0019\u0003c\u000b\u0019\f\u0003\u0004\u0002P]\u0001\r!\u000f\u0005\u0007\u0003k;\u0002\u0019\u0001$\u0002\r\t,hMZ3s\u0003MqwN]7bY&TX-T3ue&\u001cg*Y7f)\u0015\u0001\u00171XA_\u0011\u0019\ti\b\u0007a\u0001A\"9\u0011\u0011\u0011\rA\u0002\u0005\r\u0015A\u00058pe6\fG.\u001b>f\u0019\u0006\u0014W\r\u001c(b[\u0016$2\u0001YAb\u0011\u0019\t)-\u0007a\u0001A\u0006)A.\u00192fY\u0006qa/\u00197jI2\u000b'-\u001a7DQ\u0006\u0014H\u0003BAf\u0003#\u00042AKAg\u0013\r\tym\u000b\u0002\u0005\u0007\"\f'\u000fC\u0004\u0002Tj\u0001\r!a3\u0002\t\rD\u0017M]\u0001\u000em\u0006d\u0017\u000e\u001a(b[\u0016\u001c\u0005.\u0019:\u0015\t\u0005-\u0017\u0011\u001c\u0005\b\u0003'\\\u0002\u0019AAf\u0003\u00191wN]7biR\u0019\u0001-a8\t\u000f\u0005MC\u00041\u0001\u0002\u0018\u000591m\u001c8wKJ$HCBA\f\u0003K\f9\u000fC\u0004\u0002Tu\u0001\r!a\u0006\t\u000f\u0005\u0005U\u00041\u0001\u0002\u0004\u0006\t2k\u0019:ba\u0016$\u0015\r^1Ck&dG-\u001a:\u0011\u0005Iz2CA\u0010*)\t\tY/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003kT3!OA0\u0001")
public class ScrapeDataBuilder {
    private final PrometheusSettings.Generic prometheusConfig;
    private final TagSet environmentTags;
    private final StringBuilder _builder;
    private final DecimalFormatSymbols _decimalFormatSymbols;
    private final DecimalFormat _numberFormat;

    public static TagSet $lessinit$greater$default$2() {
        return ScrapeDataBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    private StringBuilder _builder() {
        return this._builder;
    }

    private DecimalFormatSymbols _decimalFormatSymbols() {
        return this._decimalFormatSymbols;
    }

    private DecimalFormat _numberFormat() {
        return this._numberFormat;
    }

    public String build() {
        return this._builder().toString();
    }

    public ScrapeDataBuilder appendCounters(Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>> counters) {
        counters.foreach((Function1 & Serializable & scala.Serializable)metric -> {
            this.appendCounterMetric((MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ScrapeDataBuilder appendGauges(Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>> gauges) {
        gauges.foreach((Function1 & Serializable & scala.Serializable)metric -> {
            this.appendGaugeMetric((MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ScrapeDataBuilder appendHistograms(Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>> histograms) {
        histograms.foreach((Function1 & Serializable & scala.Serializable)metric -> {
            this.appendDistributionMetric((MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    private void appendCounterMetric(MetricSnapshot<Metric.Settings.ForValueInstrument, Object> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForValueInstrument)metric.settings()).unit();
        String normalizedMetricName = new StringBuilder(6).append(this.normalizeMetricName(metric.name(), unit)).append("_total").toString();
        if (new StringOps(Predef$.MODULE$.augmentString(metric.description())).nonEmpty()) {
            this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n");
        }
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" counter\n");
        metric.instruments().foreach((Function1 & Serializable & scala.Serializable)instrument -> {
            this._builder().append(normalizedMetricName);
            this.appendTags(instrument.tags());
            this._builder().append(" ");
            this._builder().append(this.format(this.convert(BoxesRunTime.unboxToLong((Object)instrument.value()), unit)));
            return this._builder().append("\n");
        });
    }

    private void appendGaugeMetric(MetricSnapshot<Metric.Settings.ForValueInstrument, Object> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForValueInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeMetricName(metric.name(), unit);
        if (new StringOps(Predef$.MODULE$.augmentString(metric.description())).nonEmpty()) {
            this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n");
        }
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" gauge\n");
        metric.instruments().foreach((Function1 & Serializable & scala.Serializable)instrument -> {
            this._builder().append(normalizedMetricName);
            this.appendTags(instrument.tags());
            this._builder().append(" ");
            this._builder().append(this.format(this.convert(BoxesRunTime.unboxToDouble((Object)instrument.value()), unit)));
            return this._builder().append("\n");
        });
    }

    private void appendDistributionMetric(MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeMetricName(metric.name(), unit);
        if (new StringOps(Predef$.MODULE$.augmentString(metric.description())).nonEmpty()) {
            this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n");
        }
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" histogram").append("\n");
        metric.instruments().foreach((Function1 & Serializable & scala.Serializable)instrument -> {
            ScrapeDataBuilder.$anonfun$appendDistributionMetric$1(this, normalizedMetricName, unit, metric, instrument);
            return BoxedUnit.UNIT;
        });
    }

    private void appendTimeSerieValue(String name, TagSet tags, String value, String suffix) {
        this._builder().append(name);
        this._builder().append(suffix);
        this.appendTags(tags);
        this._builder().append(" ");
        this._builder().append(value);
        this._builder().append("\n");
    }

    private String appendTimeSerieValue$default$4() {
        return "";
    }

    private Seq<Double> resolveBucketConfiguration(String metricName, MeasurementUnit unit) {
        return (Seq)this.prometheusConfig.customBuckets().getOrElse((Object)metricName, (Function0 & Serializable & scala.Serializable)() -> {
            Seq<Double> seq;
            MeasurementUnit.Dimension dimension = unit.dimension();
            MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
            if (!(dimension2 != null ? !dimension2.equals(dimension) : dimension != null)) {
                seq = $this.prometheusConfig.timeBuckets();
            } else {
                MeasurementUnit.Dimension dimension3 = MeasurementUnit.Dimension$.MODULE$.Information();
                seq = !(dimension3 != null ? !dimension3.equals(dimension) : dimension != null) ? $this.prometheusConfig.informationBuckets() : $this.prometheusConfig.defaultBuckets();
            }
            return seq;
        });
    }

    private void appendHistogramBuckets(String name, TagSet tags, Distribution distribution, MeasurementUnit unit, Seq<Double> buckets) {
        Iterator distributionBuckets = distribution.bucketsIterator();
        ObjectRef currentDistributionBucket = ObjectRef.create((Object)((Distribution.Bucket)distributionBuckets.next()));
        DoubleRef currentDistributionBucketValue = DoubleRef.create((double)this.convert(((Distribution.Bucket)currentDistributionBucket.elem).value(), unit));
        LongRef inBucketCount = LongRef.create((long)0L);
        LongRef leftOver = LongRef.create((long)((Distribution.Bucket)currentDistributionBucket.elem).frequency());
        buckets.foreach((Function1 & Serializable & scala.Serializable)configuredBucket -> {
            ScrapeDataBuilder.$anonfun$appendHistogramBuckets$1(this, tags, currentDistributionBucketValue, inBucketCount, leftOver, distributionBuckets, currentDistributionBucket, unit, name, configuredBucket);
            return BoxedUnit.UNIT;
        });
        while (distributionBuckets.hasNext()) {
            leftOver.elem += ((Distribution.Bucket)distributionBuckets.next()).frequency();
        }
        this.appendTimeSerieValue(name, tags.withTag("le", "+Inf"), this.format(leftOver.elem + inBucketCount.elem), "_bucket");
    }

    private void appendTags(TagSet tags) {
        this.appendTagsTo(tags, this._builder());
    }

    private void stringifyTags(TagSet tags) {
        StringBuilder builder = new StringBuilder();
        this.appendTagsTo(tags, builder);
        builder.toString();
    }

    private void appendTagsTo(TagSet tags, StringBuilder buffer) {
        TagSet allTags = tags.withTags(this.environmentTags);
        if (allTags.nonEmpty()) {
            buffer.append("{");
        }
        Iterator tagIterator = allTags.iterator((Function1 & Serializable & scala.Serializable)v -> {
            if (v == null) {
                return "";
            }
            return v.toString();
        });
        int tagCount = 0;
        while (tagIterator.hasNext()) {
            Tag.Pair pair = (Tag.Pair)tagIterator.next();
            if (tagCount > 0) {
                buffer.append(",");
            }
            buffer.append(this.normalizeLabelName(pair.key())).append("=\"").append((String)pair.value()).append('\"');
            ++tagCount;
        }
        if (allTags.nonEmpty()) {
            buffer.append("}");
        }
    }

    private String normalizeMetricName(String metricName, MeasurementUnit unit) {
        String string;
        String normalizedMetricName = (String)new StringOps(Predef$.MODULE$.augmentString(metricName)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToCharacter((char)this.validNameChar(BoxesRunTime.unboxToChar((Object)x$1))), Predef$.MODULE$.StringCanBuildFrom());
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        if (!(dimension2 != null ? !dimension2.equals(dimension) : dimension != null)) {
            string = new StringBuilder(8).append(normalizedMetricName).append("_seconds").toString();
        } else {
            MeasurementUnit.Dimension dimension3 = MeasurementUnit.Dimension$.MODULE$.Information();
            string = !(dimension3 != null ? !dimension3.equals(dimension) : dimension != null) ? new StringBuilder(6).append(normalizedMetricName).append("_bytes").toString() : normalizedMetricName;
        }
        return string;
    }

    private String normalizeLabelName(String label) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(label)).map((Function1 & Serializable & scala.Serializable)object -> BoxesRunTime.boxToCharacter((char)this.validLabelChar(BoxesRunTime.unboxToChar((Object)object))), Predef$.MODULE$.StringCanBuildFrom());
    }

    private char validLabelChar(char c) {
        if (RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '_') {
            return c;
        }
        return '_';
    }

    private char validNameChar(char c) {
        if (RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '_' || c == ':') {
            return c;
        }
        return '_';
    }

    private String format(double value) {
        return this._numberFormat().format(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double convert(double value, MeasurementUnit unit) {
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        if (!(dimension2 != null ? !dimension2.equals(dimension) : dimension != null)) {
            MeasurementUnit.Magnitude magnitude = unit.magnitude();
            MeasurementUnit.Magnitude magnitude2 = MeasurementUnit$.MODULE$.time().seconds().magnitude();
            if (magnitude == null ? magnitude2 != null : !magnitude.equals(magnitude2)) {
                return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.time().seconds());
            }
        }
        MeasurementUnit.Dimension dimension3 = MeasurementUnit.Dimension$.MODULE$.Information();
        if (dimension3 == null) {
            if (dimension != null) {
                return value;
            }
        } else if (!dimension3.equals(dimension)) return value;
        MeasurementUnit.Magnitude magnitude = unit.magnitude();
        MeasurementUnit.Magnitude magnitude3 = MeasurementUnit$.MODULE$.information().bytes().magnitude();
        if (magnitude == null) {
            if (magnitude3 == null) return value;
            return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.information().bytes());
        } else if (magnitude.equals(magnitude3)) return value;
        return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.information().bytes());
    }

    public static final /* synthetic */ void $anonfun$appendDistributionMetric$1(ScrapeDataBuilder $this, String normalizedMetricName$3, MeasurementUnit unit$3, MetricSnapshot metric$1, Instrument.Snapshot instrument) {
        if (((Distribution)instrument.value()).count() > 0L) {
            $this.appendHistogramBuckets(normalizedMetricName$3, instrument.tags(), (Distribution)instrument.value(), unit$3, $this.resolveBucketConfiguration(metric$1.name(), unit$3));
            String count = $this.format(((Distribution)instrument.value()).count());
            String sum = $this.format($this.convert(((Distribution)instrument.value()).sum(), unit$3));
            $this.appendTimeSerieValue(normalizedMetricName$3, instrument.tags(), count, "_count");
            $this.appendTimeSerieValue(normalizedMetricName$3, instrument.tags(), sum, "_sum");
        }
    }

    public static final /* synthetic */ void $anonfun$appendHistogramBuckets$1(ScrapeDataBuilder $this, TagSet tags$1, DoubleRef currentDistributionBucketValue$1, LongRef inBucketCount$1, LongRef leftOver$1, Iterator distributionBuckets$1, ObjectRef currentDistributionBucket$1, MeasurementUnit unit$5, String name$1, Double configuredBucket) {
        TagSet bucketTags = tags$1.withTag("le", String.valueOf(configuredBucket));
        if (currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
            inBucketCount$1.elem += leftOver$1.elem;
            leftOver$1.elem = 0L;
            while (distributionBuckets$1.hasNext() && currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
                currentDistributionBucket$1.elem = (Distribution.Bucket)distributionBuckets$1.next();
                currentDistributionBucketValue$1.elem = $this.convert(((Distribution.Bucket)currentDistributionBucket$1.elem).value(), unit$5);
                if (currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
                    inBucketCount$1.elem += ((Distribution.Bucket)currentDistributionBucket$1.elem).frequency();
                    continue;
                }
                leftOver$1.elem = ((Distribution.Bucket)currentDistributionBucket$1.elem).frequency();
            }
        }
        $this.appendTimeSerieValue(name$1, bucketTags, $this.format(inBucketCount$1.elem), "_bucket");
    }

    public ScrapeDataBuilder(PrometheusSettings.Generic prometheusConfig, TagSet environmentTags) {
        this.prometheusConfig = prometheusConfig;
        this.environmentTags = environmentTags;
        this._builder = new StringBuilder();
        this._decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.ROOT);
        this._numberFormat = new DecimalFormat("#0.0########", this._decimalFormatSymbols());
    }
}

