/*
 * Decompiled with CFR 0.152.
 */
package kamon.prometheus;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kamon.metric.Distribution;
import kamon.metric.Instrument;
import kamon.metric.MeasurementUnit;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import kamon.metric.MetricSnapshot;
import kamon.prometheus.PrometheusSettings;
import kamon.prometheus.ScrapeDataBuilder$;
import kamon.tag.Tag;
import kamon.tag.TagSet;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t=b\u0001B\u0014)\u00015B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!)A\t\u0001C\u0001\u000b\"9\u0011\n\u0001b\u0001\n\u0013Q\u0005BB*\u0001A\u0003%1\nC\u0004U\u0001\t\u0007I\u0011B+\t\rq\u0003\u0001\u0015!\u0003W\u0011\u001di\u0006A1A\u0005\nyCaA\u0019\u0001!\u0002\u0013y\u0006\"B2\u0001\t\u0003!\u0007\"\u00029\u0001\t\u0003\t\bbBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\t9\u0004\u0001C\u0005\u0003sAq!a\u0011\u0001\t\u0013\t)\u0005C\u0004\u0002J\u0001!I!a\u0013\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R!9\u0011Q\u000b\u0001\u0005\n\u0005]\u0003bBA.\u0001\u0011%\u0011Q\f\u0005\n\u0003_\u0002\u0011\u0013!C\u0005\u0003cBq!a\"\u0001\t\u0013\tI\tC\u0004\u0002 \u0002!I!!)\t\u000f\u0005]\u0006\u0001\"\u0003\u0002:\"9\u0011q\u0019\u0001\u0005\n\u0005%\u0007bBAg\u0001\u0011%\u0011q\u001a\u0005\b\u0003'\u0004A\u0011BAk\u0011\u001d\ti\u000e\u0001C\u0005\u0003?Dq!!:\u0001\t\u0013\t9\u000fC\u0004\u0002n\u0002!I!a<\t\u000f\u0005]\b\u0001\"\u0003\u0002z\"9\u0011q \u0001\u0005\n\t\u0005\u0001b\u0002B\u0007\u0001\u0011%!q\u0002\u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0011\u001d\u0011I\u0002\u0001C\u0005\u000579\u0011B!\t)\u0003\u0003E\tAa\t\u0007\u0011\u001dB\u0013\u0011!E\u0001\u0005KAa\u0001\u0012\u0013\u0005\u0002\t\u001d\u0002\"\u0003B\u0015IE\u0005I\u0011\u0001B\u0016\u0005E\u00196M]1qK\u0012\u000bG/\u0019\"vS2$WM\u001d\u0006\u0003S)\n!\u0002\u001d:p[\u0016$\b.Z;t\u0015\u0005Y\u0013!B6b[>t7\u0001A\n\u0003\u00019\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0017\u0001\u00059s_6,G\u000f[3vg\u000e{gNZ5h!\t1$H\u0004\u00028q5\t\u0001&\u0003\u0002:Q\u0005\u0011\u0002K]8nKRDW-^:TKR$\u0018N\\4t\u0013\tYDHA\u0004HK:,'/[2\u000b\u0005eB\u0013aD3om&\u0014xN\\7f]R$\u0016mZ:\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005S\u0013a\u0001;bO&\u00111\t\u0011\u0002\u0007)\u0006<7+\u001a;\u0002\rqJg.\u001b;?)\r1u\t\u0013\t\u0003o\u0001AQ\u0001N\u0002A\u0002UBq!P\u0002\u0011\u0002\u0003\u0007a(\u0001\u0005`EVLG\u000eZ3s+\u0005Y\u0005C\u0001'R\u001b\u0005i%B\u0001(P\u0003\u0011a\u0017M\\4\u000b\u0003A\u000bAA[1wC&\u0011!+\u0014\u0002\u000e'R\u0014\u0018N\\4Ck&dG-\u001a:\u0002\u0013}\u0013W/\u001b7eKJ\u0004\u0013!F0eK\u000eLW.\u00197G_Jl\u0017\r^*z[\n|Gn]\u000b\u0002-B\u0011qKW\u0007\u00021*\u0011\u0011lT\u0001\u0005i\u0016DH/\u0003\u0002\\1\n!B)Z2j[\u0006dgi\u001c:nCR\u001c\u00160\u001c2pYN\fac\u00183fG&l\u0017\r\u001c$pe6\fGoU=nE>d7\u000fI\u0001\u000e?:,XNY3s\r>\u0014X.\u0019;\u0016\u0003}\u0003\"a\u00161\n\u0005\u0005D&!\u0004#fG&l\u0017\r\u001c$pe6\fG/\u0001\b`]Vl'-\u001a:G_Jl\u0017\r\u001e\u0011\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u0003\u0015\u0004\"AZ7\u000f\u0005\u001d\\\u0007C\u000151\u001b\u0005I'B\u00016-\u0003\u0019a$o\\8u}%\u0011A\u000eM\u0001\u0007!J,G-\u001a4\n\u00059|'AB*ue&twM\u0003\u0002ma\u0005q\u0011\r\u001d9f]\u0012\u001cu.\u001e8uKJ\u001cHC\u0001$s\u0011\u0015\u00198\u00021\u0001u\u0003!\u0019w.\u001e8uKJ\u001c\bcA;{{:\u0011a\u000f\u001f\b\u0003Q^L\u0011!M\u0005\u0003sB\nq\u0001]1dW\u0006<W-\u0003\u0002|y\n\u00191+Z9\u000b\u0005e\u0004\u0004#\u0002@\u0002\n\u0005=abA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007Q\u0013AB7fiJL7-\u0003\u0003\u0002\b\u0005\u0005\u0011AD'fiJL7m\u00158baNDw\u000e^\u0005\u0005\u0003\u0017\tiA\u0001\u0004WC2,Xm\u001d\u0006\u0005\u0003\u000f\t\t\u0001E\u00020\u0003#I1!a\u00051\u0005\u0011auN\\4\u0002\u0019\u0005\u0004\b/\u001a8e\u000f\u0006,x-Z:\u0015\u0007\u0019\u000bI\u0002C\u0004\u0002\u001c1\u0001\r!!\b\u0002\r\u001d\fWoZ3t!\u0011)(0a\b\u0011\u000by\fI!!\t\u0011\u0007=\n\u0019#C\u0002\u0002&A\u0012a\u0001R8vE2,\u0017\u0001E1qa\u0016tG\rS5ti><'/Y7t)\r1\u00151\u0006\u0005\b\u0003[i\u0001\u0019AA\u0018\u0003)A\u0017n\u001d;pOJ\fWn\u001d\t\u0005kj\f\t\u0004E\u0002\u007f\u0003gIA!!\u000e\u0002\u000e\tiA)[:ue&\u0014W\u000f^5p]N\f1#\u00199qK:$7i\\;oi\u0016\u0014X*\u001a;sS\u000e$B!a\u000f\u0002BA\u0019q&!\u0010\n\u0007\u0005}\u0002G\u0001\u0003V]&$\bBBA\u0002\u001d\u0001\u0007Q0A\tbaB,g\u000eZ$bk\u001e,W*\u001a;sS\u000e$B!a\u000f\u0002H!9\u00111A\bA\u0002\u0005}\u0011\u0001G1qa\u0016tG\rR5tiJL'-\u001e;j_:lU\r\u001e:jGR!\u00111HA'\u0011\u001d\t\u0019\u0001\u0005a\u0001\u0003c\t1%\u00199qK:$G)[:ue&\u0014W\u000f^5p]6+GO]5d\u0003ND\u0015n\u001d;pOJ\fW\u000e\u0006\u0003\u0002<\u0005M\u0003bBA\u0002#\u0001\u0007\u0011\u0011G\u0001\"CB\u0004XM\u001c3ESN$(/\u001b2vi&|g.T3ue&\u001c\u0017i]*v[6\f'/\u001f\u000b\u0005\u0003w\tI\u0006C\u0004\u0002\u0004I\u0001\r!!\r\u0002)\u0005\u0004\b/\u001a8e)&lWmU3sS\u00164\u0016\r\\;f))\tY$a\u0018\u0002d\u0005\u001d\u00141\u000e\u0005\u0007\u0003C\u001a\u0002\u0019A3\u0002\t9\fW.\u001a\u0005\u0007\u0003K\u001a\u0002\u0019\u0001 \u0002\tQ\fwm\u001d\u0005\u0007\u0003S\u001a\u0002\u0019A3\u0002\u000bY\fG.^3\t\u0011\u000554\u0003%AA\u0002\u0015\faa];gM&D\u0018AH1qa\u0016tG\rV5nKN+'/[3WC2,X\r\n3fM\u0006,H\u000e\u001e\u00135+\t\t\u0019HK\u0002f\u0003kZ#!a\u001e\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003\u0003\u0014AC1o]>$\u0018\r^5p]&!\u0011QQA>\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001be\u0016\u001cx\u000e\u001c<f\u0005V\u001c7.\u001a;D_:4\u0017nZ;sCRLwN\u001c\u000b\u0007\u0003\u0017\u000b\t*!&\u0011\tUT\u0018Q\u0012\t\u0004\u0019\u0006=\u0015bAA\u0013\u001b\"1\u00111S\u000bA\u0002\u0015\f!\"\\3ue&\u001cg*Y7f\u0011\u001d\t9*\u0006a\u0001\u00033\u000bA!\u001e8jiB\u0019q0a'\n\t\u0005u\u0015\u0011\u0001\u0002\u0010\u001b\u0016\f7/\u001e:f[\u0016tG/\u00168ji\u00061\u0012\r\u001d9f]\u0012\u001cV/\\7bef\fV/\u00198uS2,7\u000f\u0006\u0007\u0002<\u0005\r\u0016QUAT\u0003c\u000b\u0019\f\u0003\u0004\u0002bY\u0001\r!\u001a\u0005\u0007\u0003K2\u0002\u0019\u0001 \t\u000f\u0005%f\u00031\u0001\u0002,\u0006aA-[:ue&\u0014W\u000f^5p]B\u0019q0!,\n\t\u0005=\u0016\u0011\u0001\u0002\r\t&\u001cHO]5ckRLwN\u001c\u0005\b\u0003/3\u0002\u0019AAM\u0011\u001d\t)L\u0006a\u0001\u0003\u0017\u000b\u0011\"];b]RLG.Z:\u0002-\u0005\u0004\b/\u001a8e\u0011&\u001cHo\\4sC6\u0014UoY6fiN$B\"a\u000f\u0002<\u0006u\u0016qXAa\u0003\u0007Da!!\u0019\u0018\u0001\u0004)\u0007BBA3/\u0001\u0007a\bC\u0004\u0002*^\u0001\r!a+\t\u000f\u0005]u\u00031\u0001\u0002\u001a\"9\u0011QY\fA\u0002\u0005-\u0015a\u00022vG.,Go]\u0001\u000bCB\u0004XM\u001c3UC\u001e\u001cH\u0003BA\u001e\u0003\u0017Da!!\u001a\u0019\u0001\u0004q\u0014!D:ue&tw-\u001b4z)\u0006<7\u000f\u0006\u0003\u0002<\u0005E\u0007BBA33\u0001\u0007a(\u0001\u0007baB,g\u000e\u001a+bON$v\u000e\u0006\u0004\u0002<\u0005]\u0017\u0011\u001c\u0005\u0007\u0003KR\u0002\u0019\u0001 \t\r\u0005m'\u00041\u0001L\u0003\u0019\u0011WO\u001a4fe\u0006Qbn\u001c:nC2L'0Z\"pk:$XM]'fiJL7MT1nKR)Q-!9\u0002d\"1\u00111S\u000eA\u0002\u0015Dq!a&\u001c\u0001\u0004\tI*A\no_Jl\u0017\r\\5{K6+GO]5d\u001d\u0006lW\rF\u0003f\u0003S\fY\u000f\u0003\u0004\u0002\u0014r\u0001\r!\u001a\u0005\b\u0003/c\u0002\u0019AAM\u0003]\tG\r\u001a)pgR4\u0017\u000e_(oYfLe-T5tg&tw\rF\u0003f\u0003c\f\u0019\u0010\u0003\u0004\u0002\u0014v\u0001\r!\u001a\u0005\u0007\u0003kl\u0002\u0019A3\u0002\u000fA|7\u000f\u001e4jq\u0006\u0011bn\u001c:nC2L'0\u001a'bE\u0016dg*Y7f)\r)\u00171 \u0005\u0007\u0003{t\u0002\u0019A3\u0002\u000b1\f'-\u001a7\u0002\u001dY\fG.\u001b3MC\n,Gn\u00115beR!!1\u0001B\u0005!\ry#QA\u0005\u0004\u0005\u000f\u0001$\u0001B\"iCJDqAa\u0003 \u0001\u0004\u0011\u0019!\u0001\u0003dQ\u0006\u0014\u0018!\u0004<bY&$g*Y7f\u0007\"\f'\u000f\u0006\u0003\u0003\u0004\tE\u0001b\u0002B\u0006A\u0001\u0007!1A\u0001\u0007M>\u0014X.\u0019;\u0015\u0007\u0015\u00149\u0002C\u0004\u0002j\u0005\u0002\r!!\t\u0002\u000f\r|gN^3siR1\u0011\u0011\u0005B\u000f\u0005?Aq!!\u001b#\u0001\u0004\t\t\u0003C\u0004\u0002\u0018\n\u0002\r!!'\u0002#M\u001b'/\u00199f\t\u0006$\u0018MQ;jY\u0012,'\u000f\u0005\u00028IM\u0011AE\f\u000b\u0003\u0005G\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0017U\rq\u0014Q\u000f")
public class ScrapeDataBuilder {
    private final PrometheusSettings.Generic prometheusConfig;
    private final TagSet environmentTags;
    private final StringBuilder _builder;
    private final DecimalFormatSymbols _decimalFormatSymbols;
    private final DecimalFormat _numberFormat;

    public static TagSet $lessinit$greater$default$2() {
        return ScrapeDataBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    private StringBuilder _builder() {
        return this._builder;
    }

    private DecimalFormatSymbols _decimalFormatSymbols() {
        return this._decimalFormatSymbols;
    }

    private DecimalFormat _numberFormat() {
        return this._numberFormat;
    }

    public String build() {
        return this._builder().toString();
    }

    public ScrapeDataBuilder appendCounters(Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>> counters) {
        counters.foreach((Function1 & Serializable)metric -> {
            this.appendCounterMetric((MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ScrapeDataBuilder appendGauges(Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>> gauges) {
        gauges.foreach((Function1 & Serializable)metric -> {
            this.appendGaugeMetric((MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ScrapeDataBuilder appendHistograms(Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>> histograms) {
        histograms.foreach((Function1 & Serializable)metric -> {
            this.appendDistributionMetric((MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    private void appendCounterMetric(MetricSnapshot<Metric.Settings.ForValueInstrument, Object> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForValueInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeCounterMetricName(metric.name(), unit);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" counter\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            this._builder().append(normalizedMetricName);
            this.appendTags(instrument.tags());
            this._builder().append(" ");
            this._builder().append(this.format(this.convert(BoxesRunTime.unboxToLong((Object)instrument.value()), unit)));
            return this._builder().append("\n");
        });
    }

    private void appendGaugeMetric(MetricSnapshot<Metric.Settings.ForValueInstrument, Object> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForValueInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeMetricName(metric.name(), unit);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" gauge\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            this._builder().append(normalizedMetricName);
            this.appendTags(instrument.tags());
            this._builder().append(" ");
            this._builder().append(this.format(this.convert(BoxesRunTime.unboxToDouble((Object)instrument.value()), unit)));
            return this._builder().append("\n");
        });
    }

    private void appendDistributionMetric(MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution> metric) {
        boolean reportAsSummary = this.prometheusConfig.summarySettings().metricMatchers().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.accept(metric.name())));
        if (reportAsSummary) {
            this.appendDistributionMetricAsSummary(metric);
        } else {
            this.appendDistributionMetricAsHistogram(metric);
        }
    }

    private void appendDistributionMetricAsHistogram(MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeMetricName(metric.name(), unit);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" histogram").append("\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            ScrapeDataBuilder.$anonfun$appendDistributionMetricAsHistogram$1(this, normalizedMetricName, unit, metric, instrument);
            return BoxedUnit.UNIT;
        });
    }

    private void appendDistributionMetricAsSummary(MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeMetricName(metric.name(), unit);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" summary").append("\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            ScrapeDataBuilder.$anonfun$appendDistributionMetricAsSummary$1(this, normalizedMetricName, unit, instrument);
            return BoxedUnit.UNIT;
        });
    }

    private void appendTimeSerieValue(String name, TagSet tags, String value, String suffix) {
        this._builder().append(name);
        this._builder().append(suffix);
        this.appendTags(tags);
        this._builder().append(" ");
        this._builder().append(value);
        this._builder().append("\n");
    }

    private String appendTimeSerieValue$default$4() {
        return "";
    }

    private Seq<Double> resolveBucketConfiguration(String metricName, MeasurementUnit unit) {
        return (Seq)this.prometheusConfig.customBuckets().getOrElse((Object)metricName, (Function0 & Serializable)() -> {
            Seq<Double> seq;
            MeasurementUnit.Dimension dimension = unit.dimension();
            MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
            MeasurementUnit.Dimension dimension3 = dimension;
            if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
                seq = $this.prometheusConfig.timeBuckets();
            } else {
                MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
                MeasurementUnit.Dimension dimension5 = dimension;
                seq = !(dimension4 != null ? !dimension4.equals(dimension5) : dimension5 != null) ? $this.prometheusConfig.informationBuckets() : $this.prometheusConfig.defaultBuckets();
            }
            return seq;
        });
    }

    private void appendSummaryQuantiles(String name, TagSet tags, Distribution distribution, MeasurementUnit unit, Seq<Double> quantiles) {
        Iterator percentileIter = distribution.percentilesIterator();
        Seq percentiles = (Seq)((IterableOps)quantiles.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).map((Function1 & Serializable)quant -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(quant), percentileIter.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ScrapeDataBuilder.$anonfun$appendSummaryQuantiles$2(quant, x$2))).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        percentiles.foreach((Function1 & Serializable)x0$1 -> {
            ScrapeDataBuilder.$anonfun$appendSummaryQuantiles$5(this, tags, name, unit, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void appendHistogramBuckets(String name, TagSet tags, Distribution distribution, MeasurementUnit unit, Seq<Double> buckets) {
        Iterator distributionBuckets = distribution.bucketsIterator();
        ObjectRef currentDistributionBucket = ObjectRef.create((Object)((Distribution.Bucket)distributionBuckets.next()));
        DoubleRef currentDistributionBucketValue = DoubleRef.create((double)this.convert(((Distribution.Bucket)currentDistributionBucket.elem).value(), unit));
        LongRef inBucketCount = LongRef.create((long)0L);
        LongRef leftOver = LongRef.create((long)((Distribution.Bucket)currentDistributionBucket.elem).frequency());
        buckets.foreach((Function1 & Serializable)configuredBucket -> {
            ScrapeDataBuilder.$anonfun$appendHistogramBuckets$1(this, tags, currentDistributionBucketValue, inBucketCount, leftOver, distributionBuckets, currentDistributionBucket, unit, name, configuredBucket);
            return BoxedUnit.UNIT;
        });
        while (distributionBuckets.hasNext()) {
            leftOver.elem += ((Distribution.Bucket)distributionBuckets.next()).frequency();
        }
        this.appendTimeSerieValue(name, tags.withTag("le", "+Inf"), this.format(leftOver.elem + inBucketCount.elem), "_bucket");
    }

    private void appendTags(TagSet tags) {
        this.appendTagsTo(tags, this._builder());
    }

    private void stringifyTags(TagSet tags) {
        StringBuilder builder = new StringBuilder();
        this.appendTagsTo(tags, builder);
        builder.toString();
    }

    private void appendTagsTo(TagSet tags, StringBuilder buffer) {
        block1: {
            TagSet allTags = tags.withTags(this.environmentTags);
            Object object = allTags.nonEmpty() ? buffer.append("{") : BoxedUnit.UNIT;
            Iterator tagIterator = allTags.iterator((Function1 & Serializable)v -> v == null ? "" : v.toString());
            int tagCount = 0;
            while (tagIterator.hasNext()) {
                Tag.Pair pair = (Tag.Pair)tagIterator.next();
                Object object2 = tagCount > 0 ? buffer.append(",") : BoxedUnit.UNIT;
                buffer.append(this.normalizeLabelName(pair.key())).append("=\"").append((String)pair.value()).append('\"');
                ++tagCount;
            }
            if (!allTags.nonEmpty()) break block1;
            buffer.append("}");
        }
    }

    private String normalizeCounterMetricName(String metricName, MeasurementUnit unit) {
        String string;
        String normalizedMetricName = StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(metricName), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToCharacter((char)this.validNameChar(BoxesRunTime.unboxToChar((Object)x$4))));
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            string = this.addPostfixOnlyIfMissing(normalizedMetricName, "_seconds_total");
        } else {
            MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
            MeasurementUnit.Dimension dimension5 = dimension;
            string = !(dimension4 != null ? !dimension4.equals(dimension5) : dimension5 != null) ? this.addPostfixOnlyIfMissing(normalizedMetricName, "_bytes_total") : this.addPostfixOnlyIfMissing(normalizedMetricName, "_total");
        }
        return string;
    }

    private String normalizeMetricName(String metricName, MeasurementUnit unit) {
        String string;
        String normalizedMetricName = StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(metricName), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToCharacter((char)this.validNameChar(BoxesRunTime.unboxToChar((Object)x$5))));
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            string = this.addPostfixOnlyIfMissing(normalizedMetricName, "_seconds");
        } else {
            MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
            MeasurementUnit.Dimension dimension5 = dimension;
            string = !(dimension4 != null ? !dimension4.equals(dimension5) : dimension5 != null) ? this.addPostfixOnlyIfMissing(normalizedMetricName, "_bytes") : normalizedMetricName;
        }
        return string;
    }

    private String addPostfixOnlyIfMissing(String metricName, String postfix) {
        return metricName.endsWith(postfix) ? metricName : new StringBuilder(0).append(metricName).append(postfix).toString();
    }

    private String normalizeLabelName(String label) {
        return StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(label), (Function1 & Serializable)object -> BoxesRunTime.boxToCharacter((char)this.validLabelChar(BoxesRunTime.unboxToChar((Object)object))));
    }

    private char validLabelChar(char n) {
        return (char)(RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper((char)n)) || n == 95 ? n : 95);
    }

    private char validNameChar(char n) {
        return (char)(RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper((char)n)) || n == 95 || n == 58 ? n : 95);
    }

    private String format(double value) {
        return this._numberFormat().format(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double convert(double value, MeasurementUnit unit) {
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            MeasurementUnit.Magnitude magnitude = unit.magnitude();
            MeasurementUnit.Magnitude magnitude2 = MeasurementUnit$.MODULE$.time().seconds().magnitude();
            if (magnitude == null ? magnitude2 != null : !magnitude.equals(magnitude2)) {
                return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.time().seconds());
            }
        }
        MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
        MeasurementUnit.Dimension dimension5 = dimension;
        if (dimension4 == null) {
            if (dimension5 != null) {
                return value;
            }
        } else if (!dimension4.equals(dimension5)) return value;
        MeasurementUnit.Magnitude magnitude = unit.magnitude();
        MeasurementUnit.Magnitude magnitude3 = MeasurementUnit$.MODULE$.information().bytes().magnitude();
        if (magnitude == null) {
            if (magnitude3 == null) return value;
            return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.information().bytes());
        } else if (magnitude.equals(magnitude3)) return value;
        return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.information().bytes());
    }

    public static final /* synthetic */ void $anonfun$appendDistributionMetricAsHistogram$1(ScrapeDataBuilder $this, String normalizedMetricName$3, MeasurementUnit unit$3, MetricSnapshot metric$2, Instrument.Snapshot instrument) {
        block0: {
            if (((Distribution)instrument.value()).count() <= 0L) break block0;
            $this.appendHistogramBuckets(normalizedMetricName$3, instrument.tags(), (Distribution)instrument.value(), unit$3, $this.resolveBucketConfiguration(metric$2.name(), unit$3));
            String count = $this.format(((Distribution)instrument.value()).count());
            String sum = $this.format($this.convert(((Distribution)instrument.value()).sum(), unit$3));
            $this.appendTimeSerieValue(normalizedMetricName$3, instrument.tags(), count, "_count");
            $this.appendTimeSerieValue(normalizedMetricName$3, instrument.tags(), sum, "_sum");
        }
    }

    public static final /* synthetic */ void $anonfun$appendDistributionMetricAsSummary$1(ScrapeDataBuilder $this, String normalizedMetricName$4, MeasurementUnit unit$4, Instrument.Snapshot instrument) {
        block0: {
            if (((Distribution)instrument.value()).count() <= 0L) break block0;
            $this.appendSummaryQuantiles(normalizedMetricName$4, instrument.tags(), (Distribution)instrument.value(), unit$4, $this.prometheusConfig.summarySettings().quantiles());
            $this.appendTimeSerieValue(normalizedMetricName$4, instrument.tags(), $this.format(((Distribution)instrument.value()).count()), "_count");
            $this.appendTimeSerieValue(normalizedMetricName$4, instrument.tags(), $this.format(((Distribution)instrument.value()).sum()), "_sum");
        }
    }

    public static final /* synthetic */ boolean $anonfun$appendSummaryQuantiles$2(Double quant$1, Distribution.Percentile x$2) {
        return x$2.rank() >= Predef$.MODULE$.Double2double(quant$1) * (double)100;
    }

    public static final /* synthetic */ void $anonfun$appendSummaryQuantiles$5(ScrapeDataBuilder $this, TagSet tags$1, String name$1, MeasurementUnit unit$6, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Double quantileRank = (Double)tuple2._1();
        long percentile = tuple2._2$mcJ$sp();
        TagSet percTags = tags$1.withTag("quantile", $this.format(Predef$.MODULE$.Double2double(quantileRank)));
        $this.appendTimeSerieValue(name$1, percTags, $this.format($this.convert(percentile, unit$6)), $this.appendTimeSerieValue$default$4());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$appendHistogramBuckets$1(ScrapeDataBuilder $this, TagSet tags$2, DoubleRef currentDistributionBucketValue$1, LongRef inBucketCount$1, LongRef leftOver$1, Iterator distributionBuckets$1, ObjectRef currentDistributionBucket$1, MeasurementUnit unit$7, String name$2, Double configuredBucket) {
        TagSet bucketTags = tags$2.withTag("le", String.valueOf(configuredBucket));
        if (currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
            inBucketCount$1.elem += leftOver$1.elem;
            leftOver$1.elem = 0L;
            while (distributionBuckets$1.hasNext() && currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
                currentDistributionBucket$1.elem = (Distribution.Bucket)distributionBuckets$1.next();
                currentDistributionBucketValue$1.elem = $this.convert(((Distribution.Bucket)currentDistributionBucket$1.elem).value(), unit$7);
                if (currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
                    inBucketCount$1.elem += ((Distribution.Bucket)currentDistributionBucket$1.elem).frequency();
                    continue;
                }
                leftOver$1.elem = ((Distribution.Bucket)currentDistributionBucket$1.elem).frequency();
            }
        }
        $this.appendTimeSerieValue(name$2, bucketTags, $this.format(inBucketCount$1.elem), "_bucket");
    }

    public ScrapeDataBuilder(PrometheusSettings.Generic prometheusConfig, TagSet environmentTags) {
        this.prometheusConfig = prometheusConfig;
        this.environmentTags = environmentTags;
        this._builder = new StringBuilder();
        this._decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.ROOT);
        this._numberFormat = new DecimalFormat("#0.0########", this._decimalFormatSymbols());
    }
}

