/*
 * Decompiled with CFR 0.152.
 */
package kamon.prometheus;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kamon.metric.Distribution;
import kamon.metric.Instrument;
import kamon.metric.MeasurementUnit;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import kamon.metric.MetricSnapshot;
import kamon.metric.MetricSnapshot$;
import kamon.prometheus.PrometheusSettings;
import kamon.prometheus.ScrapeDataBuilder$;
import kamon.tag.Tag;
import kamon.tag.TagSet;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\teb\u0001\u0002\u0015*\u00019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!)Q\t\u0001C\u0001\r\"9!\n\u0001b\u0001\n\u0013Y\u0005B\u0002+\u0001A\u0003%A\nC\u0004V\u0001\t\u0007I\u0011\u0002,\t\ru\u0003\u0001\u0015!\u0003X\u0011\u001dq\u0006A1A\u0005\n}Caa\u0019\u0001!\u0002\u0013\u0001\u0007\"\u00023\u0001\t\u0003)\u0007\"B9\u0001\t\u0003\u0011\bbBA\f\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005M\u0003\u0001\"\u0003\u0002V!9\u0011\u0011\f\u0001\u0005\n\u0005m\u0003bBA0\u0001\u0011%\u0011\u0011\r\u0005\b\u0003K\u0002A\u0011BA4\u0011%\tI\bAI\u0001\n\u0013\tY\bC\u0004\u0002\u0012\u0002!I!a%\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAi\u0001\u0011%\u00111\u001b\u0005\b\u0003/\u0004A\u0011BAm\u0011\u001d\ti\u000e\u0001C\u0005\u0003?Dq!a:\u0001\t\u0013\tI\u000fC\u0004\u0002p\u0002!I!!=\t\u000f\u0005]\b\u0001\"\u0003\u0002z\"9!\u0011\u0001\u0001\u0005\n\t\r\u0001b\u0002B\u0005\u0001\u0011%!1\u0002\u0005\b\u0005/\u0001A\u0011\u0002B\r\u0011\u001d\u0011i\u0002\u0001C\u0005\u0005?AqAa\t\u0001\t\u0013\u0011)cB\u0005\u0003,%\n\t\u0011#\u0001\u0003.\u0019A\u0001&KA\u0001\u0012\u0003\u0011y\u0003\u0003\u0004FK\u0011\u0005!\u0011\u0007\u0005\n\u0005g)\u0013\u0013!C\u0001\u0005k\u0011\u0011cU2sCB,G)\u0019;b\u0005VLG\u000eZ3s\u0015\tQ3&\u0001\u0006qe>lW\r\u001e5fkNT\u0011\u0001L\u0001\u0006W\u0006lwN\\\u0002\u0001'\t\u0001q\u0006\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VMZ\u0001\u0011aJ|W.\u001a;iKV\u001c8i\u001c8gS\u001e\u0004\"aN\u001e\u000f\u0005aJT\"A\u0015\n\u0005iJ\u0013A\u0005)s_6,G\u000f[3vgN+G\u000f^5oONL!\u0001P\u001f\u0003\u000f\u001d+g.\u001a:jG*\u0011!(K\u0001\u0010K:4\u0018N]8o[\u0016tG\u000fV1hgB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!iK\u0001\u0004i\u0006<\u0017B\u0001#B\u0005\u0019!\u0016mZ*fi\u00061A(\u001b8jiz\"2a\u0012%J!\tA\u0004\u0001C\u00036\u0007\u0001\u0007a\u0007C\u0004?\u0007A\u0005\t\u0019A \u0002\u0011}\u0013W/\u001b7eKJ,\u0012\u0001\u0014\t\u0003\u001bJk\u0011A\u0014\u0006\u0003\u001fB\u000bA\u0001\\1oO*\t\u0011+\u0001\u0003kCZ\f\u0017BA*O\u00055\u0019FO]5oO\n+\u0018\u000e\u001c3fe\u0006IqLY;jY\u0012,'\u000fI\u0001\u0016?\u0012,7-[7bY\u001a{'/\\1u'fl'm\u001c7t+\u00059\u0006C\u0001-\\\u001b\u0005I&B\u0001.Q\u0003\u0011!X\r\u001f;\n\u0005qK&\u0001\u0006#fG&l\u0017\r\u001c$pe6\fGoU=nE>d7/\u0001\f`I\u0016\u001c\u0017.\\1m\r>\u0014X.\u0019;Ts6\u0014w\u000e\\:!\u00035yf.^7cKJ4uN]7biV\t\u0001\r\u0005\u0002YC&\u0011!-\u0017\u0002\u000e\t\u0016\u001c\u0017.\\1m\r>\u0014X.\u0019;\u0002\u001d}sW/\u001c2fe\u001a{'/\\1uA\u0005)!-^5mIR\ta\r\u0005\u0002h]:\u0011\u0001\u000e\u001c\t\u0003SFj\u0011A\u001b\u0006\u0003W6\na\u0001\u0010:p_Rt\u0014BA72\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000e\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055\f\u0014AD1qa\u0016tGmQ8v]R,'o\u001d\u000b\u0003\u000fNDQ\u0001^\u0006A\u0002U\f\u0001bY8v]R,'o\u001d\t\u0004mnthBA<z\u001d\tI\u00070C\u00013\u0013\tQ\u0018'A\u0004qC\u000e\\\u0017mZ3\n\u0005ql(aA*fc*\u0011!0\r\t\u0006\u007f\u0006-\u0011\u0011\u0003\b\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA\u0016\u0002\r5,GO]5d\u0013\u0011\tI!a\u0001\u0002\u001d5+GO]5d':\f\u0007o\u001d5pi&!\u0011QBA\b\u0005\u00191\u0016\r\\;fg*!\u0011\u0011BA\u0002!\r\u0001\u00141C\u0005\u0004\u0003+\t$\u0001\u0002'p]\u001e\fA\"\u00199qK:$w)Y;hKN$2aRA\u000e\u0011\u001d\ti\u0002\u0004a\u0001\u0003?\taaZ1vO\u0016\u001c\b\u0003\u0002<|\u0003C\u0001Ra`A\u0006\u0003G\u00012\u0001MA\u0013\u0013\r\t9#\r\u0002\u0007\t>,(\r\\3\u0002!\u0005\u0004\b/\u001a8e\u0011&\u001cHo\\4sC6\u001cHcA$\u0002.!9\u0011qF\u0007A\u0002\u0005E\u0012A\u00035jgR|wM]1ngB!ao_A\u001a!\ry\u0018QG\u0005\u0005\u0003o\tyAA\u0007ESN$(/\u001b2vi&|gn]\u0001\"CB\u0004XM\u001c3ESN$(/\u001b2vi&|g.T3ue&\u001c7/Q:HCV<Wm\u001d\u000b\u0004\u000f\u0006u\u0002bBA \u001d\u0001\u0007\u0011\u0011G\u0001\u000eI&\u001cHO]5ckRLwN\\:\u0002'\u0005\u0004\b/\u001a8e\u0007>,h\u000e^3s\u001b\u0016$(/[2\u0015\t\u0005\u0015\u00131\n\t\u0004a\u0005\u001d\u0013bAA%c\t!QK\\5u\u0011\u0019\t)a\u0004a\u0001}\u0006\t\u0012\r\u001d9f]\u0012<\u0015-^4f\u001b\u0016$(/[2\u0015\t\u0005\u0015\u0013\u0011\u000b\u0005\b\u0003\u000b\u0001\u0002\u0019AA\u0011\u0003a\t\u0007\u000f]3oI\u0012K7\u000f\u001e:jEV$\u0018n\u001c8NKR\u0014\u0018n\u0019\u000b\u0005\u0003\u000b\n9\u0006C\u0004\u0002\u0006E\u0001\r!a\r\u0002G\u0005\u0004\b/\u001a8e\t&\u001cHO]5ckRLwN\\'fiJL7-Q:ISN$xn\u001a:b[R!\u0011QIA/\u0011\u001d\t)A\u0005a\u0001\u0003g\t\u0011%\u00199qK:$G)[:ue&\u0014W\u000f^5p]6+GO]5d\u0003N\u001cV/\\7bef$B!!\u0012\u0002d!9\u0011QA\nA\u0002\u0005M\u0012\u0001F1qa\u0016tG\rV5nKN+'/[3WC2,X\r\u0006\u0006\u0002F\u0005%\u0014QNA9\u0003kBa!a\u001b\u0015\u0001\u00041\u0017\u0001\u00028b[\u0016Da!a\u001c\u0015\u0001\u0004y\u0014\u0001\u0002;bONDa!a\u001d\u0015\u0001\u00041\u0017!\u0002<bYV,\u0007\u0002CA<)A\u0005\t\u0019\u00014\u0002\rM,hMZ5y\u0003y\t\u0007\u000f]3oIRKW.Z*fe&,g+\u00197vK\u0012\"WMZ1vYR$C'\u0006\u0002\u0002~)\u001aa-a ,\u0005\u0005\u0005\u0005\u0003BAB\u0003\u001bk!!!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a#2\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\u000b)IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!D]3t_24XMQ;dW\u0016$8i\u001c8gS\u001e,(/\u0019;j_:$b!!&\u0002\u001c\u0006}\u0005\u0003\u0002<|\u0003/\u00032!TAM\u0013\r\t9C\u0014\u0005\u0007\u0003;3\u0002\u0019\u00014\u0002\u00155,GO]5d\u001d\u0006lW\rC\u0004\u0002\"Z\u0001\r!a)\u0002\tUt\u0017\u000e\u001e\t\u0005\u0003\u0003\t)+\u0003\u0003\u0002(\u0006\r!aD'fCN,(/Z7f]R,f.\u001b;\u0002-\u0005\u0004\b/\u001a8e'VlW.\u0019:z#V\fg\u000e^5mKN$B\"!\u0012\u0002.\u0006=\u0016\u0011WA^\u0003{Ca!a\u001b\u0018\u0001\u00041\u0007BBA8/\u0001\u0007q\bC\u0004\u00024^\u0001\r!!.\u0002\u0019\u0011L7\u000f\u001e:jEV$\u0018n\u001c8\u0011\t\u0005\u0005\u0011qW\u0005\u0005\u0003s\u000b\u0019A\u0001\u0007ESN$(/\u001b2vi&|g\u000eC\u0004\u0002\"^\u0001\r!a)\t\u000f\u0005}v\u00031\u0001\u0002\u0016\u0006I\u0011/^1oi&dWm]\u0001\u0017CB\u0004XM\u001c3ISN$xn\u001a:b[\n+8m[3ugRa\u0011QIAc\u0003\u000f\fI-a3\u0002N\"1\u00111\u000e\rA\u0002\u0019Da!a\u001c\u0019\u0001\u0004y\u0004bBAZ1\u0001\u0007\u0011Q\u0017\u0005\b\u0003CC\u0002\u0019AAR\u0011\u001d\ty\r\u0007a\u0001\u0003+\u000bqAY;dW\u0016$8/\u0001\u0006baB,g\u000e\u001a+bON$B!!\u0012\u0002V\"1\u0011qN\rA\u0002}\nQb\u001d;sS:<\u0017NZ=UC\u001e\u001cH\u0003BA#\u00037Da!a\u001c\u001b\u0001\u0004y\u0014\u0001D1qa\u0016tG\rV1hgR{GCBA#\u0003C\f\u0019\u000f\u0003\u0004\u0002pm\u0001\ra\u0010\u0005\u0007\u0003K\\\u0002\u0019\u0001'\u0002\r\t,hMZ3s\u0003iqwN]7bY&TXmQ8v]R,'/T3ue&\u001cg*Y7f)\u00151\u00171^Aw\u0011\u0019\ti\n\ba\u0001M\"9\u0011\u0011\u0015\u000fA\u0002\u0005\r\u0016a\u00058pe6\fG.\u001b>f\u001b\u0016$(/[2OC6,G#\u00024\u0002t\u0006U\bBBAO;\u0001\u0007a\rC\u0004\u0002\"v\u0001\r!a)\u0002/\u0005$G\rU8ti\u001aL\u0007p\u00148ms&3W*[:tS:<G#\u00024\u0002|\u0006u\bBBAO=\u0001\u0007a\r\u0003\u0004\u0002\u0000z\u0001\rAZ\u0001\ba>\u001cHOZ5y\u0003IqwN]7bY&TX\rT1cK2t\u0015-\\3\u0015\u0007\u0019\u0014)\u0001\u0003\u0004\u0003\b}\u0001\rAZ\u0001\u0006Y\u0006\u0014W\r\\\u0001\u000fm\u0006d\u0017\u000e\u001a'bE\u0016d7\t[1s)\u0011\u0011iAa\u0005\u0011\u0007A\u0012y!C\u0002\u0003\u0012E\u0012Aa\u00115be\"9!Q\u0003\u0011A\u0002\t5\u0011\u0001B2iCJ\fQB^1mS\u0012t\u0015-\\3DQ\u0006\u0014H\u0003\u0002B\u0007\u00057AqA!\u0006\"\u0001\u0004\u0011i!\u0001\u0004g_Jl\u0017\r\u001e\u000b\u0004M\n\u0005\u0002bBA:E\u0001\u0007\u00111E\u0001\bG>tg/\u001a:u)\u0019\t\u0019Ca\n\u0003*!9\u00111O\u0012A\u0002\u0005\r\u0002bBAQG\u0001\u0007\u00111U\u0001\u0012'\u000e\u0014\u0018\r]3ECR\f')^5mI\u0016\u0014\bC\u0001\u001d&'\t)s\u0006\u0006\u0002\u0003.\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"Aa\u000e+\u0007}\ny\b")
public class ScrapeDataBuilder {
    private final PrometheusSettings.Generic prometheusConfig;
    private final TagSet environmentTags;
    private final StringBuilder _builder;
    private final DecimalFormatSymbols _decimalFormatSymbols;
    private final DecimalFormat _numberFormat;

    public static TagSet $lessinit$greater$default$2() {
        return ScrapeDataBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    private StringBuilder _builder() {
        return this._builder;
    }

    private DecimalFormatSymbols _decimalFormatSymbols() {
        return this._decimalFormatSymbols;
    }

    private DecimalFormat _numberFormat() {
        return this._numberFormat;
    }

    public String build() {
        return this._builder().toString();
    }

    public ScrapeDataBuilder appendCounters(Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>> counters) {
        counters.foreach((Function1 & Serializable)metric -> {
            this.appendCounterMetric((MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ScrapeDataBuilder appendGauges(Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>> gauges) {
        gauges.foreach((Function1 & Serializable)metric -> {
            this.appendGaugeMetric((MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ScrapeDataBuilder appendHistograms(Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>> histograms) {
        histograms.foreach((Function1 & Serializable)metric -> {
            this.appendDistributionMetric((MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ScrapeDataBuilder appendDistributionMetricsAsGauges(Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>> distributions) {
        ((IterableOnceOps)((IterableOps)((IterableOps)distributions.filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)this.gaugeFilter$1(metric)))).map((Function1 & Serializable)metric -> {
            Metric.Settings.ForValueInstrument settings = new Metric.Settings.ForValueInstrument(((Metric.Settings.ForDistributionInstrument)metric.settings()).unit(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).autoUpdateInterval());
            return (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricSnapshot[]{MetricSnapshot$.MODULE$.ofValues(new StringBuilder(4).append(metric.name()).append(".min").toString(), metric.description(), settings, (Seq)metric.instruments().map((Function1 & Serializable)snap -> new Instrument.Snapshot(snap.tags(), (Object)BoxesRunTime.boxToDouble((double)((Distribution)snap.value()).min())))), MetricSnapshot$.MODULE$.ofValues(new StringBuilder(4).append(metric.name()).append(".max").toString(), metric.description(), settings, (Seq)metric.instruments().map((Function1 & Serializable)snap -> new Instrument.Snapshot(snap.tags(), (Object)BoxesRunTime.boxToDouble((double)((Distribution)snap.value()).max())))), MetricSnapshot$.MODULE$.ofValues(new StringBuilder(4).append(metric.name()).append(".avg").toString(), metric.description(), settings, (Seq)metric.instruments().map((Function1 & Serializable)snap -> new Instrument.Snapshot(snap.tags(), (Object)BoxesRunTime.boxToDouble((double)ScrapeDataBuilder.avg$1(snap)))))}));
        })).flatten(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)metric -> {
            this.appendGaugeMetric((MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    private void appendCounterMetric(MetricSnapshot<Metric.Settings.ForValueInstrument, Object> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForValueInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeCounterMetricName(metric.name(), unit);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" counter\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            this._builder().append(normalizedMetricName);
            this.appendTags(instrument.tags());
            this._builder().append(" ");
            this._builder().append(this.format(this.convert(BoxesRunTime.unboxToLong((Object)instrument.value()), unit)));
            return this._builder().append("\n");
        });
    }

    private void appendGaugeMetric(MetricSnapshot<Metric.Settings.ForValueInstrument, Object> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForValueInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeMetricName(metric.name(), unit);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" gauge\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            this._builder().append(normalizedMetricName);
            this.appendTags(instrument.tags());
            this._builder().append(" ");
            this._builder().append(this.format(this.convert(BoxesRunTime.unboxToDouble((Object)instrument.value()), unit)));
            return this._builder().append("\n");
        });
    }

    private void appendDistributionMetric(MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution> metric) {
        boolean reportAsSummary = this.prometheusConfig.summarySettings().metricMatchers().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.accept(metric.name())));
        if (reportAsSummary) {
            this.appendDistributionMetricAsSummary(metric);
        } else {
            this.appendDistributionMetricAsHistogram(metric);
        }
    }

    private void appendDistributionMetricAsHistogram(MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeMetricName(metric.name(), unit);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" histogram").append("\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            ScrapeDataBuilder.$anonfun$appendDistributionMetricAsHistogram$1(this, normalizedMetricName, unit, metric, instrument);
            return BoxedUnit.UNIT;
        });
    }

    private void appendDistributionMetricAsSummary(MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeMetricName(metric.name(), unit);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" summary").append("\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            ScrapeDataBuilder.$anonfun$appendDistributionMetricAsSummary$1(this, normalizedMetricName, unit, instrument);
            return BoxedUnit.UNIT;
        });
    }

    private void appendTimeSerieValue(String name, TagSet tags, String value, String suffix) {
        this._builder().append(name);
        this._builder().append(suffix);
        this.appendTags(tags);
        this._builder().append(" ");
        this._builder().append(value);
        this._builder().append("\n");
    }

    private String appendTimeSerieValue$default$4() {
        return "";
    }

    private Seq<Double> resolveBucketConfiguration(String metricName, MeasurementUnit unit) {
        return (Seq)this.prometheusConfig.customBuckets().getOrElse((Object)metricName, (Function0 & Serializable)() -> {
            Seq<Double> seq;
            MeasurementUnit.Dimension dimension = unit.dimension();
            MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
            MeasurementUnit.Dimension dimension3 = dimension;
            if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
                seq = $this.prometheusConfig.timeBuckets();
            } else {
                MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
                MeasurementUnit.Dimension dimension5 = dimension;
                seq = !(dimension4 != null ? !dimension4.equals(dimension5) : dimension5 != null) ? $this.prometheusConfig.informationBuckets() : $this.prometheusConfig.defaultBuckets();
            }
            return seq;
        });
    }

    private void appendSummaryQuantiles(String name, TagSet tags, Distribution distribution, MeasurementUnit unit, Seq<Double> quantiles) {
        Iterator percentileIter = distribution.percentilesIterator();
        Seq percentiles = (Seq)((IterableOps)quantiles.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).map((Function1 & Serializable)quant -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(quant), percentileIter.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ScrapeDataBuilder.$anonfun$appendSummaryQuantiles$2(quant, x$3))).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        percentiles.foreach((Function1 & Serializable)x0$1 -> {
            ScrapeDataBuilder.$anonfun$appendSummaryQuantiles$5(this, tags, name, unit, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void appendHistogramBuckets(String name, TagSet tags, Distribution distribution, MeasurementUnit unit, Seq<Double> buckets) {
        Iterator distributionBuckets = distribution.bucketsIterator();
        ObjectRef currentDistributionBucket = ObjectRef.create((Object)((Distribution.Bucket)distributionBuckets.next()));
        DoubleRef currentDistributionBucketValue = DoubleRef.create((double)this.convert(((Distribution.Bucket)currentDistributionBucket.elem).value(), unit));
        LongRef inBucketCount = LongRef.create((long)0L);
        LongRef leftOver = LongRef.create((long)((Distribution.Bucket)currentDistributionBucket.elem).frequency());
        buckets.foreach((Function1 & Serializable)configuredBucket -> {
            ScrapeDataBuilder.$anonfun$appendHistogramBuckets$1(this, tags, currentDistributionBucketValue, inBucketCount, leftOver, distributionBuckets, currentDistributionBucket, unit, name, configuredBucket);
            return BoxedUnit.UNIT;
        });
        while (distributionBuckets.hasNext()) {
            leftOver.elem += ((Distribution.Bucket)distributionBuckets.next()).frequency();
        }
        this.appendTimeSerieValue(name, tags.withTag("le", "+Inf"), this.format(leftOver.elem + inBucketCount.elem), "_bucket");
    }

    private void appendTags(TagSet tags) {
        this.appendTagsTo(tags, this._builder());
    }

    private void stringifyTags(TagSet tags) {
        StringBuilder builder = new StringBuilder();
        this.appendTagsTo(tags, builder);
        builder.toString();
    }

    private void appendTagsTo(TagSet tags, StringBuilder buffer) {
        block1: {
            TagSet allTags = tags.withTags(this.environmentTags);
            Object object = allTags.nonEmpty() ? buffer.append("{") : BoxedUnit.UNIT;
            Iterator tagIterator = allTags.iterator((Function1 & Serializable)v -> v == null ? "" : v.toString());
            int tagCount = 0;
            while (tagIterator.hasNext()) {
                Tag.Pair pair = (Tag.Pair)tagIterator.next();
                Object object2 = tagCount > 0 ? buffer.append(",") : BoxedUnit.UNIT;
                buffer.append(this.normalizeLabelName(pair.key())).append("=\"").append((String)pair.value()).append('\"');
                ++tagCount;
            }
            if (!allTags.nonEmpty()) break block1;
            buffer.append("}");
        }
    }

    private String normalizeCounterMetricName(String metricName, MeasurementUnit unit) {
        String string;
        String normalizedMetricName = StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(metricName), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToCharacter((char)this.validNameChar(BoxesRunTime.unboxToChar((Object)x$5))));
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            string = this.addPostfixOnlyIfMissing(normalizedMetricName, "_seconds_total");
        } else {
            MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
            MeasurementUnit.Dimension dimension5 = dimension;
            string = !(dimension4 != null ? !dimension4.equals(dimension5) : dimension5 != null) ? this.addPostfixOnlyIfMissing(normalizedMetricName, "_bytes_total") : this.addPostfixOnlyIfMissing(normalizedMetricName, "_total");
        }
        return string;
    }

    private String normalizeMetricName(String metricName, MeasurementUnit unit) {
        String string;
        String normalizedMetricName = StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(metricName), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToCharacter((char)this.validNameChar(BoxesRunTime.unboxToChar((Object)x$6))));
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            string = this.addPostfixOnlyIfMissing(normalizedMetricName, "_seconds");
        } else {
            MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
            MeasurementUnit.Dimension dimension5 = dimension;
            string = !(dimension4 != null ? !dimension4.equals(dimension5) : dimension5 != null) ? this.addPostfixOnlyIfMissing(normalizedMetricName, "_bytes") : normalizedMetricName;
        }
        return string;
    }

    private String addPostfixOnlyIfMissing(String metricName, String postfix) {
        return metricName.endsWith(postfix) ? metricName : new StringBuilder(0).append(metricName).append(postfix).toString();
    }

    private String normalizeLabelName(String label) {
        return StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(label), (Function1 & Serializable)object -> BoxesRunTime.boxToCharacter((char)this.validLabelChar(BoxesRunTime.unboxToChar((Object)object))));
    }

    private char validLabelChar(char n) {
        return (char)(RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper((char)n)) || n == 95 ? n : 95);
    }

    private char validNameChar(char n) {
        return (char)(RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper((char)n)) || n == 95 || n == 58 ? n : 95);
    }

    private String format(double value) {
        return this._numberFormat().format(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double convert(double value, MeasurementUnit unit) {
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            MeasurementUnit.Magnitude magnitude = unit.magnitude();
            MeasurementUnit.Magnitude magnitude2 = MeasurementUnit$.MODULE$.time().seconds().magnitude();
            if (magnitude == null ? magnitude2 != null : !magnitude.equals(magnitude2)) {
                return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.time().seconds());
            }
        }
        MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
        MeasurementUnit.Dimension dimension5 = dimension;
        if (dimension4 == null) {
            if (dimension5 != null) {
                return value;
            }
        } else if (!dimension4.equals(dimension5)) return value;
        MeasurementUnit.Magnitude magnitude = unit.magnitude();
        MeasurementUnit.Magnitude magnitude3 = MeasurementUnit$.MODULE$.information().bytes().magnitude();
        if (magnitude == null) {
            if (magnitude3 == null) return value;
            return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.information().bytes());
        } else if (magnitude.equals(magnitude3)) return value;
        return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.information().bytes());
    }

    private final boolean gaugeFilter$1(MetricSnapshot metric) {
        return this.prometheusConfig.gaugeSettings().metricMatchers().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.accept(metric.name())));
    }

    private static final double avg$1(Instrument.Snapshot snap) {
        return ((Distribution)snap.value()).count() == 0L ? 0.0 : (double)(((Distribution)snap.value()).sum() / ((Distribution)snap.value()).count());
    }

    public static final /* synthetic */ void $anonfun$appendDistributionMetricAsHistogram$1(ScrapeDataBuilder $this, String normalizedMetricName$3, MeasurementUnit unit$3, MetricSnapshot metric$3, Instrument.Snapshot instrument) {
        block0: {
            if (((Distribution)instrument.value()).count() <= 0L) break block0;
            $this.appendHistogramBuckets(normalizedMetricName$3, instrument.tags(), (Distribution)instrument.value(), unit$3, $this.resolveBucketConfiguration(metric$3.name(), unit$3));
            String count = $this.format(((Distribution)instrument.value()).count());
            String sum = $this.format($this.convert(((Distribution)instrument.value()).sum(), unit$3));
            $this.appendTimeSerieValue(normalizedMetricName$3, instrument.tags(), count, "_count");
            $this.appendTimeSerieValue(normalizedMetricName$3, instrument.tags(), sum, "_sum");
        }
    }

    public static final /* synthetic */ void $anonfun$appendDistributionMetricAsSummary$1(ScrapeDataBuilder $this, String normalizedMetricName$4, MeasurementUnit unit$4, Instrument.Snapshot instrument) {
        block0: {
            if (((Distribution)instrument.value()).count() <= 0L) break block0;
            $this.appendSummaryQuantiles(normalizedMetricName$4, instrument.tags(), (Distribution)instrument.value(), unit$4, $this.prometheusConfig.summarySettings().quantiles());
            $this.appendTimeSerieValue(normalizedMetricName$4, instrument.tags(), $this.format(((Distribution)instrument.value()).count()), "_count");
            $this.appendTimeSerieValue(normalizedMetricName$4, instrument.tags(), $this.format(((Distribution)instrument.value()).sum()), "_sum");
        }
    }

    public static final /* synthetic */ boolean $anonfun$appendSummaryQuantiles$2(Double quant$1, Distribution.Percentile x$3) {
        return x$3.rank() >= Predef$.MODULE$.Double2double(quant$1) * (double)100;
    }

    public static final /* synthetic */ void $anonfun$appendSummaryQuantiles$5(ScrapeDataBuilder $this, TagSet tags$1, String name$1, MeasurementUnit unit$6, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Double quantileRank = (Double)tuple2._1();
        long percentile = tuple2._2$mcJ$sp();
        TagSet percTags = tags$1.withTag("quantile", $this.format(Predef$.MODULE$.Double2double(quantileRank)));
        $this.appendTimeSerieValue(name$1, percTags, $this.format($this.convert(percentile, unit$6)), $this.appendTimeSerieValue$default$4());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$appendHistogramBuckets$1(ScrapeDataBuilder $this, TagSet tags$2, DoubleRef currentDistributionBucketValue$1, LongRef inBucketCount$1, LongRef leftOver$1, Iterator distributionBuckets$1, ObjectRef currentDistributionBucket$1, MeasurementUnit unit$7, String name$2, Double configuredBucket) {
        TagSet bucketTags = tags$2.withTag("le", String.valueOf(configuredBucket));
        if (currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
            inBucketCount$1.elem += leftOver$1.elem;
            leftOver$1.elem = 0L;
            while (distributionBuckets$1.hasNext() && currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
                currentDistributionBucket$1.elem = (Distribution.Bucket)distributionBuckets$1.next();
                currentDistributionBucketValue$1.elem = $this.convert(((Distribution.Bucket)currentDistributionBucket$1.elem).value(), unit$7);
                if (currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
                    inBucketCount$1.elem += ((Distribution.Bucket)currentDistributionBucket$1.elem).frequency();
                    continue;
                }
                leftOver$1.elem = ((Distribution.Bucket)currentDistributionBucket$1.elem).frequency();
            }
        }
        $this.appendTimeSerieValue(name$2, bucketTags, $this.format(inBucketCount$1.elem), "_bucket");
    }

    public ScrapeDataBuilder(PrometheusSettings.Generic prometheusConfig, TagSet environmentTags) {
        this.prometheusConfig = prometheusConfig;
        this.environmentTags = environmentTags;
        this._builder = new StringBuilder();
        this._decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.ROOT);
        this._numberFormat = new DecimalFormat("#0.0########", this._decimalFormatSymbols());
    }
}

