/*
 * Decompiled with CFR 0.152.
 */
package kamon.system;

import com.typesafe.config.Config;
import java.io.File;
import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kamon.Kamon$;
import kamon.OnReconfigureHook;
import kamon.sigar.SigarProvisioner;
import kamon.system.custom.CustomMetricsUpdater;
import kamon.system.host.SigarMetricsUpdater;
import kamon.system.jvm.JmxMetricsUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;

public final class SystemMetrics$ {
    public static final SystemMetrics$ MODULE$;
    private final String FilterName;
    private final Logger logger;
    private String sigarFolder;
    private Duration sigarRefreshInterval;
    private Duration jmxRefreshInterval;
    private boolean sigarEnabled;
    private boolean jmxEnabled;
    private boolean hiccupMonitorEnabled;
    private Duration contextSwitchesRefreshInterval;
    private Duration hiccupSampleIntervalResolution;
    private Seq<ScheduledFuture<?>> scheduledCollections;

    static {
        new SystemMetrics$();
    }

    public String FilterName() {
        return this.FilterName;
    }

    public Logger logger() {
        return this.logger;
    }

    public String sigarFolder() {
        return this.sigarFolder;
    }

    public void sigarFolder_$eq(String x$1) {
        this.sigarFolder = x$1;
    }

    public Duration sigarRefreshInterval() {
        return this.sigarRefreshInterval;
    }

    public void sigarRefreshInterval_$eq(Duration x$1) {
        this.sigarRefreshInterval = x$1;
    }

    public Duration jmxRefreshInterval() {
        return this.jmxRefreshInterval;
    }

    public void jmxRefreshInterval_$eq(Duration x$1) {
        this.jmxRefreshInterval = x$1;
    }

    public boolean sigarEnabled() {
        return this.sigarEnabled;
    }

    public void sigarEnabled_$eq(boolean x$1) {
        this.sigarEnabled = x$1;
    }

    public boolean jmxEnabled() {
        return this.jmxEnabled;
    }

    public void jmxEnabled_$eq(boolean x$1) {
        this.jmxEnabled = x$1;
    }

    public boolean hiccupMonitorEnabled() {
        return this.hiccupMonitorEnabled;
    }

    public void hiccupMonitorEnabled_$eq(boolean x$1) {
        this.hiccupMonitorEnabled = x$1;
    }

    public Duration contextSwitchesRefreshInterval() {
        return this.contextSwitchesRefreshInterval;
    }

    public void contextSwitchesRefreshInterval_$eq(Duration x$1) {
        this.contextSwitchesRefreshInterval = x$1;
    }

    public Duration hiccupSampleIntervalResolution() {
        return this.hiccupSampleIntervalResolution;
    }

    public void hiccupSampleIntervalResolution_$eq(Duration x$1) {
        this.hiccupSampleIntervalResolution = x$1;
    }

    public Seq<ScheduledFuture<?>> scheduledCollections() {
        return this.scheduledCollections;
    }

    public void scheduledCollections_$eq(Seq<ScheduledFuture<?>> x$1) {
        this.scheduledCollections = x$1;
    }

    public synchronized void kamon$system$SystemMetrics$$loadConfiguration(Config config) {
        Config systemMetricsConfig = config.getConfig("kamon.system-metrics");
        this.sigarFolder_$eq(systemMetricsConfig.getString("host.sigar-native-folder"));
        this.sigarRefreshInterval_$eq(systemMetricsConfig.getDuration("host.refresh-interval"));
        this.jmxRefreshInterval_$eq(systemMetricsConfig.getDuration("jvm.refresh-interval"));
        this.sigarEnabled_$eq(systemMetricsConfig.getBoolean("host.enabled"));
        this.jmxEnabled_$eq(systemMetricsConfig.getBoolean("jvm.enabled"));
        this.contextSwitchesRefreshInterval_$eq(systemMetricsConfig.getDuration("host.context-switches-refresh-interval"));
        this.hiccupMonitorEnabled_$eq(systemMetricsConfig.getBoolean("jvm.hiccup-monitor.enabled"));
        this.hiccupSampleIntervalResolution_$eq(systemMetricsConfig.getDuration("jvm.hiccup-monitor.sample-interval-resolution"));
    }

    public synchronized void startCollecting() {
        this.scheduledCollections_$eq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{this.sigarEnabled() ? new Some(this.collectSigarMetrics()) : None$.MODULE$, this.sigarEnabled() && this.isLinux() ? new Some(this.collectCustomMetrics()) : None$.MODULE$, this.jmxEnabled() ? new Some(this.collectJMXMetrics()) : None$.MODULE$})).flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<ScheduledFuture<? super Object>> apply(Option<ScheduledFuture<? super Object>> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        }));
    }

    public synchronized void stopCollecting() {
        this.scheduledCollections().foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ScheduledFuture<?> x$1) {
                return x$1.cancel(false);
            }
        });
        this.scheduledCollections_$eq((Seq)Seq$.MODULE$.empty());
    }

    private ScheduledFuture<?> collectSigarMetrics() {
        SigarProvisioner.provision((File)new File(this.sigarFolder()));
        SigarMetricsUpdater sigarMetricsUpdater = new SigarMetricsUpdater(this.logger());
        long refreshInterval = this.sigarRefreshInterval().toMillis();
        return Kamon$.MODULE$.scheduler().scheduleAtFixedRate(sigarMetricsUpdater, 0L, refreshInterval, TimeUnit.MILLISECONDS);
    }

    private ScheduledFuture<?> collectJMXMetrics() {
        JmxMetricsUpdater jmxMetricsUpdater = new JmxMetricsUpdater();
        long refreshInterval = this.jmxRefreshInterval().toMillis();
        return Kamon$.MODULE$.scheduler().scheduleAtFixedRate(jmxMetricsUpdater, 0L, refreshInterval, TimeUnit.MILLISECONDS);
    }

    private ScheduledFuture<?> collectCustomMetrics() {
        CustomMetricsUpdater customMetricsUpdater = new CustomMetricsUpdater();
        long refreshInterval = this.contextSwitchesRefreshInterval().toMillis();
        return Kamon$.MODULE$.scheduler().scheduleAtFixedRate(customMetricsUpdater, 0L, refreshInterval, TimeUnit.MILLISECONDS);
    }

    public boolean isLinux() {
        return System.getProperty("os.name").indexOf("Linux") != -1;
    }

    private SystemMetrics$() {
        MODULE$ = this;
        this.FilterName = "system-metric";
        this.logger = LoggerFactory.getLogger((String)"kamon.metrics.SystemMetrics");
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting the Kamon(SystemMetrics) module"})).s((Seq)Nil$.MODULE$));
        this.kamon$system$SystemMetrics$$loadConfiguration(Kamon$.MODULE$.config());
        Kamon$.MODULE$.onReconfigure(new OnReconfigureHook(){

            public void onReconfigure(Config newConfig) {
                SystemMetrics$.MODULE$.kamon$system$SystemMetrics$$loadConfiguration(newConfig);
            }
        });
    }
}

