/*
 * Decompiled with CFR 0.152.
 */
package kamon.system.host;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import kamon.Kamon$;
import kamon.metric.Counter;
import kamon.metric.CounterMetric;
import kamon.system.host.ContextSwitchesMetrics$;
import kamon.system.package;
import kamon.util.DifferentialSource;
import kamon.util.DifferentialSource$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class ContextSwitchesMetrics$
extends package.MetricBuilder
implements package.CustomMetricBuilder {
    public static final ContextSwitchesMetrics$ MODULE$;

    static {
        new ContextSwitchesMetrics$();
    }

    @Override
    public package.Metric build(long pid, String metricName, Logger logger) {
        return new package.Metric(pid, metricName, logger){
            private final CounterMetric contextSwitchMetric;
            private final Counter perProcessVoluntaryMetric;
            private final Counter perProcessNonVoluntaryMetric;
            private final Counter globalMetric;
            private final DifferentialSource globalContextSwitchSource;
            private final long pid$1;
            private final Logger logger$1;

            private CounterMetric contextSwitchMetric() {
                return this.contextSwitchMetric;
            }

            private Counter perProcessVoluntaryMetric() {
                return this.perProcessVoluntaryMetric;
            }

            private Counter perProcessNonVoluntaryMetric() {
                return this.perProcessNonVoluntaryMetric;
            }

            private Counter globalMetric() {
                return this.globalMetric;
            }

            private DifferentialSource globalContextSwitchSource() {
                return this.globalContextSwitchSource;
            }

            public void update() {
                Tuple2<Object, Object> tuple2 = this.contextSwitchesByProcess(this.pid$1);
                if (tuple2 != null) {
                    Tuple2.mcJJ.sp sp2;
                    long voluntary = tuple2._1$mcJ$sp();
                    long nonVoluntary = tuple2._2$mcJ$sp();
                    Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(voluntary, nonVoluntary);
                    long voluntary2 = sp3._1$mcJ$sp();
                    long nonVoluntary2 = sp3._2$mcJ$sp();
                    this.perProcessVoluntaryMetric().increment(voluntary2);
                    this.perProcessNonVoluntaryMetric().increment(nonVoluntary2);
                    this.globalMetric().increment(this.globalContextSwitchSource().get());
                    return;
                }
                throw new MatchError(tuple2);
            }

            private Tuple2<Object, Object> contextSwitchesByProcess(long pid) {
                String filename = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/proc/", "/status"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)pid)}));
                LongRef voluntaryContextSwitches = LongRef.create((long)0L);
                LongRef nonVoluntaryContextSwitches = LongRef.create((long)0L);
                try {
                    ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(Files.readAllLines(Paths.get(filename, new String[0]), StandardCharsets.US_ASCII)).asScala()).toList().foreach((Function1)new Serializable(this, voluntaryContextSwitches, nonVoluntaryContextSwitches){
                        public static final long serialVersionUID = 0L;
                        private final LongRef voluntaryContextSwitches$1;
                        private final LongRef nonVoluntaryContextSwitches$1;

                        public final void apply(String line) {
                            if (line.startsWith("voluntary_ctxt_switches")) {
                                this.voluntaryContextSwitches$1.elem = new StringOps(Predef$.MODULE$.augmentString(line.substring(line.indexOf(":") + 1).trim())).toLong();
                            }
                            if (line.startsWith("nonvoluntary_ctxt_switches")) {
                                this.nonVoluntaryContextSwitches$1.elem = new StringOps(Predef$.MODULE$.augmentString(line.substring(line.indexOf(":") + 1).trim())).toLong();
                            }
                        }
                        {
                            this.voluntaryContextSwitches$1 = voluntaryContextSwitches$1;
                            this.nonVoluntaryContextSwitches$1 = nonVoluntaryContextSwitches$1;
                        }
                    });
                }
                catch (IOException iOException) {
                    this.logger$1.error("Error trying to read [{}]", new Object[]{filename});
                }
                return new Tuple2.mcJJ.sp(voluntaryContextSwitches.elem, nonVoluntaryContextSwitches.elem);
            }

            public long kamon$system$host$ContextSwitchesMetrics$$anon$$contextSwitches() {
                String filename = "/proc/stat";
                LongRef contextSwitches2 = LongRef.create((long)0L);
                try {
                    ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(Files.readAllLines(Paths.get(filename, new String[0]), StandardCharsets.US_ASCII)).asScala()).toList().foreach((Function1)new Serializable(this, contextSwitches2){
                        public static final long serialVersionUID = 0L;
                        private final LongRef contextSwitches$1;

                        public final void apply(String line) {
                            if (line.startsWith("ctxt")) {
                                this.contextSwitches$1.elem = new StringOps(Predef$.MODULE$.augmentString(line.substring(line.indexOf(" ") + 1))).toLong();
                            }
                        }
                        {
                            this.contextSwitches$1 = contextSwitches$1;
                        }
                    });
                }
                catch (IOException iOException) {
                    this.logger$1.error("Error trying to read [{}]", new Object[]{filename});
                }
                return contextSwitches2.elem;
            }
            {
                this.pid$1 = pid$1;
                this.logger$1 = logger$1;
                this.contextSwitchMetric = Kamon$.MODULE$.counter(metricName$1);
                this.perProcessVoluntaryMetric = (Counter)this.contextSwitchMetric().refine((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"component"), (Object)"system-metrics"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"process-voluntary")})));
                this.perProcessNonVoluntaryMetric = (Counter)this.contextSwitchMetric().refine((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"component"), (Object)"system-metrics"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"process-non-voluntary")})));
                this.globalMetric = (Counter)this.contextSwitchMetric().refine((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"component"), (Object)"system-metrics"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"global")})));
                this.globalContextSwitchSource = DifferentialSource$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.$outer.kamon$system$host$ContextSwitchesMetrics$$anon$$contextSwitches();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        };
    }

    private ContextSwitchesMetrics$() {
        super("host.context-switches");
        MODULE$ = this;
    }
}

