/*
 * Decompiled with CFR 0.152.
 */
package kamon.system.host;

import java.util.concurrent.atomic.AtomicLong;
import kamon.metric.DynamicRange;
import kamon.metric.Histogram;
import kamon.metric.MeasurementUnit;
import kamon.system.host.DiffRecordingHistogram$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u0013\t1B)\u001b4g%\u0016\u001cwN\u001d3j]\u001eD\u0015n\u001d;pOJ\fWN\u0003\u0002\u0004\t\u0005!\u0001n\\:u\u0015\t)a!\u0001\u0004tsN$X-\u001c\u0006\u0002\u000f\u0005)1.Y7p]\u000e\u00011c\u0001\u0001\u000b!A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001a\u0004\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0004\u0002\r5,GO]5d\u0013\t)\"CA\u0005ISN$xn\u001a:b[\"Aq\u0003\u0001B\u0001B\u0003%\u0001#\u0001\txe\u0006\u0004\b/\u001a3ISN$xn\u001a:b[\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\"aG\u000f\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000b]A\u0002\u0019\u0001\t\t\u000f}\u0001\u0001\u0019!C\u0005A\u0005!rL]3d_J$W\rZ!u\u0019\u0016\f7\u000f^(oG\u0016,\u0012!\t\t\u0003\u0017\tJ!a\t\u0007\u0003\u000f\t{w\u000e\\3b]\"9Q\u0005\u0001a\u0001\n\u00131\u0013\u0001G0sK\u000e|'\u000fZ3e\u0003RdU-Y:u\u001f:\u001cWm\u0018\u0013fcR\u0011qE\u000b\t\u0003\u0017!J!!\u000b\u0007\u0003\tUs\u0017\u000e\u001e\u0005\bW\u0011\n\t\u00111\u0001\"\u0003\rAH%\r\u0005\u0007[\u0001\u0001\u000b\u0015B\u0011\u0002+}\u0013XmY8sI\u0016$\u0017\t\u001e'fCN$xJ\\2fA!\u0012Af\f\t\u0003\u0017AJ!!\r\u0007\u0003\u0011Y|G.\u0019;jY\u0016Dqa\r\u0001C\u0002\u0013%A'\u0001\n`Y\u0006\u001cHo\u00142tKJ4X\r\u001a,bYV,W#A\u001b\u0011\u0005YzT\"A\u001c\u000b\u0005aJ\u0014AB1u_6L7M\u0003\u0002;w\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005qj\u0014\u0001B;uS2T\u0011AP\u0001\u0005U\u00064\u0018-\u0003\u0002Ao\tQ\u0011\t^8nS\u000eduN\\4\t\r\t\u0003\u0001\u0015!\u00036\u0003MyF.Y:u\u001f\n\u001cXM\u001d<fIZ\u000bG.^3!\u0011\u0015!\u0005\u0001\"\u0003F\u0003A\u0001(o\\2fgN\u0014VmY8sI&tw\rF\u0002(\r.CQaR\"A\u0002!\u000bQA^1mk\u0016\u0004\"aC%\n\u0005)c!\u0001\u0002'p]\u001eDQ\u0001T\"A\u0002!\u000bQaY8v]RDQA\u0014\u0001\u0005\u0002=\u000baA]3d_J$GCA\u0014Q\u0011\u00159U\n1\u0001I\u0011\u0015q\u0005\u0001\"\u0001S)\r93\u000b\u0016\u0005\u0006\u000fF\u0003\r\u0001\u0013\u0005\u0006\u0019F\u0003\r\u0001\u0013\u0005\u0006-\u0002!\teV\u0001\u0005k:LG/F\u0001Y!\t\t\u0012,\u0003\u0002[%\tyQ*Z1tkJ,W.\u001a8u+:LG\u000fC\u0003]\u0001\u0011\u0005S,\u0001\u0007es:\fW.[2SC:<W-F\u0001_!\t\tr,\u0003\u0002a%\taA)\u001f8b[&\u001c'+\u00198hK\u001e)!M\u0001E\u0001G\u00061B)\u001b4g%\u0016\u001cwN\u001d3j]\u001eD\u0015n\u001d;pOJ\fW\u000e\u0005\u0002\u001dI\u001a)\u0011A\u0001E\u0001KN\u0011AM\u0003\u0005\u00063\u0011$\ta\u001a\u000b\u0002G\")\u0011\u000e\u001aC\u0001U\u0006)\u0011\r\u001d9msR\u00111d\u001b\u0005\u0006Y\"\u0004\r\u0001E\u0001\nQ&\u001cHo\\4sC6\u0004")
public class DiffRecordingHistogram
implements Histogram {
    private final Histogram wrappedHistogram;
    private volatile boolean _recordedAtLeastOnce;
    private final AtomicLong _lastObservedValue;

    public static DiffRecordingHistogram apply(Histogram histogram) {
        return DiffRecordingHistogram$.MODULE$.apply(histogram);
    }

    private boolean _recordedAtLeastOnce() {
        return this._recordedAtLeastOnce;
    }

    private void _recordedAtLeastOnce_$eq(boolean x$1) {
        this._recordedAtLeastOnce = x$1;
    }

    private AtomicLong _lastObservedValue() {
        return this._lastObservedValue;
    }

    private void processRecording(long value, long count) {
        if (this._recordedAtLeastOnce()) {
            long diff = value - this._lastObservedValue().getAndSet(value);
            long current = diff >= 0L ? diff : 0L;
            this.wrappedHistogram.record(current, count);
        } else {
            this._lastObservedValue().set(value);
            this._recordedAtLeastOnce_$eq(true);
        }
    }

    public void record(long value) {
        this.processRecording(value, 1L);
    }

    public void record(long value, long count) {
        this.processRecording(value, count);
    }

    public MeasurementUnit unit() {
        return this.wrappedHistogram.unit();
    }

    public DynamicRange dynamicRange() {
        return this.wrappedHistogram.dynamicRange();
    }

    public DiffRecordingHistogram(Histogram wrappedHistogram) {
        this.wrappedHistogram = wrappedHistogram;
        this._recordedAtLeastOnce = false;
        this._lastObservedValue = new AtomicLong(0L);
    }
}

