/*
 * Decompiled with CFR 0.152.
 */
package kamon.system.jvm;

import java.util.concurrent.TimeUnit;
import kamon.metric.Histogram;
import kamon.system.jvm.HiccupMonitor$;
import kamon.system.package;
import org.slf4j.Logger;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005%q!B\u0001\u0003\u0011\u0003I\u0011!\u0004%jG\u000e,\b/T8oSR|'O\u0003\u0002\u0004\t\u0005\u0019!N^7\u000b\u0005\u00151\u0011AB:zgR,WNC\u0001\b\u0003\u0015Y\u0017-\\8o\u0007\u0001\u0001\"AC\u0006\u000e\u0003\t1Q\u0001\u0004\u0002\t\u00025\u0011Q\u0002S5dGV\u0004Xj\u001c8ji>\u00148cA\u0006\u000f9A\u0011q\"\u0007\b\u0003!]q!!\u0005\f\u000f\u0005I)R\"A\n\u000b\u0005QA\u0011A\u0002\u001fs_>$h(C\u0001\b\u0013\t)a!\u0003\u0002\u0019\t\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u000e\u001c\u00055iU\r\u001e:jG\n+\u0018\u000e\u001c3fe*\u0011\u0001\u0004\u0002\t\u0003\u001fuI!AH\u000e\u0003'\r+8\u000f^8n\u001b\u0016$(/[2Ck&dG-\u001a:\t\u000b\u0001ZA\u0011A\u0011\u0002\rqJg.\u001b;?)\u0005I\u0001\"B\u0012\f\t\u0003\"\u0013!\u00022vS2$G\u0003B\u00132m}\u00122A\n\u0015/\r\u00119#\u0005A\u0013\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g!\tyq&\u0003\u000217\t1Q*\u001a;sS\u000eDQA\r\u0012A\u0002M\n1\u0001]5e!\tIC'\u0003\u00026U\t!Aj\u001c8h\u0011\u00159$\u00051\u00019\u0003)iW\r\u001e:jG:\u000bW.\u001a\t\u0003sqr!!\u000b\u001e\n\u0005mR\u0013A\u0002)sK\u0012,g-\u0003\u0002>}\t11\u000b\u001e:j]\u001eT!a\u000f\u0016\t\u000b\u0001\u0013\u0003\u0019A!\u0002\r1|wmZ3s!\t\u0011u)D\u0001D\u0015\t!U)A\u0003tY\u001a$$NC\u0001G\u0003\ry'oZ\u0005\u0003\u0011\u000e\u0013a\u0001T8hO\u0016\u0014h\u0001\u0002&\f\u0005-\u0013q!T8oSR|'o\u0005\u0002J\u0019B\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0005Y\u0006twMC\u0001R\u0003\u0011Q\u0017M^1\n\u0005Ms%A\u0002+ie\u0016\fG\r\u0003\u0005V\u0013\n\u0005\t\u0015!\u0003W\u0003AA\u0017nY2vaRKW.Z'fiJL7\r\u0005\u0002X56\t\u0001L\u0003\u0002Z\r\u00051Q.\u001a;sS\u000eL!a\u0017-\u0003\u0013!K7\u000f^8he\u0006l\u0007\u0002C/J\u0005\u0003\u0005\u000b\u0011B\u001a\u0002\u0015I,7o\u001c7vi&|g\u000eC\u0003!\u0013\u0012\u0005q\fF\u0002aE\u000e\u0004\"!Y%\u000e\u0003-AQ!\u00160A\u0002YCQ!\u00180A\u0002MBq!Z%A\u0002\u0013\u0005a-A\u0003e_J+h.F\u0001h!\tI\u0003.\u0003\u0002jU\t9!i\\8mK\u0006t\u0007bB6J\u0001\u0004%\t\u0001\\\u0001\nI>\u0014VO\\0%KF$\"!\u001c9\u0011\u0005%r\u0017BA8+\u0005\u0011)f.\u001b;\t\u000fET\u0017\u0011!a\u0001O\u0006\u0019\u0001\u0010J\u0019\t\rML\u0005\u0015)\u0003h\u0003\u0019!wNU;oA!\u0012!/\u001e\t\u0003SYL!a\u001e\u0016\u0003\u0011Y|G.\u0019;jY\u0016DQ!_%\u0005Bi\f1A];o)\u0005i\u0007\"\u0002?J\t\u0003i\u0018A\u0002:fG>\u0014H\r\u0006\u0003n}\u0006\u0005\u0001\"B@|\u0001\u0004\u0019\u0014!\u0002<bYV,\u0007BBA\u0002w\u0002\u00071'A\u0012fqB,7\r^3e\u0013:$XM\u001d<bY\n+Go^3f]Z\u000bG.^3TC6\u0004H.Z:\t\r\u0005\u001d\u0011\n\"\u0001{\u0003%!XM]7j]\u0006$X\r")
public final class HiccupMonitor {
    public static package.Metric build(long l, String string, Logger logger) {
        return HiccupMonitor$.MODULE$.build(l, string, logger);
    }

    public static Option<package.Metric> register() {
        return HiccupMonitor$.MODULE$.register();
    }

    public static final class Monitor
    extends Thread {
        private final Histogram hiccupTimeMetric;
        private final long resolution;
        private volatile boolean doRun;

        public boolean doRun() {
            return this.doRun;
        }

        public void doRun_$eq(boolean x$1) {
            this.doRun = x$1;
        }

        @Override
        public void run() {
            LongRef shortedObservedDelta = LongRef.create((long)Long.MAX_VALUE);
            while (this.doRun()) {
                long hiccupTime = this.hic$1(this.resolution, shortedObservedDelta);
                this.record(hiccupTime, this.resolution);
            }
        }

        public void record(long value, long expectedIntervalBetweenValueSamples) {
            this.hiccupTimeMetric.record(value);
            if (expectedIntervalBetweenValueSamples > 0L) {
                for (long missingValue = value - expectedIntervalBetweenValueSamples; missingValue >= expectedIntervalBetweenValueSamples; missingValue -= expectedIntervalBetweenValueSamples) {
                    this.hiccupTimeMetric.record(missingValue);
                }
            }
        }

        public void terminate() {
            this.doRun_$eq(false);
        }

        private final long hic$1(long resolution, LongRef shortedObservedDelta$1) {
            long start = System.nanoTime();
            TimeUnit.NANOSECONDS.sleep(resolution);
            long delta = System.nanoTime() - start;
            if (delta < shortedObservedDelta$1.elem) {
                shortedObservedDelta$1.elem = delta;
            }
            return delta - shortedObservedDelta$1.elem;
        }

        public Monitor(Histogram hiccupTimeMetric, long resolution) {
            this.hiccupTimeMetric = hiccupTimeMetric;
            this.resolution = resolution;
            this.doRun = true;
        }
    }
}

