/*
 * Decompiled with CFR 0.152.
 */
package kamon.system.jvm;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import kamon.system.jvm.BufferPoolMetrics;
import kamon.system.jvm.BufferPoolWithMetricName;
import kamon.system.jvm.MemoryMetrics;
import kamon.system.jvm.MemoryUsageMetrics$;
import kamon.system.jvm.MemoryUsageWithMetricName;
import kamon.system.package;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class MemoryUsageMetrics$
extends package.MetricBuilder
implements package.JmxMetricBuilder {
    public static final MemoryUsageMetrics$ MODULE$;

    static {
        new MemoryUsageMetrics$();
    }

    @Override
    public package.Metric build(String metricPrefix, Logger logger) {
        return new package.Metric(metricPrefix){
            private final Regex invalidChars;
            private final MemoryMetrics kamon$system$jvm$MemoryUsageMetrics$$anon$$memoryMetrics;
            private final BufferPoolMetrics kamon$system$jvm$MemoryUsageMetrics$$anon$$bufferPoolMetrics;

            private Regex invalidChars() {
                return this.invalidChars;
            }

            public MemoryMetrics kamon$system$jvm$MemoryUsageMetrics$$anon$$memoryMetrics() {
                return this.kamon$system$jvm$MemoryUsageMetrics$$anon$$memoryMetrics;
            }

            public BufferPoolMetrics kamon$system$jvm$MemoryUsageMetrics$$anon$$bufferPoolMetrics() {
                return this.kamon$system$jvm$MemoryUsageMetrics$$anon$$bufferPoolMetrics;
            }

            public void update() {
                this.memoryUsageWithNames().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final void apply(MemoryUsageWithMetricName x0$1) {
                        MemoryUsageWithMetricName memoryUsageWithMetricName = x0$1;
                        if (memoryUsageWithMetricName != null) {
                            String name = memoryUsageWithMetricName.metricName();
                            Function0<MemoryUsage> beanFun = memoryUsageWithMetricName.beanFun();
                            MemoryMetrics.MemoryMetrics memory = this.$outer.kamon$system$jvm$MemoryUsageMetrics$$anon$$memoryMetrics().forSegment(name);
                            memory.memoryUsed().record(((MemoryUsage)beanFun.apply()).getUsed());
                            memory.memoryCommitted().record(((MemoryUsage)beanFun.apply()).getCommitted());
                            long max = ((MemoryUsage)beanFun.apply()).getMax();
                            memory.memoryMax().record(max >= 0L ? max : 0L);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)memoryUsageWithMetricName);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.bufferPoolsWithNames().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final void apply(BufferPoolWithMetricName x0$2) {
                        BufferPoolWithMetricName bufferPoolWithMetricName = x0$2;
                        if (bufferPoolWithMetricName != null) {
                            String name = bufferPoolWithMetricName.metricName();
                            Function0<BufferPoolMXBean> beanFun = bufferPoolWithMetricName.beanFun();
                            BufferPoolMetrics.BufferPoolMetrics pool = this.$outer.kamon$system$jvm$MemoryUsageMetrics$$anon$$bufferPoolMetrics().forPool(name);
                            pool.poolCount().set(((BufferPoolMXBean)beanFun.apply()).getCount());
                            pool.poolUsed().set(((BufferPoolMXBean)beanFun.apply()).getMemoryUsed());
                            pool.poolCapacity().set(((BufferPoolMXBean)beanFun.apply()).getTotalCapacity());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)bufferPoolWithMetricName);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public String kamon$system$jvm$MemoryUsageMetrics$$anon$$sanitize(String name) {
                return this.invalidChars().replaceAllIn((CharSequence)name.toLowerCase(), "-");
            }

            private List<MemoryUsageWithMetricName> usagesWithNames() {
                return (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getMemoryPoolMXBeans()).asScala()).toList().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final MemoryUsageWithMetricName apply(MemoryPoolMXBean bean) {
                        return new MemoryUsageWithMetricName(this.$outer.kamon$system$jvm$MemoryUsageMetrics$$anon$$sanitize(bean.getName()), (Function0<MemoryUsage>)new Serializable(this, bean){
                            public static final long serialVersionUID = 0L;
                            private final MemoryPoolMXBean bean$1;

                            public final MemoryUsage apply() {
                                return this.bean$1.getUsage();
                            }
                            {
                                this.bean$1 = bean$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom());
            }

            private List<BufferPoolWithMetricName> bufferPoolsWithNames() {
                return (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)).asScala()).toList().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final BufferPoolWithMetricName apply(BufferPoolMXBean bean) {
                        return new BufferPoolWithMetricName(this.$outer.kamon$system$jvm$MemoryUsageMetrics$$anon$$sanitize(bean.getName()), (Function0<BufferPoolMXBean>)new Serializable(this, bean){
                            public static final long serialVersionUID = 0L;
                            private final BufferPoolMXBean bean$2;

                            public final BufferPoolMXBean apply() {
                                return this.bean$2;
                            }
                            {
                                this.bean$2 = bean$2;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom());
            }

            private Seq<MemoryUsageWithMetricName> memoryUsageWithNames() {
                return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MemoryUsageWithMetricName[]{new MemoryUsageWithMetricName("non-heap", (Function0<MemoryUsage>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MemoryUsage apply() {
                        return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
                    }
                }), new MemoryUsageWithMetricName("heap", (Function0<MemoryUsage>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MemoryUsage apply() {
                        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
                    }
                })}))).$plus$plus(this.usagesWithNames(), Seq$.MODULE$.canBuildFrom());
            }
            {
                this.invalidChars = new StringOps(Predef$.MODULE$.augmentString("[^a-z0-9]")).r();
                this.kamon$system$jvm$MemoryUsageMetrics$$anon$$memoryMetrics = new MemoryMetrics(metricPrefix$1);
                this.kamon$system$jvm$MemoryUsageMetrics$$anon$$bufferPoolMetrics = new BufferPoolMetrics(metricPrefix$1);
            }
        };
    }

    private MemoryUsageMetrics$() {
        super("jvm.memory");
        MODULE$ = this;
    }
}

