/*
 * Decompiled with CFR 0.152.
 */
package kamon.system.process;

import kamon.Kamon$;
import kamon.metric.Histogram;
import kamon.metric.HistogramMetric;
import kamon.system.package;
import kamon.system.process.ProcessCpuMetrics$;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.Sigar;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class ProcessCpuMetrics$
extends package.MetricBuilder
implements package.SigarMetricBuilder {
    public static final ProcessCpuMetrics$ MODULE$;

    static {
        new ProcessCpuMetrics$();
    }

    @Override
    public package.Metric build(Sigar sigar, String metricName, Logger logger) {
        return new package.Metric(sigar, metricName){
            private final HistogramMetric processCpuMetric;
            private final Histogram processUserCpuMetric;
            private final Histogram processSystemCpuMetric;
            private final Histogram processTotalCpuMetric;
            private final long pid;
            private final long kamon$system$process$ProcessCpuMetrics$$anon$$totalCores;
            private ProcCpu lastProcCpu;
            private long currentLoad;
            private final Sigar sigar$1;

            private HistogramMetric processCpuMetric() {
                return this.processCpuMetric;
            }

            private Histogram processUserCpuMetric() {
                return this.processUserCpuMetric;
            }

            private Histogram processSystemCpuMetric() {
                return this.processSystemCpuMetric;
            }

            private Histogram processTotalCpuMetric() {
                return this.processTotalCpuMetric;
            }

            private long pid() {
                return this.pid;
            }

            public long kamon$system$process$ProcessCpuMetrics$$anon$$totalCores() {
                return this.kamon$system$process$ProcessCpuMetrics$$anon$$totalCores;
            }

            private ProcCpu lastProcCpu() {
                return this.lastProcCpu;
            }

            private void lastProcCpu_$eq(ProcCpu x$1) {
                this.lastProcCpu = x$1;
            }

            private long currentLoad() {
                return this.currentLoad;
            }

            private void currentLoad_$eq(long x$1) {
                this.currentLoad = x$1;
            }

            public void update() {
                ProcCpu currentProcCpu = this.sigar$1.getProcCpu(this.pid());
                long totalDiff = this.positiveSubtraction$1(currentProcCpu.getTotal(), this.lastProcCpu().getTotal());
                long userDiff = this.positiveSubtraction$1(currentProcCpu.getUser(), this.lastProcCpu().getUser());
                long systemDiff = this.positiveSubtraction$1(currentProcCpu.getSys(), this.lastProcCpu().getSys());
                long timeDiff = currentProcCpu.getLastTime() - this.lastProcCpu().getLastTime();
                if (totalDiff == 0L) {
                    if (timeDiff > 2000L) {
                        this.currentLoad_$eq(0L);
                    }
                    if (this.currentLoad() == 0L) {
                        this.lastProcCpu_$eq(currentProcCpu);
                    }
                } else {
                    long totalPercent = this.percentUsage$1(totalDiff, timeDiff);
                    long userPercent = this.percentUsage$1(userDiff, timeDiff);
                    long systemPercent = this.percentUsage$1(systemDiff, timeDiff);
                    this.processUserCpuMetric().record(userPercent);
                    this.processSystemCpuMetric().record(systemPercent);
                    this.processTotalCpuMetric().record(userPercent + systemPercent);
                    this.currentLoad_$eq(totalPercent);
                    this.lastProcCpu_$eq(currentProcCpu);
                }
            }

            private final long percentUsage$1(long delta, long timeDiff) {
                return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)new Serializable(this, delta, timeDiff){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;
                    private final long delta$1;
                    private final long timeDiff$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 100L * this.delta$1 / this.timeDiff$1 / this.$outer.kamon$system$process$ProcessCpuMetrics$$anon$$totalCores();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.delta$1 = delta$1;
                        this.timeDiff$1 = timeDiff$1;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                }));
            }

            private final long positiveSubtraction$1(long left, long right) {
                long result = left - right;
                return result < 0L ? 0L : result;
            }
            {
                this.sigar$1 = sigar$1;
                this.processCpuMetric = Kamon$.MODULE$.histogram(metricName$1);
                this.processUserCpuMetric = (Histogram)this.processCpuMetric().refine((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"component"), (Object)"system-metrics"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"user")})));
                this.processSystemCpuMetric = (Histogram)this.processCpuMetric().refine((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"component"), (Object)"system-metrics"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"system")})));
                this.processTotalCpuMetric = (Histogram)this.processCpuMetric().refine((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"component"), (Object)"system-metrics"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"total")})));
                this.pid = sigar$1.getPid();
                this.kamon$system$process$ProcessCpuMetrics$$anon$$totalCores = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.refArrayOps((Object[])sigar$1.getCpuInfoList()).headOption().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CpuInfo x$1) {
                        return x$1.getTotalCores();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 1L;
                    }
                }));
                this.lastProcCpu = sigar$1.getProcCpu(this.pid());
                this.currentLoad = 0L;
            }
        };
    }

    private ProcessCpuMetrics$() {
        super("process.cpu");
        MODULE$ = this;
    }
}

