/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.advisor;

import kanela.agent.api.advisor.AdviceExceptionHandler;
import kanela.agent.libs.io.vavr.API;
import kanela.agent.libs.io.vavr.control.Option;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import kanela.agent.libs.net.bytebuddy.description.method.MethodDescription;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatcher;
import kanela.agent.util.conf.KanelaConfiguration;

public final class AdvisorDescription {
    private final ElementMatcher<? super MethodDescription> methodMatcher;
    private final Class<?> advisorClass;
    private final String advisorClassName;

    public static AdvisorDescription of(ElementMatcher.Junction<MethodDescription> methodMatcher, String advisorClassName) {
        return new AdvisorDescription(methodMatcher, null, advisorClassName);
    }

    public static AdvisorDescription of(ElementMatcher.Junction<MethodDescription> methodMatcher, Class<?> advisorClass) {
        return new AdvisorDescription(methodMatcher, advisorClass, null);
    }

    public AgentBuilder.Transformer makeTransformer(KanelaConfiguration.ModuleConfiguration configuration) {
        String name = Option.of(this.advisorClassName).getOrElse(() -> this.advisorClass.getName());
        Advice.ExceptionHandler exceptionHandler = this.getExceptionHandler(configuration.getExceptionHandlerStrategy());
        return new AgentBuilder.Transformer.ForAdvice().advice(this.methodMatcher, name).include(Thread.currentThread().getContextClassLoader()).withExceptionHandler(exceptionHandler);
    }

    private Advice.ExceptionHandler getExceptionHandler(String strategy) {
        return (Advice.ExceptionHandler)API.Match(strategy).of(API.Case(API.$("LOG"), AdviceExceptionHandler::instance), API.Case(API.$("SUPPRESS"), () -> Advice.ExceptionHandler.Default.SUPPRESSING));
    }

    public AdvisorDescription(ElementMatcher<? super MethodDescription> methodMatcher, Class<?> advisorClass, String advisorClassName) {
        this.methodMatcher = methodMatcher;
        this.advisorClass = advisorClass;
        this.advisorClassName = advisorClassName;
    }

    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public Class<?> getAdvisorClass() {
        return this.advisorClass;
    }

    public String getAdvisorClassName() {
        return this.advisorClassName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdvisorDescription)) {
            return false;
        }
        AdvisorDescription other = (AdvisorDescription)o;
        ElementMatcher<? super MethodDescription> this$methodMatcher = this.getMethodMatcher();
        ElementMatcher<? super MethodDescription> other$methodMatcher = other.getMethodMatcher();
        if (this$methodMatcher == null ? other$methodMatcher != null : !this$methodMatcher.equals(other$methodMatcher)) {
            return false;
        }
        Class<?> this$advisorClass = this.getAdvisorClass();
        Class<?> other$advisorClass = other.getAdvisorClass();
        if (this$advisorClass == null ? other$advisorClass != null : !this$advisorClass.equals(other$advisorClass)) {
            return false;
        }
        String this$advisorClassName = this.getAdvisorClassName();
        String other$advisorClassName = other.getAdvisorClassName();
        return !(this$advisorClassName == null ? other$advisorClassName != null : !this$advisorClassName.equals(other$advisorClassName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ElementMatcher<? super MethodDescription> $methodMatcher = this.getMethodMatcher();
        result = result * 59 + ($methodMatcher == null ? 43 : $methodMatcher.hashCode());
        Class<?> $advisorClass = this.getAdvisorClass();
        result = result * 59 + ($advisorClass == null ? 43 : $advisorClass.hashCode());
        String $advisorClassName = this.getAdvisorClassName();
        result = result * 59 + ($advisorClassName == null ? 43 : $advisorClassName.hashCode());
        return result;
    }

    public String toString() {
        return "AdvisorDescription(methodMatcher=" + this.getMethodMatcher() + ", advisorClass=" + this.getAdvisorClass() + ", advisorClassName=" + this.getAdvisorClassName() + ")";
    }
}

