/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.net.bytebuddy.build;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import kanela.agent.libs.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import kanela.agent.libs.net.bytebuddy.build.Plugin;
import kanela.agent.libs.net.bytebuddy.description.field.FieldDescription;
import kanela.agent.libs.net.bytebuddy.description.field.FieldList;
import kanela.agent.libs.net.bytebuddy.description.method.MethodDescription;
import kanela.agent.libs.net.bytebuddy.description.method.MethodList;
import kanela.agent.libs.net.bytebuddy.description.modifier.FieldPersistence;
import kanela.agent.libs.net.bytebuddy.description.modifier.Ownership;
import kanela.agent.libs.net.bytebuddy.description.modifier.SyntheticState;
import kanela.agent.libs.net.bytebuddy.description.modifier.Visibility;
import kanela.agent.libs.net.bytebuddy.description.type.TypeDefinition;
import kanela.agent.libs.net.bytebuddy.description.type.TypeDescription;
import kanela.agent.libs.net.bytebuddy.dynamic.ClassFileLocator;
import kanela.agent.libs.net.bytebuddy.dynamic.DynamicType;
import kanela.agent.libs.net.bytebuddy.implementation.bytecode.assign.Assigner;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatchers;
import kanela.agent.libs.net.bytebuddy.pool.TypePool;
import kanela.agent.libs.net.bytebuddy.utility.RandomString;

@HashCodeAndEqualsPlugin.Enhance
public class CachedReturnPlugin
extends Plugin.ForElementMatcher
implements Plugin.Factory {
    private static final String NAME_INFIX = "_";
    private static final String ADVICE_INFIX = "$";
    @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
    private final RandomString randomString = new RandomString();
    private final ClassFileLocator classFileLocator = ClassFileLocator.ForClassLoader.of(CachedReturnPlugin.class.getClassLoader());
    @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
    private final Map<TypeDescription, TypeDescription> adviceByType;

    public CachedReturnPlugin() {
        super(ElementMatchers.declaresMethod(ElementMatchers.isAnnotatedWith(Enhance.class)));
        TypePool typePool = TypePool.Default.of(this.classFileLocator);
        this.adviceByType = new HashMap<TypeDescription, TypeDescription>();
        for (Class type : new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Object.class}) {
            this.adviceByType.put(TypeDescription.ForLoadedType.of(type), typePool.describe(CachedReturnPlugin.class.getName() + ADVICE_INFIX + type.getSimpleName()).resolve());
        }
    }

    @Override
    public Plugin make() {
        return this;
    }

    @Override
    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        for (MethodDescription.InDefinedShape methodDescription : (MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.not(ElementMatchers.isBridge()).and(ElementMatchers.isAnnotatedWith(Enhance.class)))) {
            if (methodDescription.isAbstract()) {
                throw new IllegalStateException("Cannot cache the value of an abstract method: " + methodDescription);
            }
            if (!methodDescription.getParameters().isEmpty()) {
                throw new IllegalStateException("Cannot cache the value of a method with parameters: " + methodDescription);
            }
            if (methodDescription.getReturnType().represents(Void.TYPE)) {
                throw new IllegalStateException("Cannot cache void result for " + methodDescription);
            }
            String name = methodDescription.getDeclaredAnnotations().ofType(Enhance.class).load().value();
            if (name.length() == 0) {
                name = methodDescription.getName() + NAME_INFIX + this.randomString.nextString();
            }
            builder = builder.defineField(name, (TypeDefinition)methodDescription.getReturnType().asErasure(), methodDescription.isStatic() ? Ownership.STATIC : Ownership.MEMBER, methodDescription.isStatic() ? FieldPersistence.PLAIN : FieldPersistence.TRANSIENT, Visibility.PRIVATE, SyntheticState.SYNTHETIC).visit(Advice.withCustomMapping().bind(CacheField.class, new CacheFieldOffsetMapping(name)).to(this.adviceByType.get(methodDescription.getReturnType().isPrimitive() ? methodDescription.getReturnType().asErasure() : TypeDescription.OBJECT), this.classFileLocator).on(ElementMatchers.is(methodDescription)));
        }
        return builder;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.classFileLocator.equals(((CachedReturnPlugin)object).classFileLocator);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.classFileLocator.hashCode();
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class CacheFieldOffsetMapping
    implements Advice.OffsetMapping {
        private final String name;

        protected CacheFieldOffsetMapping(String name) {
            this.name = name;
        }

        @Override
        public Advice.OffsetMapping.Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Advice.ArgumentHandler argumentHandler, Advice.OffsetMapping.Sort sort) {
            return new Advice.OffsetMapping.Target.ForField.ReadWrite((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.name))).getOnly());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.name.equals(((CacheFieldOffsetMapping)object).name);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.name.hashCode();
        }
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface CacheField {
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Enhance {
        public String value() default "";
    }
}

