/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.net.bytebuddy.utility;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.security.AccessController;
import java.security.PrivilegedAction;
import kanela.agent.libs.net.bytebuddy.ClassFileVersion;
import kanela.agent.libs.net.bytebuddy.build.AccessControllerPlugin;
import kanela.agent.libs.net.bytebuddy.description.NamedElement;
import kanela.agent.libs.net.bytebuddy.description.annotation.AnnotationList;
import kanela.agent.libs.net.bytebuddy.description.annotation.AnnotationSource;
import kanela.agent.libs.net.bytebuddy.description.type.PackageDescription;
import kanela.agent.libs.net.bytebuddy.utility.dispatcher.JavaDispatcher;

public class JavaModule
implements NamedElement.WithOptionalName,
AnnotationSource {
    public static final JavaModule UNSUPPORTED;
    protected static final Resolver RESOLVER;
    protected static final Module MODULE;
    private final AnnotatedElement module;
    private static final boolean ACCESS_CONTROLLER;

    protected JavaModule(AnnotatedElement module) {
        this.module = module;
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        PrivilegedAction<T> action;
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return action.run();
    }

    public static JavaModule ofType(Class<?> type) {
        Object module = RESOLVER.getModule(type);
        return module == null ? UNSUPPORTED : new JavaModule((AnnotatedElement)module);
    }

    public static JavaModule of(Object module) {
        if (!MODULE.isInstance(module)) {
            throw new IllegalArgumentException("Not a Java module: " + module);
        }
        return new JavaModule((AnnotatedElement)module);
    }

    public static boolean isSupported() {
        return ClassFileVersion.ofThisVm(ClassFileVersion.JAVA_V5).isAtLeast(ClassFileVersion.JAVA_V9);
    }

    @Override
    public boolean isNamed() {
        return MODULE.isNamed(this.module);
    }

    @Override
    public String getActualName() {
        return MODULE.getName(this.module);
    }

    public InputStream getResourceAsStream(String name) throws IOException {
        return MODULE.getResourceAsStream(this.module, name);
    }

    public ClassLoader getClassLoader() {
        return MODULE.getClassLoader(this.module);
    }

    public Object unwrap() {
        return this.module;
    }

    public boolean canRead(JavaModule module) {
        return MODULE.canRead(this.module, module.unwrap());
    }

    public boolean isExported(PackageDescription packageDescription, JavaModule module) {
        return packageDescription == null || MODULE.isExported(this.module, packageDescription.getName(), module.unwrap());
    }

    public boolean isOpened(PackageDescription packageDescription, JavaModule module) {
        return packageDescription == null || MODULE.isOpen(this.module, packageDescription.getName(), module.unwrap());
    }

    @Override
    public AnnotationList getDeclaredAnnotations() {
        return new AnnotationList.ForLoadedAnnotations(this.module.getDeclaredAnnotations());
    }

    public int hashCode() {
        return this.module.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaModule)) {
            return false;
        }
        JavaModule javaModule = (JavaModule)other;
        return this.module.equals(javaModule.module);
    }

    public String toString() {
        return this.module.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class.forName("java.security.AccessController", false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("kanela.agent.libs.net.bytebuddy.securitymanager", "true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        UNSUPPORTED = null;
        RESOLVER = JavaModule.doPrivileged(JavaDispatcher.of(Resolver.class));
        MODULE = JavaModule.doPrivileged(JavaDispatcher.of(Module.class));
    }

    @JavaDispatcher.Proxied(value="java.lang.Module")
    protected static interface Module {
        @JavaDispatcher.Instance
        @JavaDispatcher.Proxied(value="isInstance")
        public boolean isInstance(Object var1);

        @JavaDispatcher.Proxied(value="isNamed")
        public boolean isNamed(Object var1);

        @JavaDispatcher.Proxied(value="getName")
        public String getName(Object var1);

        @JavaDispatcher.Proxied(value="getClassLoader")
        public ClassLoader getClassLoader(Object var1);

        @JavaDispatcher.Proxied(value="getResourceAsStream")
        public InputStream getResourceAsStream(Object var1, String var2) throws IOException;

        @JavaDispatcher.Proxied(value="isExported")
        public boolean isExported(Object var1, String var2, @JavaDispatcher.Proxied(value="java.lang.Module") Object var3);

        @JavaDispatcher.Proxied(value="isOpen")
        public boolean isOpen(Object var1, String var2, @JavaDispatcher.Proxied(value="java.lang.Module") Object var3);

        @JavaDispatcher.Proxied(value="canRead")
        public boolean canRead(Object var1, @JavaDispatcher.Proxied(value="java.lang.Module") Object var2);
    }

    @JavaDispatcher.Proxied(value="java.lang.Class")
    protected static interface Resolver {
        @JavaDispatcher.Defaults
        @JavaDispatcher.Proxied(value="getModule")
        public Object getModule(Class<?> var1);
    }
}

