/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.builder;

import java.lang.instrument.Instrumentation;
import kanela.agent.api.instrumentation.TypeTransformation;
import kanela.agent.builder.KanelaAgentBuilder;
import kanela.agent.builder.KanelaFileTransformer;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.libs.net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import kanela.agent.util.conf.KanelaConfiguration;

public final class AgentInstaller {
    private final KanelaAgentBuilder agentBuilder;
    private final KanelaConfiguration.ModuleConfiguration moduleDescription;
    private final Instrumentation instrumentation;

    private AgentInstaller(KanelaConfiguration config, KanelaConfiguration.ModuleConfiguration moduleDescription, Instrumentation instrumentation) {
        this.moduleDescription = moduleDescription;
        this.agentBuilder = KanelaAgentBuilder.from(config, moduleDescription, instrumentation);
        this.instrumentation = instrumentation;
    }

    public static AgentInstaller from(KanelaConfiguration config, KanelaConfiguration.ModuleConfiguration moduleDescription, Instrumentation instrumentation) {
        return new AgentInstaller(config, moduleDescription, instrumentation);
    }

    public KanelaFileTransformer install() {
        AgentBuilder agentBuilder = this.agentBuilder.build();
        ResettableClassFileTransformer classFileTransformer = agentBuilder.installOn(this.instrumentation);
        return KanelaFileTransformer.from(agentBuilder, classFileTransformer, this.moduleDescription.isStoppable());
    }

    public AgentInstaller addTypeTransformation(TypeTransformation typeTransformation) {
        this.agentBuilder.addTypeTransformation(typeTransformation);
        return this;
    }

    public KanelaAgentBuilder getAgentBuilder() {
        return this.agentBuilder;
    }

    public KanelaConfiguration.ModuleConfiguration getModuleDescription() {
        return this.moduleDescription;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentInstaller)) {
            return false;
        }
        AgentInstaller other = (AgentInstaller)o;
        KanelaAgentBuilder this$agentBuilder = this.getAgentBuilder();
        KanelaAgentBuilder other$agentBuilder = other.getAgentBuilder();
        if (this$agentBuilder == null ? other$agentBuilder != null : !((Object)this$agentBuilder).equals(other$agentBuilder)) {
            return false;
        }
        KanelaConfiguration.ModuleConfiguration this$moduleDescription = this.getModuleDescription();
        KanelaConfiguration.ModuleConfiguration other$moduleDescription = other.getModuleDescription();
        if (this$moduleDescription == null ? other$moduleDescription != null : !((Object)this$moduleDescription).equals(other$moduleDescription)) {
            return false;
        }
        Instrumentation this$instrumentation = this.getInstrumentation();
        Instrumentation other$instrumentation = other.getInstrumentation();
        return !(this$instrumentation == null ? other$instrumentation != null : !this$instrumentation.equals(other$instrumentation));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KanelaAgentBuilder $agentBuilder = this.getAgentBuilder();
        result = result * 59 + ($agentBuilder == null ? 43 : ((Object)$agentBuilder).hashCode());
        KanelaConfiguration.ModuleConfiguration $moduleDescription = this.getModuleDescription();
        result = result * 59 + ($moduleDescription == null ? 43 : ((Object)$moduleDescription).hashCode());
        Instrumentation $instrumentation = this.getInstrumentation();
        result = result * 59 + ($instrumentation == null ? 43 : $instrumentation.hashCode());
        return result;
    }

    public String toString() {
        return "AgentInstaller(agentBuilder=" + this.getAgentBuilder() + ", moduleDescription=" + this.getModuleDescription() + ", instrumentation=" + this.getInstrumentation() + ")";
    }
}

