/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.cache;

import java.lang.ref.SoftReference;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kanela.agent.libs.com.blogspot.mydailyjava.weaklockfree.WeakConcurrentMap;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.libs.net.bytebuddy.pool.TypePool;
import kanela.agent.util.NamedThreadFactory;

public final class PoolStrategyCache
extends AgentBuilder.PoolStrategy.WithTypePoolCache {
    private static final PoolStrategyCache Instance = new PoolStrategyCache();
    private final WeakConcurrentMap<ClassLoader, SoftReferenceCacheProvider> cache = new WeakConcurrentMap(false);

    private PoolStrategyCache() {
        super(TypePool.Default.ReaderMode.FAST);
        Executors.newScheduledThreadPool(1, NamedThreadFactory.instance("cache-pool-cleaner")).scheduleWithFixedDelay(() -> {
            this.removeAfterLastMinuteAccess();
            this.cache.expungeStaleEntries();
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    @Override
    protected TypePool.CacheProvider locate(ClassLoader classLoader) {
        TypePool.CacheProvider cacheProvider;
        ClassLoader loader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        SoftReferenceCacheProvider providerRef = (SoftReferenceCacheProvider)this.cache.getIfPresent(loader);
        if (providerRef == null || providerRef.get() == null) {
            providerRef = SoftReferenceCacheProvider.newOne();
            this.cache.put(loader, providerRef);
            providerRef = (SoftReferenceCacheProvider)this.cache.get(loader);
        }
        return (cacheProvider = providerRef.get()) != null ? cacheProvider : TypePool.CacheProvider.Simple.withObjectType();
    }

    public static PoolStrategyCache instance() {
        return Instance;
    }

    private void removeAfterLastMinuteAccess() {
        this.cache.forEach(entry -> {
            if (System.currentTimeMillis() >= ((SoftReferenceCacheProvider)entry.getValue()).getLastAccess() + TimeUnit.MINUTES.toMillis(1L)) {
                this.cache.remove((ClassLoader)entry.getKey());
            }
        });
    }

    public WeakConcurrentMap<ClassLoader, SoftReferenceCacheProvider> getCache() {
        return this.cache;
    }

    public String toString() {
        return "PoolStrategyCache(cache=" + this.getCache() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PoolStrategyCache)) {
            return false;
        }
        PoolStrategyCache other = (PoolStrategyCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WeakConcurrentMap<ClassLoader, SoftReferenceCacheProvider> this$cache = this.getCache();
        WeakConcurrentMap<ClassLoader, SoftReferenceCacheProvider> other$cache = other.getCache();
        return !(this$cache == null ? other$cache != null : !this$cache.equals(other$cache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PoolStrategyCache;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WeakConcurrentMap<ClassLoader, SoftReferenceCacheProvider> $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        return result;
    }

    private static final class SoftReferenceCacheProvider {
        private final AtomicLong lastAccess = new AtomicLong(System.currentTimeMillis());
        private final SoftReference<TypePool.CacheProvider> delegate = new SoftReference<TypePool.CacheProvider.Simple>(new TypePool.CacheProvider.Simple());

        long getLastAccess() {
            return this.lastAccess.get();
        }

        TypePool.CacheProvider get() {
            return this.delegate.get();
        }

        private SoftReferenceCacheProvider() {
        }

        public static SoftReferenceCacheProvider newOne() {
            return new SoftReferenceCacheProvider();
        }

        public SoftReference<TypePool.CacheProvider> getDelegate() {
            return this.delegate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SoftReferenceCacheProvider)) {
                return false;
            }
            SoftReferenceCacheProvider other = (SoftReferenceCacheProvider)o;
            if (this.getLastAccess() != other.getLastAccess()) {
                return false;
            }
            SoftReference<TypePool.CacheProvider> this$delegate = this.getDelegate();
            SoftReference<TypePool.CacheProvider> other$delegate = other.getDelegate();
            return !(this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $lastAccess = this.getLastAccess();
            result = result * 59 + (int)($lastAccess >>> 32 ^ $lastAccess);
            SoftReference<TypePool.CacheProvider> $delegate = this.getDelegate();
            result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
            return result;
        }

        public String toString() {
            return "PoolStrategyCache.SoftReferenceCacheProvider(lastAccess=" + this.getLastAccess() + ", delegate=" + this.getDelegate() + ")";
        }
    }
}

