/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.org.pmw.tinylog;

import java.util.ArrayList;
import java.util.List;
import kanela.agent.libs.org.pmw.tinylog.InternalLogger;
import kanela.agent.libs.org.pmw.tinylog.LogEntry;
import kanela.agent.libs.org.pmw.tinylog.writers.Writer;

final class WritingThread
extends Thread {
    private static final String THREAD_NAME = "tinylog-WritingThread";
    private volatile List<WritingTask> entries = new ArrayList<WritingTask>();
    private final String nameOfThreadToObserve;
    private final Thread threadToObserve;
    private volatile boolean shutdown;

    WritingThread(String string, int n) {
        this.nameOfThreadToObserve = string;
        this.threadToObserve = string == null ? null : WritingThread.getThread(string);
        this.setName(THREAD_NAME);
        this.setPriority(n);
    }

    public String getNameOfThreadToObserve() {
        return this.nameOfThreadToObserve;
    }

    public Thread getThreadToObserve() {
        return this.threadToObserve;
    }

    public synchronized void putLogEntry(Writer writer, LogEntry logEntry) {
        this.entries.add(new WritingTask(writer, logEntry));
    }

    @Override
    public void run() {
        while (true) {
            boolean bl = this.shutdown || this.threadToObserve != null && !this.threadToObserve.isAlive();
            List<WritingTask> list = this.getWritingTasks();
            while (list != null) {
                ArrayList<Writer> arrayList = new ArrayList<Writer>();
                for (WritingTask writingTask : list) {
                    try {
                        Writer exception = writingTask.writer;
                        exception.write(writingTask.logEntry);
                        if (arrayList.contains(exception)) continue;
                        arrayList.add(exception);
                    }
                    catch (Exception exception) {
                        InternalLogger.error(exception, "Failed to write log entry");
                    }
                }
                for (Writer writer : arrayList) {
                    try {
                        writer.flush();
                    }
                    catch (Exception exception) {
                        InternalLogger.error(exception, "Failed to flush writer");
                    }
                }
                list = this.getWritingTasks();
            }
            if (bl) break;
            try {
                WritingThread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    private static Thread getThread(String string) {
        int n;
        Thread[] threadArray;
        int n2;
        ThreadGroup threadGroup = WritingThread.getRootThreadGroup(Thread.currentThread().getThreadGroup());
        while ((n2 = threadGroup.enumerate(threadArray = new Thread[n = Math.max(32, threadGroup.activeCount() * 2)])) >= n) {
        }
        for (int i = 0; i < n2; ++i) {
            if (!string.equals(threadArray[i].getName())) continue;
            return threadArray[i];
        }
        return null;
    }

    private static ThreadGroup getRootThreadGroup(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = threadGroup.getParent();
        if (threadGroup2 == null) {
            return threadGroup;
        }
        return WritingThread.getRootThreadGroup(threadGroup2);
    }

    private synchronized List<WritingTask> getWritingTasks() {
        if (this.entries.isEmpty()) {
            return null;
        }
        List<WritingTask> list = this.entries;
        this.entries = new ArrayList<WritingTask>();
        return list;
    }

    private static final class WritingTask {
        private final Writer writer;
        private final LogEntry logEntry;

        private WritingTask(Writer writer, LogEntry logEntry) {
            this.writer = writer;
            this.logEntry = logEntry;
        }
    }
}

