/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.cache;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.libs.net.bytebuddy.pool.TypePool;
import kanela.agent.libs.net.jodah.expiringmap.ExpirationListener;
import kanela.agent.libs.net.jodah.expiringmap.ExpirationPolicy;
import kanela.agent.libs.net.jodah.expiringmap.ExpiringMap;
import kanela.agent.util.NamedThreadFactory;
import kanela.agent.util.log.Logger;

public final class PoolStrategyCache
extends AgentBuilder.PoolStrategy.WithTypePoolCache {
    private static final PoolStrategyCache Instance = new PoolStrategyCache();
    private final Map<ClassLoader, TypePool.CacheProvider> cache;

    private PoolStrategyCache() {
        super(TypePool.Default.ReaderMode.FAST);
        ExpiringMap.setThreadFactory(NamedThreadFactory.instance("strategy-cache-listener"));
        this.cache = ExpiringMap.builder().entryLoader(key -> TypePool.CacheProvider.Simple.withObjectType()).expiration(1L, TimeUnit.MINUTES).expirationPolicy(ExpirationPolicy.ACCESSED).asyncExpirationListener(this.LogExpirationListener()).build();
    }

    @Override
    protected TypePool.CacheProvider locate(ClassLoader classLoader) {
        ClassLoader mapKey = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        return this.cache.get(mapKey);
    }

    private ExpirationListener<Object, TypePool.CacheProvider> LogExpirationListener() {
        return (key, value) -> Logger.debug(() -> "Expiring key: " + key + "with value" + value);
    }

    public static PoolStrategyCache instance() {
        return Instance;
    }

    public Map<ClassLoader, TypePool.CacheProvider> getCache() {
        return this.cache;
    }

    public String toString() {
        return "PoolStrategyCache(cache=" + this.getCache() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PoolStrategyCache)) {
            return false;
        }
        PoolStrategyCache other = (PoolStrategyCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<ClassLoader, TypePool.CacheProvider> this$cache = this.getCache();
        Map<ClassLoader, TypePool.CacheProvider> other$cache = other.getCache();
        return !(this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PoolStrategyCache;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<ClassLoader, TypePool.CacheProvider> $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        return result;
    }
}

