/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.org.pmw.tinylog.policies;

import java.io.File;
import kanela.agent.libs.org.pmw.tinylog.Configuration;
import kanela.agent.libs.org.pmw.tinylog.policies.Policy;
import kanela.agent.libs.org.pmw.tinylog.policies.PropertiesSupport;

@PropertiesSupport(name="size")
public final class SizePolicy
implements Policy {
    private final long maxSize;
    private long size;

    public SizePolicy(long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException("maxSize must be > 0");
        }
        this.maxSize = l;
        this.size = 0L;
    }

    SizePolicy(String string) throws IllegalArgumentException {
        try {
            this.maxSize = string.endsWith("GB") ? Long.parseLong(string.substring(0, string.length() - 2).trim()) * 1024L * 1024L * 1024L : (string.endsWith("MB") ? Long.parseLong(string.substring(0, string.length() - 2).trim()) * 1024L * 1024L : (string.endsWith("KB") ? Long.parseLong(string.substring(0, string.length() - 2).trim()) * 1024L : Long.parseLong(string)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Size \"" + string + "\" is not numberic");
        }
        if (this.maxSize <= 0L) {
            throw new IllegalArgumentException("Size must be > 0, but is " + this.maxSize);
        }
        this.size = 0L;
    }

    @Override
    public void init(Configuration configuration) {
    }

    @Override
    public boolean check(File file) {
        if (file.exists()) {
            this.size = file.length();
            return this.size <= this.maxSize;
        }
        return true;
    }

    @Override
    public boolean check(String string) {
        this.size += (long)string.getBytes().length;
        return this.size <= this.maxSize;
    }

    @Override
    public void reset() {
        this.size = 0L;
    }
}

