/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.cache;

import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kanela.agent.libs.com.blogspot.mydailyjava.weaklockfree.WeakConcurrentMap;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.libs.net.bytebuddy.pool.TypePool;
import kanela.agent.util.NamedThreadFactory;

public final class PoolStrategyCache
extends AgentBuilder.PoolStrategy.WithTypePoolCache {
    private static final PoolStrategyCache Instance = new PoolStrategyCache();
    private final WeakConcurrentMap<Object, TypePool.CacheProvider> cache;

    private PoolStrategyCache() {
        super(TypePool.Default.ReaderMode.FAST);
        Executors.newScheduledThreadPool(1, NamedThreadFactory.instance("strategy-cache-listener")).scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                PoolStrategyCache.this.cache.expungeStaleEntries();
            }
        }, 1L, 1L, TimeUnit.MINUTES);
        this.cache = new WeakConcurrentMap(false);
    }

    @Override
    protected TypePool.CacheProvider locate(ClassLoader classLoader) {
        ClassLoader mapKey = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        TypePool.CacheProvider mapValue = this.cache.getIfPresent(mapKey);
        if (mapValue == null) {
            this.cache.put(mapKey, TypePool.CacheProvider.Simple.withObjectType());
            return this.cache.get(mapKey);
        }
        return mapValue;
    }

    public static PoolStrategyCache instance() {
        return Instance;
    }

    public WeakConcurrentMap<Object, TypePool.CacheProvider> getCache() {
        return this.cache;
    }

    public String toString() {
        return "PoolStrategyCache(cache=" + this.getCache() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PoolStrategyCache)) {
            return false;
        }
        PoolStrategyCache other = (PoolStrategyCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WeakConcurrentMap<Object, TypePool.CacheProvider> this$cache = this.getCache();
        WeakConcurrentMap<Object, TypePool.CacheProvider> other$cache = other.getCache();
        return !(this$cache == null ? other$cache != null : !this$cache.equals(other$cache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PoolStrategyCache;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WeakConcurrentMap<Object, TypePool.CacheProvider> $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        return result;
    }
}

