/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util.classloader;

import java.util.stream.Collectors;
import kanela.agent.api.instrumentation.classloader.ClassLoaderRefiner;
import kanela.agent.libs.io.vavr.control.Option;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatcher;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatchers;
import kanela.agent.util.classloader.AnalyzedClass;
import kanela.agent.util.classloader.ChildFirstURLClassLoader;
import kanela.agent.util.classloader.ScalaCompilerClassLoaderMatcher;
import kanela.agent.util.collection.ConcurrentReferenceHashMap;

public final class ClassLoaderNameMatcher
extends ElementMatcher.Junction.AbstractBase<ClassLoader> {
    private final String name;

    private ClassLoaderNameMatcher(String name) {
        this.name = name;
    }

    public static ElementMatcher.Junction.AbstractBase<ClassLoader> withName(String name) {
        return new ClassLoaderNameMatcher(name);
    }

    public static ElementMatcher.Junction.AbstractBase<ClassLoader> isReflectionClassLoader() {
        return new ClassLoaderNameMatcher("sun.reflect.DelegatingClassLoader");
    }

    public static ElementMatcher.Junction.AbstractBase<ClassLoader> isGroovyClassLoader() {
        return new ClassLoaderNameMatcher("org.codehaus.groovy.runtime.callsite.CallSiteClassLoader");
    }

    public static ElementMatcher.Junction.AbstractBase<ClassLoader> isSBTClassLoader() {
        return new ClassLoaderNameMatcher("xsbt.boot.LibraryClassLoader");
    }

    public static ElementMatcher.Junction.AbstractBase<ClassLoader> isSBTPluginClassLoader() {
        return new ClassLoaderNameMatcher("sbt.internal.PluginManagement$PluginClassLoader");
    }

    public static ElementMatcher.Junction.AbstractBase<ClassLoader> isSBTCachedClassLoader() {
        return new ClassLoaderNameMatcher("sbt.internal.classpath.ClassLoaderCache$Key$CachedClassLoader");
    }

    public static ElementMatcher.Junction.AbstractBase<ClassLoader> isSBTCompilerClassLoader() {
        return new ScalaCompilerClassLoaderMatcher();
    }

    public static ElementMatcher.Junction.AbstractBase<ClassLoader> isKanelaClassLoader() {
        return new ClassLoaderNameMatcher(ChildFirstURLClassLoader.class.getName());
    }

    @Override
    public boolean matches(ClassLoader target) {
        return target != null && this.name.equals(target.getClass().getName());
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ClassLoaderNameMatcher(name=" + this.getName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassLoaderNameMatcher)) {
            return false;
        }
        ClassLoaderNameMatcher other = (ClassLoaderNameMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassLoaderNameMatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public static final class RefinedClassLoaderMatcher
    extends ElementMatcher.Junction.AbstractBase<ClassLoader> {
        private final ConcurrentReferenceHashMap<ClassLoader, Boolean> cache = new ConcurrentReferenceHashMap();
        private final ClassLoaderRefiner refiner;

        public static ElementMatcher<? super ClassLoader> from(Option<ClassLoaderRefiner> classLoaderRefiner) {
            return classLoaderRefiner.map(refiner -> new RefinedClassLoaderMatcher((ClassLoaderRefiner)refiner)).getOrElse(ElementMatchers::any);
        }

        @Override
        public boolean matches(ClassLoader classLoader) {
            if (classLoader == null) {
                return false;
            }
            return this.cache.computeIfAbsent(classLoader, key -> this.compute(this.refiner, classLoader));
        }

        private boolean compute(ClassLoaderRefiner classRefiner, ClassLoader classLoader) {
            return !classRefiner.refiners().stream().map(refiner -> AnalyzedClass.from(refiner, classLoader).match()).collect(Collectors.toList()).contains(false);
        }

        public RefinedClassLoaderMatcher(ClassLoaderRefiner refiner) {
            this.refiner = refiner;
        }

        public ConcurrentReferenceHashMap<ClassLoader, Boolean> getCache() {
            return this.cache;
        }

        public ClassLoaderRefiner getRefiner() {
            return this.refiner;
        }

        public String toString() {
            return "ClassLoaderNameMatcher.RefinedClassLoaderMatcher(cache=" + this.getCache() + ", refiner=" + this.getRefiner() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefinedClassLoaderMatcher)) {
                return false;
            }
            RefinedClassLoaderMatcher other = (RefinedClassLoaderMatcher)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ConcurrentReferenceHashMap<ClassLoader, Boolean> this$cache = this.getCache();
            ConcurrentReferenceHashMap<ClassLoader, Boolean> other$cache = other.getCache();
            if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
                return false;
            }
            ClassLoaderRefiner this$refiner = this.getRefiner();
            ClassLoaderRefiner other$refiner = other.getRefiner();
            return !(this$refiner == null ? other$refiner != null : !this$refiner.equals(other$refiner));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RefinedClassLoaderMatcher;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ConcurrentReferenceHashMap<ClassLoader, Boolean> $cache = this.getCache();
            result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
            ClassLoaderRefiner $refiner = this.getRefiner();
            result = result * 59 + ($refiner == null ? 43 : $refiner.hashCode());
            return result;
        }
    }
}

