/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.instrumentation;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kanela.agent.api.instrumentation.classloader.ClassLoaderRefiner;
import kanela.agent.libs.io.vavr.control.Option;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.libs.net.bytebuddy.description.type.TypeDescription;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatcher;

public final class TypeTransformation {
    private final String instrumentationName;
    private final Option<ElementMatcher<? super TypeDescription>> elementMatcher;
    private final Option<ClassLoaderRefiner> classLoaderRefiner;
    private final List<AgentBuilder.Transformer> bridges;
    private final List<AgentBuilder.Transformer> mixins;
    private final List<AgentBuilder.Transformer> transformations;

    @SafeVarargs
    static TypeTransformation of(String instrumentationName, Option<ElementMatcher<? super TypeDescription>> elementMatcher, Option<ClassLoaderRefiner> classLoaderRefiner, List<AgentBuilder.Transformer> bridges, List<AgentBuilder.Transformer> mixins, List<AgentBuilder.Transformer> ... transformers) {
        List<AgentBuilder.Transformer> transformations = Arrays.stream(transformers).flatMap(Collection::stream).collect(Collectors.toList());
        return new TypeTransformation(instrumentationName, elementMatcher, classLoaderRefiner, bridges, mixins, transformations);
    }

    public TypeTransformation(String instrumentationName, Option<ElementMatcher<? super TypeDescription>> elementMatcher, Option<ClassLoaderRefiner> classLoaderRefiner, List<AgentBuilder.Transformer> bridges, List<AgentBuilder.Transformer> mixins, List<AgentBuilder.Transformer> transformations) {
        this.instrumentationName = instrumentationName;
        this.elementMatcher = elementMatcher;
        this.classLoaderRefiner = classLoaderRefiner;
        this.bridges = bridges;
        this.mixins = mixins;
        this.transformations = transformations;
    }

    public String getInstrumentationName() {
        return this.instrumentationName;
    }

    public Option<ElementMatcher<? super TypeDescription>> getElementMatcher() {
        return this.elementMatcher;
    }

    public Option<ClassLoaderRefiner> getClassLoaderRefiner() {
        return this.classLoaderRefiner;
    }

    public List<AgentBuilder.Transformer> getBridges() {
        return this.bridges;
    }

    public List<AgentBuilder.Transformer> getMixins() {
        return this.mixins;
    }

    public List<AgentBuilder.Transformer> getTransformations() {
        return this.transformations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeTransformation)) {
            return false;
        }
        TypeTransformation other = (TypeTransformation)o;
        String this$instrumentationName = this.getInstrumentationName();
        String other$instrumentationName = other.getInstrumentationName();
        if (this$instrumentationName == null ? other$instrumentationName != null : !this$instrumentationName.equals(other$instrumentationName)) {
            return false;
        }
        Option<ElementMatcher<? super TypeDescription>> this$elementMatcher = this.getElementMatcher();
        Option<ElementMatcher<? super TypeDescription>> other$elementMatcher = other.getElementMatcher();
        if (this$elementMatcher == null ? other$elementMatcher != null : !((Object)this$elementMatcher).equals(other$elementMatcher)) {
            return false;
        }
        Option<ClassLoaderRefiner> this$classLoaderRefiner = this.getClassLoaderRefiner();
        Option<ClassLoaderRefiner> other$classLoaderRefiner = other.getClassLoaderRefiner();
        if (this$classLoaderRefiner == null ? other$classLoaderRefiner != null : !((Object)this$classLoaderRefiner).equals(other$classLoaderRefiner)) {
            return false;
        }
        List<AgentBuilder.Transformer> this$bridges = this.getBridges();
        List<AgentBuilder.Transformer> other$bridges = other.getBridges();
        if (this$bridges == null ? other$bridges != null : !((Object)this$bridges).equals(other$bridges)) {
            return false;
        }
        List<AgentBuilder.Transformer> this$mixins = this.getMixins();
        List<AgentBuilder.Transformer> other$mixins = other.getMixins();
        if (this$mixins == null ? other$mixins != null : !((Object)this$mixins).equals(other$mixins)) {
            return false;
        }
        List<AgentBuilder.Transformer> this$transformations = this.getTransformations();
        List<AgentBuilder.Transformer> other$transformations = other.getTransformations();
        return !(this$transformations == null ? other$transformations != null : !((Object)this$transformations).equals(other$transformations));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $instrumentationName = this.getInstrumentationName();
        result = result * 59 + ($instrumentationName == null ? 43 : $instrumentationName.hashCode());
        Option<ElementMatcher<? super TypeDescription>> $elementMatcher = this.getElementMatcher();
        result = result * 59 + ($elementMatcher == null ? 43 : ((Object)$elementMatcher).hashCode());
        Option<ClassLoaderRefiner> $classLoaderRefiner = this.getClassLoaderRefiner();
        result = result * 59 + ($classLoaderRefiner == null ? 43 : ((Object)$classLoaderRefiner).hashCode());
        List<AgentBuilder.Transformer> $bridges = this.getBridges();
        result = result * 59 + ($bridges == null ? 43 : ((Object)$bridges).hashCode());
        List<AgentBuilder.Transformer> $mixins = this.getMixins();
        result = result * 59 + ($mixins == null ? 43 : ((Object)$mixins).hashCode());
        List<AgentBuilder.Transformer> $transformations = this.getTransformations();
        result = result * 59 + ($transformations == null ? 43 : ((Object)$transformations).hashCode());
        return result;
    }

    public String toString() {
        return "TypeTransformation(instrumentationName=" + this.getInstrumentationName() + ", elementMatcher=" + this.getElementMatcher() + ", classLoaderRefiner=" + this.getClassLoaderRefiner() + ", bridges=" + this.getBridges() + ", mixins=" + this.getMixins() + ", transformations=" + this.getTransformations() + ")";
    }
}

