/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.org.pmw.tinylog.writers;

import android.util.Log;
import java.util.EnumSet;
import java.util.Set;
import kanela.agent.libs.org.pmw.tinylog.Configuration;
import kanela.agent.libs.org.pmw.tinylog.InternalLogger;
import kanela.agent.libs.org.pmw.tinylog.LogEntry;
import kanela.agent.libs.org.pmw.tinylog.writers.LogEntryValue;
import kanela.agent.libs.org.pmw.tinylog.writers.PropertiesSupport;
import kanela.agent.libs.org.pmw.tinylog.writers.Property;
import kanela.agent.libs.org.pmw.tinylog.writers.Writer;

@PropertiesSupport(name="logcat", properties={@Property(name="tag", type=String.class, optional=true)})
public final class LogcatWriter
implements Writer {
    private static final int TAG_MAX_LENGTH = 23;
    private final String tag;

    public LogcatWriter() {
        this.tag = null;
    }

    public LogcatWriter(String string) {
        this.tag = LogcatWriter.trim(string);
    }

    @Override
    public Set<LogEntryValue> getRequiredLogEntryValues() {
        if (this.tag == null) {
            return EnumSet.of(LogEntryValue.LEVEL, LogEntryValue.CLASS, LogEntryValue.RENDERED_LOG_ENTRY);
        }
        return EnumSet.of(LogEntryValue.LEVEL, LogEntryValue.RENDERED_LOG_ENTRY);
    }

    @Override
    public void init(Configuration configuration) {
        try {
            Class.forName("android.util.Log");
        }
        catch (ClassNotFoundException classNotFoundException) {
            InternalLogger.error("Logcat writer works only on Android");
        }
    }

    @Override
    public void write(LogEntry logEntry) {
        String string = this.tag == null ? LogcatWriter.trim(LogcatWriter.getNameOfClass(logEntry.getClassName())) : this.tag;
        switch (logEntry.getLevel()) {
            case TRACE: {
                Log.v((String)string, (String)logEntry.getRenderedLogEntry());
                break;
            }
            case DEBUG: {
                Log.d((String)string, (String)logEntry.getRenderedLogEntry());
                break;
            }
            case INFO: {
                Log.i((String)string, (String)logEntry.getRenderedLogEntry());
                break;
            }
            case WARNING: {
                Log.w((String)string, (String)logEntry.getRenderedLogEntry());
                break;
            }
            case ERROR: {
                Log.e((String)string, (String)logEntry.getRenderedLogEntry());
                break;
            }
            default: {
                InternalLogger.warn("Unexpected logging level: {}", new Object[]{logEntry.getLevel()});
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private static String getNameOfClass(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static String trim(String string) {
        if (string.length() > 23) {
            return string.substring(0, 20) + "...";
        }
        return string;
    }
}

