/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util;

import java.util.concurrent.TimeUnit;
import kanela.agent.libs.io.vavr.control.Try;
import kanela.agent.util.log.Logger;

public class Execution {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void timed(Runnable thunk) {
        long startMillis = System.nanoTime();
        try {
            thunk.run();
        }
        finally {
            long timeSpent = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startMillis, TimeUnit.NANOSECONDS);
            Logger.info(() -> "Startup completed in " + timeSpent + " ms");
        }
    }

    public static void runWithTimeSpent(Runnable thunk) {
        try {
            Execution.timed(thunk);
        }
        catch (Throwable cause) {
            Logger.error(() -> "Unable to start Kanela Agent. Please remove -javaagent from your startup arguments and contact Kanela support.", cause);
            Try.run(() -> Thread.sleep(100L));
            System.exit(1);
        }
    }
}

