/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.sbt.play;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicBoolean;
import kamon.instrumentation.sbt.SbtKanelaRunner$;
import kamon.instrumentation.sbt.play.KanelaReloader;
import kamon.instrumentation.sbt.play.KanelaReloader$;
import kamon.instrumentation.sbt.play.SbtKanelaRunnerPlay;
import kamon.instrumentation.sbt.play.SbtKanelaRunnerPlay$SbtKanelaClassLoader$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.core.Build;
import play.core.BuildLink;
import play.core.server.ReloadableServer;
import play.dev.filewatch.FileWatchService;
import play.runsupport.AssetsClassLoader;
import play.runsupport.NamedURLClassLoader;
import play.runsupport.Reloader;
import play.runsupport.RunHook;
import play.runsupport.RunHook$;
import play.runsupport.ServerStartException;
import play.runsupport.classloader.ApplicationClassLoaderProvider;
import play.runsupport.classloader.DelegatingClassLoader;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.sys.package$;
import scala.util.matching.Regex;

public final class KanelaReloader$ {
    public static KanelaReloader$ MODULE$;
    private final Regex SystemProperty;
    private final AccessControlContext accessControlContext;

    static {
        new KanelaReloader$();
    }

    public Regex SystemProperty() {
        return this.SystemProperty;
    }

    private AccessControlContext accessControlContext() {
        return this.accessControlContext;
    }

    public <T> T kamon$instrumentation$sbt$play$KanelaReloader$$withReloaderContextClassLoader(Function0<T> f) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        return AccessController.doPrivileged(new PrivilegedAction<T>(thread, f, oldLoader){
            private final Thread thread$1;
            private final Function0 f$1;
            private final ClassLoader oldLoader$1;

            public T run() {
                Object object;
                try {
                    this.thread$1.setContextClassLoader(KanelaReloader.class.getClassLoader());
                    object = this.f$1.apply();
                }
                finally {
                    this.thread$1.setContextClassLoader(this.oldLoader$1);
                }
                return (T)object;
            }
            {
                this.thread$1 = thread$1;
                this.f$1 = f$1;
                this.oldLoader$1 = oldLoader$1;
            }
        }, this.accessControlContext());
    }

    public Seq<Tuple2<String, String>> extractSystemProperties(Seq<String> javaOptions) {
        return (Seq)javaOptions.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = KanelaReloader$.MODULE$.SystemProperty().unapplySeq(A1);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                    String key = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String value = (String)((LinearSeqOptimized)option.get()).apply(1);
                    object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                Option option = KanelaReloader$.MODULE$.SystemProperty().unapplySeq((CharSequence)string);
                boolean bl = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public int parsePort(String portString) {
        int n;
        try {
            n = Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            throw package$.MODULE$.error(new StringBuilder(23).append("Invalid port argument: ").append(portString).toString());
        }
        return n;
    }

    public Tuple4<Seq<Tuple2<String, String>>, Option<Object>, Option<Object>, String> filterArgs(Seq<String> args, int defaultHttpPort, String defaultHttpAddress, Seq<Tuple2<String, String>> devSettings) {
        Tuple2 tuple2 = args.partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("-D")));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq propertyArgs = (Seq)tuple2._1();
        Seq otherArgs = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)propertyArgs, (Object)otherArgs);
        Tuple2 tuple23 = tuple22;
        Seq propertyArgs2 = (Seq)tuple23._1();
        Seq otherArgs2 = (Seq)tuple23._2();
        Seq properties = (Seq)propertyArgs2.map((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(x$3)).drop(2))).span((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KanelaReloader$.$anonfun$filterArgs$3(BoxesRunTime.unboxToChar((Object)x$4))));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), new StringOps(Predef$.MODULE$.augmentString(v)).tail());
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map props = properties.toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map devMap = devSettings.toMap(Predef$.MODULE$.$conforms());
        Option httpPortString = KanelaReloader$.prop$1("play.server.http.port", props).orElse((Function0 & Serializable & scala.Serializable)() -> KanelaReloader$.prop$1("http.port", props)).orElse((Function0 & Serializable & scala.Serializable)() -> otherArgs2.headOption()).orElse((Function0 & Serializable & scala.Serializable)() -> devMap.get((Object)"play.server.http.port")).orElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.env().get((Object)"PLAY_HTTP_PORT"));
        Option httpPort = this.parsePortValue$1(httpPortString, Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)defaultHttpPort)));
        Option httpsPortString = KanelaReloader$.prop$1("play.server.https.port", props).orElse((Function0 & Serializable & scala.Serializable)() -> KanelaReloader$.prop$1("https.port", props)).orElse((Function0 & Serializable & scala.Serializable)() -> devMap.get((Object)"play.server.https.port")).orElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.env().get((Object)"PLAY_HTTPS_PORT"));
        Option httpsPort = this.parsePortValue$1(httpsPortString, KanelaReloader$.parsePortValue$default$2$1());
        String httpAddress = (String)KanelaReloader$.prop$1("play.server.http.address", props).orElse((Function0 & Serializable & scala.Serializable)() -> KanelaReloader$.prop$1("http.address", props)).orElse((Function0 & Serializable & scala.Serializable)() -> devMap.get((Object)"play.server.http.address")).orElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.env().get((Object)"PLAY_HTTP_ADDRESS")).getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultHttpAddress);
        return new Tuple4((Object)properties, (Object)httpPort, (Object)httpsPort, (Object)httpAddress);
    }

    public URL[] urls(Seq<File> cp) {
        return (URL[])((TraversableOnce)cp.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toURI().toURL(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(URL.class));
    }

    public ClassLoader assetsClassLoader(Seq<Tuple2<String, File>> allAssets, ClassLoader parent) {
        return new AssetsClassLoader(parent, allAssets);
    }

    public URLClassLoader commonClassLoader(Seq<File> classpath) {
        LazyRef commonJars$lzy = new LazyRef();
        return new URLClassLoader(classpath, commonJars$lzy){

            public String toString() {
                return new StringBuilder(20).append("Common ClassLoader: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getURLs())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")).toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$toString$1(java.net.URL )}, serializedLambda);
            }
        };
    }

    public KanelaReloader.DevServer startDevMode(Seq<RunHook> runHooks, Seq<String> javaOptions, ClassLoader commonClassLoader, Seq<File> dependencyClasspath, Function0<Reloader.CompileResult> reloadCompile, Function1<ClassLoader, ClassLoader> assetsClassLoader, Seq<File> monitoredFiles, FileWatchService fileWatchService, scala.collection.immutable.Map<String, Reloader.GeneratedSourceMapping> generatedSourceHandlers, int defaultHttpPort, String defaultHttpAddress, File projectPath, Seq<Tuple2<String, String>> devSettings, Seq<String> args, String mainClassName, Object reloadLock, File kanelaAgentJar) {
        KanelaReloader.DevServer devServer;
        LazyRef delegatingLoader$lzy = new LazyRef();
        LazyRef applicationLoader$lzy = new LazyRef();
        LazyRef assetsLoader$lzy = new LazyRef();
        LazyRef reloader$lzy = new LazyRef();
        Tuple4<Seq<Tuple2<String, String>>, Option<Object>, Option<Object>, String> tuple4 = this.filterArgs(args, defaultHttpPort, defaultHttpAddress, devSettings);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Seq systemPropertiesArgs = (Seq)tuple4._1();
        Option httpPort = (Option)tuple4._2();
        Option httpsPort = (Option)tuple4._3();
        String httpAddress = (String)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)systemPropertiesArgs, (Object)httpPort, (Object)httpsPort, (Object)httpAddress);
        Tuple4 tuple43 = tuple42;
        Seq systemPropertiesArgs2 = (Seq)tuple43._1();
        Option httpPort2 = (Option)tuple43._2();
        Option httpsPort2 = (Option)tuple43._3();
        String httpAddress2 = (String)tuple43._4();
        Seq<Tuple2<String, String>> systemPropertiesJavaOptions = this.extractSystemProperties(javaOptions);
        Predef$.MODULE$.require(httpPort2.isDefined() || httpsPort2.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "You have to specify https.port when http.port is disabled");
        Seq systemPropertiesAddressPorts = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"play.server.http.address"), (Object)httpAddress2)}))).$plus$plus((GenTraversableOnce)httpPort2.map((Function1 & Serializable & scala.Serializable)port -> KanelaReloader$.$anonfun$startDevMode$2(BoxesRunTime.unboxToInt((Object)port))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)httpsPort2.map((Function1 & Serializable & scala.Serializable)port -> KanelaReloader$.$anonfun$startDevMode$4(BoxesRunTime.unboxToInt((Object)port))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        Seq systemPropertiesCombined = (Seq)((TraversableLike)systemPropertiesJavaOptions.$plus$plus((GenTraversableOnce)systemPropertiesArgs2, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)systemPropertiesAddressPorts, Seq$.MODULE$.canBuildFrom());
        systemPropertiesCombined.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String string = System.setProperty(key, value);
            return string;
        });
        Predef$.MODULE$.println();
        ClassLoader buildLoader = this.getClass().getClassLoader();
        try {
            ReloadableServer reloadableServer;
            Seq qual$1 = RunHook$.MODULE$.RunHooksRunner(runHooks);
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.beforeStarted();
                return BoxedUnit.UNIT;
            };
            boolean x$2 = RunHook.RunHooksRunner$.MODULE$.run$default$2$extension(qual$1);
            RunHook.RunHooksRunner$.MODULE$.run$extension(qual$1, (Function1)x$1, x$2);
            Logger forceLoadingLog4jClasses = LoggerFactory.getLogger((String)"sbt-kanela-runner-hack");
            SbtKanelaRunner$.MODULE$.attachWithInstrumentationClassLoader(kanelaAgentJar, (ClassLoader)((Object)this.applicationLoader$1(applicationLoader$lzy, dependencyClasspath, delegatingLoader$lzy, commonClassLoader, buildLoader, reloader$lzy, reloadCompile, projectPath, devSettings, monitoredFiles, fileWatchService, generatedSourceHandlers, reloadLock, kanelaAgentJar, assetsLoader$lzy, assetsClassLoader)), true);
            Class mainClass = this.applicationLoader$1(applicationLoader$lzy, dependencyClasspath, delegatingLoader$lzy, commonClassLoader, buildLoader, reloader$lzy, reloadCompile, projectPath, devSettings, monitoredFiles, fileWatchService, generatedSourceHandlers, reloadLock, kanelaAgentJar, assetsLoader$lzy, assetsClassLoader).loadClass(mainClassName);
            if (httpPort2.isDefined() && httpsPort2.isDefined()) {
                Method mainDev = mainClass.getMethod("mainDevHttpAndHttpsMode", BuildLink.class, Integer.TYPE, Integer.TYPE, String.class);
                reloadableServer = (ReloadableServer)mainDev.invoke(null, this.kamon$instrumentation$sbt$play$KanelaReloader$$reloader$1(reloader$lzy, reloadCompile, projectPath, devSettings, monitoredFiles, fileWatchService, generatedSourceHandlers, reloadLock, kanelaAgentJar, assetsLoader$lzy, assetsClassLoader, applicationLoader$lzy, dependencyClasspath, delegatingLoader$lzy, commonClassLoader, buildLoader), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)httpPort2.get())), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)httpsPort2.get())), httpAddress2);
            } else if (httpPort2.isDefined()) {
                Method mainDev = mainClass.getMethod("mainDevHttpMode", BuildLink.class, Integer.TYPE, String.class);
                reloadableServer = (ReloadableServer)mainDev.invoke(null, this.kamon$instrumentation$sbt$play$KanelaReloader$$reloader$1(reloader$lzy, reloadCompile, projectPath, devSettings, monitoredFiles, fileWatchService, generatedSourceHandlers, reloadLock, kanelaAgentJar, assetsLoader$lzy, assetsClassLoader, applicationLoader$lzy, dependencyClasspath, delegatingLoader$lzy, commonClassLoader, buildLoader), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)httpPort2.get())), httpAddress2);
            } else {
                Method mainDev = mainClass.getMethod("mainDevOnlyHttpsMode", BuildLink.class, Integer.TYPE, String.class);
                reloadableServer = (ReloadableServer)mainDev.invoke(null, this.kamon$instrumentation$sbt$play$KanelaReloader$$reloader$1(reloader$lzy, reloadCompile, projectPath, devSettings, monitoredFiles, fileWatchService, generatedSourceHandlers, reloadLock, kanelaAgentJar, assetsLoader$lzy, assetsClassLoader, applicationLoader$lzy, dependencyClasspath, delegatingLoader$lzy, commonClassLoader, buildLoader), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)httpsPort2.get())), httpAddress2);
            }
            ReloadableServer server = reloadableServer;
            Seq qual$2 = RunHook$.MODULE$.RunHooksRunner(runHooks);
            Function1 & Serializable & scala.Serializable x$3 = (Function1 & Serializable & scala.Serializable)x$9 -> {
                x$9.afterStarted();
                return BoxedUnit.UNIT;
            };
            boolean x$4 = RunHook.RunHooksRunner$.MODULE$.run$default$2$extension(qual$2);
            RunHook.RunHooksRunner$.MODULE$.run$extension(qual$2, (Function1)x$3, x$4);
            devServer = new KanelaReloader.DevServer(server, runHooks, systemPropertiesCombined, reloader$lzy, reloadCompile, projectPath, devSettings, monitoredFiles, fileWatchService, generatedSourceHandlers, reloadLock, kanelaAgentJar, assetsLoader$lzy, assetsClassLoader, applicationLoader$lzy, dependencyClasspath, delegatingLoader$lzy, commonClassLoader, buildLoader){
                private final KanelaReloader buildLink;
                private final ReloadableServer server$1;
                private final Seq runHooks$1;
                private final Seq systemPropertiesCombined$1;
                private final LazyRef reloader$lzy$1;
                private final Function0 reloadCompile$1;
                private final File projectPath$1;
                private final Seq devSettings$1;
                private final Seq monitoredFiles$1;
                private final FileWatchService fileWatchService$1;
                private final scala.collection.immutable.Map generatedSourceHandlers$1;
                private final Object reloadLock$1;
                private final File kanelaAgentJar$1;
                private final LazyRef assetsLoader$lzy$1;
                private final Function1 assetsClassLoader$1;
                private final LazyRef applicationLoader$lzy$1;
                private final Seq dependencyClasspath$1;
                private final LazyRef delegatingLoader$lzy$1;
                private final ClassLoader commonClassLoader$1;
                private final ClassLoader buildLoader$1;

                public KanelaReloader buildLink() {
                    return this.buildLink;
                }

                public void addChangeListener(Function0<BoxedUnit> f) {
                    KanelaReloader$.MODULE$.kamon$instrumentation$sbt$play$KanelaReloader$$reloader$1(this.reloader$lzy$1, this.reloadCompile$1, this.projectPath$1, this.devSettings$1, this.monitoredFiles$1, this.fileWatchService$1, this.generatedSourceHandlers$1, this.reloadLock$1, this.kanelaAgentJar$1, this.assetsLoader$lzy$1, this.assetsClassLoader$1, this.applicationLoader$lzy$1, this.dependencyClasspath$1, this.delegatingLoader$lzy$1, this.commonClassLoader$1, this.buildLoader$1).addChangeListener(f);
                }

                public void reload() {
                    this.server$1.reload();
                }

                public void close() {
                    this.server$1.stop();
                    KanelaReloader$.MODULE$.kamon$instrumentation$sbt$play$KanelaReloader$$reloader$1(this.reloader$lzy$1, this.reloadCompile$1, this.projectPath$1, this.devSettings$1, this.monitoredFiles$1, this.fileWatchService$1, this.generatedSourceHandlers$1, this.reloadLock$1, this.kanelaAgentJar$1, this.assetsLoader$lzy$1, this.assetsClassLoader$1, this.applicationLoader$lzy$1, this.dependencyClasspath$1, this.delegatingLoader$lzy$1, this.commonClassLoader$1, this.buildLoader$1).close();
                    Seq qual$1 = RunHook$.MODULE$.RunHooksRunner(this.runHooks$1);
                    Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)x$10 -> {
                        anon.4.$anonfun$close$1(x$10);
                        return BoxedUnit.UNIT;
                    };
                    boolean x$2 = RunHook.RunHooksRunner$.MODULE$.run$default$2$extension(qual$1);
                    RunHook.RunHooksRunner$.MODULE$.run$extension(qual$1, (Function1)x$1, x$2);
                    this.systemPropertiesCombined$1.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String key = (String)tuple2._1();
                        String string = System.clearProperty(key);
                        return string;
                    });
                }

                public static final /* synthetic */ void $anonfun$close$1(RunHook x$10) {
                    x$10.afterStopped();
                }
                {
                    this.server$1 = server$1;
                    this.runHooks$1 = runHooks$1;
                    this.systemPropertiesCombined$1 = systemPropertiesCombined$1;
                    this.reloader$lzy$1 = reloader$lzy$1;
                    this.reloadCompile$1 = reloadCompile$1;
                    this.projectPath$1 = projectPath$1;
                    this.devSettings$1 = devSettings$1;
                    this.monitoredFiles$1 = monitoredFiles$1;
                    this.fileWatchService$1 = fileWatchService$1;
                    this.generatedSourceHandlers$1 = generatedSourceHandlers$1;
                    this.reloadLock$1 = reloadLock$1;
                    this.kanelaAgentJar$1 = kanelaAgentJar$1;
                    this.assetsLoader$lzy$1 = assetsLoader$lzy$1;
                    this.assetsClassLoader$1 = assetsClassLoader$1;
                    this.applicationLoader$lzy$1 = applicationLoader$lzy$1;
                    this.dependencyClasspath$1 = dependencyClasspath$1;
                    this.delegatingLoader$lzy$1 = delegatingLoader$lzy$1;
                    this.commonClassLoader$1 = commonClassLoader$1;
                    this.buildLoader$1 = buildLoader$1;
                    this.buildLink = KanelaReloader$.MODULE$.kamon$instrumentation$sbt$play$KanelaReloader$$reloader$1(reloader$lzy$1, reloadCompile$1, projectPath$1, devSettings$1, monitoredFiles$1, fileWatchService$1, generatedSourceHandlers$1, reloadLock$1, kanelaAgentJar$1, assetsLoader$lzy$1, assetsClassLoader$1, applicationLoader$lzy$1, dependencyClasspath$1, delegatingLoader$lzy$1, commonClassLoader$1, buildLoader$1);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$close$1$adapted(play.runsupport.RunHook ), $anonfun$close$2(scala.Tuple2 )}, serializedLambda);
                }
            };
        }
        catch (Throwable e) {
            runHooks.foreach((Function1 & Serializable & scala.Serializable)hook -> {
                KanelaReloader$.$anonfun$startDevMode$9(hook);
                return BoxedUnit.UNIT;
            });
            String string = this.getRootCause$1(e).getClass().getName();
            String string2 = "play.core.server.ServerListenException";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new ServerStartException(e);
            }
            throw e;
        }
        return devServer;
    }

    public KanelaReloader.DevServer startNoReload(ClassLoader parentClassLoader, Seq<File> dependencyClasspath, File buildProjectPath, Seq<Tuple2<String, String>> devSettings, int httpPort, String mainClassName) {
        LazyRef delegatingLoader$lzy = new LazyRef();
        LazyRef applicationLoader$lzy = new LazyRef();
        ClassLoader buildLoader = this.getClass().getClassLoader();
        BuildLink _buildLink = new BuildLink(buildProjectPath, devSettings, applicationLoader$lzy, dependencyClasspath, delegatingLoader$lzy, parentClassLoader, buildLoader){
            private final AtomicBoolean initialized;
            private final File buildProjectPath$1;
            private final Seq devSettings$2;
            private final LazyRef applicationLoader$lzy$2;
            private final Seq dependencyClasspath$2;
            private final LazyRef delegatingLoader$lzy$2;
            private final ClassLoader parentClassLoader$1;
            private final ClassLoader buildLoader$2;

            private AtomicBoolean initialized() {
                return this.initialized;
            }

            public Object reload() {
                return this.initialized().compareAndSet(false, true) ? KanelaReloader$.MODULE$.kamon$instrumentation$sbt$play$KanelaReloader$$applicationLoader$2(this.applicationLoader$lzy$2, this.dependencyClasspath$2, this.delegatingLoader$lzy$2, this.parentClassLoader$1, this.buildLoader$2) : null;
            }

            public File projectPath() {
                return this.buildProjectPath$1;
            }

            public java.util.Map<String, String> settings() {
                return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.devSettings$2.toMap(Predef$.MODULE$.$conforms())).asJava();
            }

            public void forceReload() {
            }

            public Object[] findSource(String className, Integer line) {
                return null;
            }
            {
                this.buildProjectPath$1 = buildProjectPath$1;
                this.devSettings$2 = devSettings$2;
                this.applicationLoader$lzy$2 = applicationLoader$lzy$2;
                this.dependencyClasspath$2 = dependencyClasspath$2;
                this.delegatingLoader$lzy$2 = delegatingLoader$lzy$2;
                this.parentClassLoader$1 = parentClassLoader$1;
                this.buildLoader$2 = buildLoader$2;
                this.initialized = new AtomicBoolean(false);
            }
        };
        Class mainClass = this.kamon$instrumentation$sbt$play$KanelaReloader$$applicationLoader$2(applicationLoader$lzy, dependencyClasspath, delegatingLoader$lzy, parentClassLoader, buildLoader).loadClass(mainClassName);
        Method mainDev = mainClass.getMethod("mainDevHttpMode", BuildLink.class, Integer.TYPE);
        ReloadableServer server = (ReloadableServer)mainDev.invoke(null, _buildLink, Predef$.MODULE$.int2Integer(httpPort));
        server.reload();
        return new KanelaReloader.DevServer(_buildLink, server){
            private final BuildLink buildLink;
            private final ReloadableServer server$2;

            public BuildLink buildLink() {
                return this.buildLink;
            }

            public void addChangeListener(Function0<BoxedUnit> f) {
            }

            public void reload() {
            }

            public void close() {
                this.server$2.stop();
            }
            {
                this.server$2 = server$2;
                this.buildLink = _buildLink$1;
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$filterArgs$3(char x$4) {
        return x$4 != '=';
    }

    private static final Option prop$1(String key, scala.collection.immutable.Map props$1) {
        return props$1.get((Object)key).orElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.props().get(key));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Option parsePortValue$1(Option portValue, Option defaultValue) {
        boolean bl = false;
        Some some = null;
        Option option = portValue;
        if (None$.MODULE$.equals(option)) {
            return defaultValue;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string = (String)some.value();
            if ("disabled".equals(string)) {
                return None$.MODULE$;
            }
        }
        if (!bl) throw new MatchError((Object)option);
        String s = (String)some.value();
        return new Some((Object)BoxesRunTime.boxToInteger((int)this.parsePort(s)));
    }

    private static final Option parsePortValue$default$2$1() {
        return None$.MODULE$;
    }

    private static final /* synthetic */ PartialFunction commonJars$lzycompute$1(LazyRef commonJars$lzy$1) {
        PartialFunction partialFunction;
        LazyRef lazyRef = commonJars$lzy$1;
        synchronized (lazyRef) {
            partialFunction = commonJars$lzy$1.initialized() ? (PartialFunction)commonJars$lzy$1.value() : (PartialFunction)commonJars$lzy$1.initialize((Object)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends File, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    block3: {
                        A1 A1;
                        block2: {
                            A1 = x1;
                            if (A1.getName().startsWith("h2-")) break block2;
                            String string = A1.getName();
                            String string2 = "h2.jar";
                            if (string != null ? !string.equals(string2) : string2 != null) break block3;
                        }
                        object = A1.toURI().toURL();
                        return (B1)object;
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(File x1) {
                    File file = x1;
                    if (file.getName().startsWith("h2-")) return true;
                    String string = file.getName();
                    String string2 = "h2.jar";
                    if (string != null) {
                        if (!string.equals(string2)) return false;
                        return true;
                    }
                    if (string2 == null) return true;
                    return false;
                }
            });
        }
        return partialFunction;
    }

    public static final PartialFunction kamon$instrumentation$sbt$play$KanelaReloader$$commonJars$1(LazyRef commonJars$lzy$1) {
        return commonJars$lzy$1.initialized() ? (PartialFunction)commonJars$lzy$1.value() : KanelaReloader$.commonJars$lzycompute$1(commonJars$lzy$1);
    }

    public static final /* synthetic */ Seq $anonfun$startDevMode$2(int port) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"play.server.http.port"), (Object)((Object)BoxesRunTime.boxToInteger((int)port)).toString())}));
    }

    public static final /* synthetic */ Seq $anonfun$startDevMode$4(int port) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"play.server.https.port"), (Object)((Object)BoxesRunTime.boxToInteger((int)port)).toString())}));
    }

    private static final /* synthetic */ ClassLoader delegatingLoader$lzycompute$1(LazyRef delegatingLoader$lzy$1, ClassLoader commonClassLoader$1, ClassLoader buildLoader$1, LazyRef reloader$lzy$1, Function0 reloadCompile$1, File projectPath$1, Seq devSettings$1, Seq monitoredFiles$1, FileWatchService fileWatchService$1, scala.collection.immutable.Map generatedSourceHandlers$1, Object reloadLock$1, File kanelaAgentJar$1, LazyRef assetsLoader$lzy$1, Function1 assetsClassLoader$1, LazyRef applicationLoader$lzy$1, Seq dependencyClasspath$1) {
        ClassLoader classLoader;
        LazyRef lazyRef = delegatingLoader$lzy$1;
        synchronized (lazyRef) {
            classLoader = delegatingLoader$lzy$1.initialized() ? (ClassLoader)delegatingLoader$lzy$1.value() : (ClassLoader)delegatingLoader$lzy$1.initialize((Object)new DelegatingClassLoader(commonClassLoader$1, Build.sharedClasses, buildLoader$1, new ApplicationClassLoaderProvider(reloader$lzy$1, reloadCompile$1, projectPath$1, devSettings$1, monitoredFiles$1, fileWatchService$1, generatedSourceHandlers$1, reloadLock$1, kanelaAgentJar$1, assetsLoader$lzy$1, assetsClassLoader$1, applicationLoader$lzy$1, dependencyClasspath$1, delegatingLoader$lzy$1, commonClassLoader$1, buildLoader$1){
                private final LazyRef reloader$lzy$1;
                private final Function0 reloadCompile$1;
                private final File projectPath$1;
                private final Seq devSettings$1;
                private final Seq monitoredFiles$1;
                private final FileWatchService fileWatchService$1;
                private final scala.collection.immutable.Map generatedSourceHandlers$1;
                private final Object reloadLock$1;
                private final File kanelaAgentJar$1;
                private final LazyRef assetsLoader$lzy$1;
                private final Function1 assetsClassLoader$1;
                private final LazyRef applicationLoader$lzy$1;
                private final Seq dependencyClasspath$1;
                private final LazyRef delegatingLoader$lzy$1;
                private final ClassLoader commonClassLoader$1;
                private final ClassLoader buildLoader$1;

                public URLClassLoader get() {
                    return (URLClassLoader)KanelaReloader$.MODULE$.kamon$instrumentation$sbt$play$KanelaReloader$$reloader$1(this.reloader$lzy$1, this.reloadCompile$1, this.projectPath$1, this.devSettings$1, this.monitoredFiles$1, this.fileWatchService$1, this.generatedSourceHandlers$1, this.reloadLock$1, this.kanelaAgentJar$1, this.assetsLoader$lzy$1, this.assetsClassLoader$1, this.applicationLoader$lzy$1, this.dependencyClasspath$1, this.delegatingLoader$lzy$1, this.commonClassLoader$1, this.buildLoader$1).getClassLoader().orNull(Predef$.MODULE$.$conforms());
                }
                {
                    this.reloader$lzy$1 = reloader$lzy$1;
                    this.reloadCompile$1 = reloadCompile$1;
                    this.projectPath$1 = projectPath$1;
                    this.devSettings$1 = devSettings$1;
                    this.monitoredFiles$1 = monitoredFiles$1;
                    this.fileWatchService$1 = fileWatchService$1;
                    this.generatedSourceHandlers$1 = generatedSourceHandlers$1;
                    this.reloadLock$1 = reloadLock$1;
                    this.kanelaAgentJar$1 = kanelaAgentJar$1;
                    this.assetsLoader$lzy$1 = assetsLoader$lzy$1;
                    this.assetsClassLoader$1 = assetsClassLoader$1;
                    this.applicationLoader$lzy$1 = applicationLoader$lzy$1;
                    this.dependencyClasspath$1 = dependencyClasspath$1;
                    this.delegatingLoader$lzy$1 = delegatingLoader$lzy$1;
                    this.commonClassLoader$1 = commonClassLoader$1;
                    this.buildLoader$1 = buildLoader$1;
                }
            }));
        }
        return classLoader;
    }

    private static final ClassLoader delegatingLoader$1(LazyRef delegatingLoader$lzy$1, ClassLoader commonClassLoader$1, ClassLoader buildLoader$1, LazyRef reloader$lzy$1, Function0 reloadCompile$1, File projectPath$1, Seq devSettings$1, Seq monitoredFiles$1, FileWatchService fileWatchService$1, scala.collection.immutable.Map generatedSourceHandlers$1, Object reloadLock$1, File kanelaAgentJar$1, LazyRef assetsLoader$lzy$1, Function1 assetsClassLoader$1, LazyRef applicationLoader$lzy$1, Seq dependencyClasspath$1) {
        return delegatingLoader$lzy$1.initialized() ? (ClassLoader)delegatingLoader$lzy$1.value() : KanelaReloader$.delegatingLoader$lzycompute$1(delegatingLoader$lzy$1, commonClassLoader$1, buildLoader$1, reloader$lzy$1, reloadCompile$1, projectPath$1, devSettings$1, monitoredFiles$1, fileWatchService$1, generatedSourceHandlers$1, reloadLock$1, kanelaAgentJar$1, assetsLoader$lzy$1, assetsClassLoader$1, applicationLoader$lzy$1, dependencyClasspath$1);
    }

    private final /* synthetic */ SbtKanelaRunnerPlay.SbtKanelaClassLoader applicationLoader$lzycompute$1(LazyRef applicationLoader$lzy$1, Seq dependencyClasspath$1, LazyRef delegatingLoader$lzy$1, ClassLoader commonClassLoader$1, ClassLoader buildLoader$1, LazyRef reloader$lzy$1, Function0 reloadCompile$1, File projectPath$1, Seq devSettings$1, Seq monitoredFiles$1, FileWatchService fileWatchService$1, scala.collection.immutable.Map generatedSourceHandlers$1, Object reloadLock$1, File kanelaAgentJar$1, LazyRef assetsLoader$lzy$1, Function1 assetsClassLoader$1) {
        SbtKanelaRunnerPlay.SbtKanelaClassLoader sbtKanelaClassLoader;
        LazyRef lazyRef = applicationLoader$lzy$1;
        synchronized (lazyRef) {
            sbtKanelaClassLoader = applicationLoader$lzy$1.initialized() ? (SbtKanelaRunnerPlay.SbtKanelaClassLoader)((Object)applicationLoader$lzy$1.value()) : (SbtKanelaRunnerPlay.SbtKanelaClassLoader)((Object)applicationLoader$lzy$1.initialize((Object)new SbtKanelaRunnerPlay.SbtKanelaClassLoader("DependencyClassLoader", this.urls((Seq<File>)dependencyClasspath$1), KanelaReloader$.delegatingLoader$1(delegatingLoader$lzy$1, commonClassLoader$1, buildLoader$1, reloader$lzy$1, reloadCompile$1, projectPath$1, devSettings$1, monitoredFiles$1, fileWatchService$1, generatedSourceHandlers$1, reloadLock$1, kanelaAgentJar$1, assetsLoader$lzy$1, assetsClassLoader$1, applicationLoader$lzy$1, dependencyClasspath$1), true, SbtKanelaRunnerPlay$SbtKanelaClassLoader$.MODULE$.$lessinit$greater$default$5())));
        }
        return sbtKanelaClassLoader;
    }

    private final SbtKanelaRunnerPlay.SbtKanelaClassLoader applicationLoader$1(LazyRef applicationLoader$lzy$1, Seq dependencyClasspath$1, LazyRef delegatingLoader$lzy$1, ClassLoader commonClassLoader$1, ClassLoader buildLoader$1, LazyRef reloader$lzy$1, Function0 reloadCompile$1, File projectPath$1, Seq devSettings$1, Seq monitoredFiles$1, FileWatchService fileWatchService$1, scala.collection.immutable.Map generatedSourceHandlers$1, Object reloadLock$1, File kanelaAgentJar$1, LazyRef assetsLoader$lzy$1, Function1 assetsClassLoader$1) {
        return applicationLoader$lzy$1.initialized() ? (SbtKanelaRunnerPlay.SbtKanelaClassLoader)((Object)applicationLoader$lzy$1.value()) : this.applicationLoader$lzycompute$1(applicationLoader$lzy$1, dependencyClasspath$1, delegatingLoader$lzy$1, commonClassLoader$1, buildLoader$1, reloader$lzy$1, reloadCompile$1, projectPath$1, devSettings$1, monitoredFiles$1, fileWatchService$1, generatedSourceHandlers$1, reloadLock$1, kanelaAgentJar$1, assetsLoader$lzy$1, assetsClassLoader$1);
    }

    private final /* synthetic */ ClassLoader assetsLoader$lzycompute$1(LazyRef assetsLoader$lzy$1, Function1 assetsClassLoader$1, LazyRef applicationLoader$lzy$1, Seq dependencyClasspath$1, LazyRef delegatingLoader$lzy$1, ClassLoader commonClassLoader$1, ClassLoader buildLoader$1, LazyRef reloader$lzy$1, Function0 reloadCompile$1, File projectPath$1, Seq devSettings$1, Seq monitoredFiles$1, FileWatchService fileWatchService$1, scala.collection.immutable.Map generatedSourceHandlers$1, Object reloadLock$1, File kanelaAgentJar$1) {
        ClassLoader classLoader;
        LazyRef lazyRef = assetsLoader$lzy$1;
        synchronized (lazyRef) {
            classLoader = assetsLoader$lzy$1.initialized() ? (ClassLoader)assetsLoader$lzy$1.value() : (ClassLoader)assetsLoader$lzy$1.initialize(assetsClassLoader$1.apply((Object)this.applicationLoader$1(applicationLoader$lzy$1, dependencyClasspath$1, delegatingLoader$lzy$1, commonClassLoader$1, buildLoader$1, reloader$lzy$1, reloadCompile$1, projectPath$1, devSettings$1, monitoredFiles$1, fileWatchService$1, generatedSourceHandlers$1, reloadLock$1, kanelaAgentJar$1, assetsLoader$lzy$1, assetsClassLoader$1)));
        }
        return classLoader;
    }

    private final ClassLoader assetsLoader$1(LazyRef assetsLoader$lzy$1, Function1 assetsClassLoader$1, LazyRef applicationLoader$lzy$1, Seq dependencyClasspath$1, LazyRef delegatingLoader$lzy$1, ClassLoader commonClassLoader$1, ClassLoader buildLoader$1, LazyRef reloader$lzy$1, Function0 reloadCompile$1, File projectPath$1, Seq devSettings$1, Seq monitoredFiles$1, FileWatchService fileWatchService$1, scala.collection.immutable.Map generatedSourceHandlers$1, Object reloadLock$1, File kanelaAgentJar$1) {
        return assetsLoader$lzy$1.initialized() ? (ClassLoader)assetsLoader$lzy$1.value() : this.assetsLoader$lzycompute$1(assetsLoader$lzy$1, assetsClassLoader$1, applicationLoader$lzy$1, dependencyClasspath$1, delegatingLoader$lzy$1, commonClassLoader$1, buildLoader$1, reloader$lzy$1, reloadCompile$1, projectPath$1, devSettings$1, monitoredFiles$1, fileWatchService$1, generatedSourceHandlers$1, reloadLock$1, kanelaAgentJar$1);
    }

    private final /* synthetic */ KanelaReloader reloader$lzycompute$1(LazyRef reloader$lzy$1, Function0 reloadCompile$1, File projectPath$1, Seq devSettings$1, Seq monitoredFiles$1, FileWatchService fileWatchService$1, scala.collection.immutable.Map generatedSourceHandlers$1, Object reloadLock$1, File kanelaAgentJar$1, LazyRef assetsLoader$lzy$1, Function1 assetsClassLoader$1, LazyRef applicationLoader$lzy$1, Seq dependencyClasspath$1, LazyRef delegatingLoader$lzy$1, ClassLoader commonClassLoader$1, ClassLoader buildLoader$1) {
        KanelaReloader kanelaReloader;
        LazyRef lazyRef = reloader$lzy$1;
        synchronized (lazyRef) {
            kanelaReloader = reloader$lzy$1.initialized() ? (KanelaReloader)reloader$lzy$1.value() : (KanelaReloader)reloader$lzy$1.initialize((Object)new KanelaReloader((Function0<Reloader.CompileResult>)reloadCompile$1, this.assetsLoader$1(assetsLoader$lzy$1, assetsClassLoader$1, applicationLoader$lzy$1, dependencyClasspath$1, delegatingLoader$lzy$1, commonClassLoader$1, buildLoader$1, reloader$lzy$1, reloadCompile$1, projectPath$1, devSettings$1, monitoredFiles$1, fileWatchService$1, generatedSourceHandlers$1, reloadLock$1, kanelaAgentJar$1), projectPath$1, (Seq<Tuple2<String, String>>)devSettings$1, (Seq<File>)monitoredFiles$1, fileWatchService$1, (scala.collection.immutable.Map<String, Reloader.GeneratedSourceMapping>)generatedSourceHandlers$1, reloadLock$1, kanelaAgentJar$1));
        }
        return kanelaReloader;
    }

    public final KanelaReloader kamon$instrumentation$sbt$play$KanelaReloader$$reloader$1(LazyRef reloader$lzy$1, Function0 reloadCompile$1, File projectPath$1, Seq devSettings$1, Seq monitoredFiles$1, FileWatchService fileWatchService$1, scala.collection.immutable.Map generatedSourceHandlers$1, Object reloadLock$1, File kanelaAgentJar$1, LazyRef assetsLoader$lzy$1, Function1 assetsClassLoader$1, LazyRef applicationLoader$lzy$1, Seq dependencyClasspath$1, LazyRef delegatingLoader$lzy$1, ClassLoader commonClassLoader$1, ClassLoader buildLoader$1) {
        return reloader$lzy$1.initialized() ? (KanelaReloader)reloader$lzy$1.value() : this.reloader$lzycompute$1(reloader$lzy$1, reloadCompile$1, projectPath$1, devSettings$1, monitoredFiles$1, fileWatchService$1, generatedSourceHandlers$1, reloadLock$1, kanelaAgentJar$1, assetsLoader$lzy$1, assetsClassLoader$1, applicationLoader$lzy$1, dependencyClasspath$1, delegatingLoader$lzy$1, commonClassLoader$1, buildLoader$1);
    }

    public static final /* synthetic */ void $anonfun$startDevMode$9(RunHook hook) {
        try {
            hook.onError();
        }
        catch (Throwable throwable) {}
    }

    private final Throwable getRootCause$1(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    private static final /* synthetic */ ClassLoader delegatingLoader$lzycompute$2(LazyRef delegatingLoader$lzy$2, ClassLoader parentClassLoader$1, ClassLoader buildLoader$2, LazyRef applicationLoader$lzy$2, Seq dependencyClasspath$2) {
        ClassLoader classLoader;
        LazyRef lazyRef = delegatingLoader$lzy$2;
        synchronized (lazyRef) {
            classLoader = delegatingLoader$lzy$2.initialized() ? (ClassLoader)delegatingLoader$lzy$2.value() : (ClassLoader)delegatingLoader$lzy$2.initialize((Object)new DelegatingClassLoader(parentClassLoader$1, Build.sharedClasses, buildLoader$2, new ApplicationClassLoaderProvider(applicationLoader$lzy$2, dependencyClasspath$2, delegatingLoader$lzy$2, parentClassLoader$1, buildLoader$2){
                private final LazyRef applicationLoader$lzy$2;
                private final Seq dependencyClasspath$2;
                private final LazyRef delegatingLoader$lzy$2;
                private final ClassLoader parentClassLoader$1;
                private final ClassLoader buildLoader$2;

                public URLClassLoader get() {
                    return KanelaReloader$.MODULE$.kamon$instrumentation$sbt$play$KanelaReloader$$applicationLoader$2(this.applicationLoader$lzy$2, this.dependencyClasspath$2, this.delegatingLoader$lzy$2, this.parentClassLoader$1, this.buildLoader$2);
                }
                {
                    this.applicationLoader$lzy$2 = applicationLoader$lzy$2;
                    this.dependencyClasspath$2 = dependencyClasspath$2;
                    this.delegatingLoader$lzy$2 = delegatingLoader$lzy$2;
                    this.parentClassLoader$1 = parentClassLoader$1;
                    this.buildLoader$2 = buildLoader$2;
                }
            }));
        }
        return classLoader;
    }

    private static final ClassLoader delegatingLoader$2(LazyRef delegatingLoader$lzy$2, ClassLoader parentClassLoader$1, ClassLoader buildLoader$2, LazyRef applicationLoader$lzy$2, Seq dependencyClasspath$2) {
        return delegatingLoader$lzy$2.initialized() ? (ClassLoader)delegatingLoader$lzy$2.value() : KanelaReloader$.delegatingLoader$lzycompute$2(delegatingLoader$lzy$2, parentClassLoader$1, buildLoader$2, applicationLoader$lzy$2, dependencyClasspath$2);
    }

    private final /* synthetic */ NamedURLClassLoader applicationLoader$lzycompute$2(LazyRef applicationLoader$lzy$2, Seq dependencyClasspath$2, LazyRef delegatingLoader$lzy$2, ClassLoader parentClassLoader$1, ClassLoader buildLoader$2) {
        NamedURLClassLoader namedURLClassLoader;
        LazyRef lazyRef = applicationLoader$lzy$2;
        synchronized (lazyRef) {
            namedURLClassLoader = applicationLoader$lzy$2.initialized() ? (NamedURLClassLoader)applicationLoader$lzy$2.value() : (NamedURLClassLoader)applicationLoader$lzy$2.initialize((Object)new NamedURLClassLoader("DependencyClassLoader", this.urls((Seq<File>)dependencyClasspath$2), KanelaReloader$.delegatingLoader$2(delegatingLoader$lzy$2, parentClassLoader$1, buildLoader$2, applicationLoader$lzy$2, dependencyClasspath$2)));
        }
        return namedURLClassLoader;
    }

    public final NamedURLClassLoader kamon$instrumentation$sbt$play$KanelaReloader$$applicationLoader$2(LazyRef applicationLoader$lzy$2, Seq dependencyClasspath$2, LazyRef delegatingLoader$lzy$2, ClassLoader parentClassLoader$1, ClassLoader buildLoader$2) {
        return applicationLoader$lzy$2.initialized() ? (NamedURLClassLoader)applicationLoader$lzy$2.value() : this.applicationLoader$lzycompute$2(applicationLoader$lzy$2, dependencyClasspath$2, delegatingLoader$lzy$2, parentClassLoader$1, buildLoader$2);
    }

    private KanelaReloader$() {
        MODULE$ = this;
        this.SystemProperty = new StringOps(Predef$.MODULE$.augmentString("-D([^=]+)=(.*)")).r();
        this.accessControlContext = AccessController.getContext();
    }
}

