/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.dispatcher;

import io.katharsis.core.internal.dispatcher.controller.BaseController;
import io.katharsis.core.internal.dispatcher.path.JsonPath;
import io.katharsis.core.internal.dispatcher.path.PathBuilder;
import io.katharsis.errorhandling.exception.MethodNotFoundException;
import java.util.LinkedList;
import java.util.List;

public class ControllerRegistry {
    private final List<BaseController> controllers = new LinkedList<BaseController>();

    public ControllerRegistry(List<BaseController> baseControllers) {
        if (baseControllers != null) {
            this.controllers.addAll(baseControllers);
        }
    }

    public void addController(BaseController controller) {
        this.controllers.add(controller);
    }

    public BaseController getController(JsonPath jsonPath, String requestType) {
        for (BaseController controller : this.controllers) {
            if (!controller.isAcceptable(jsonPath, requestType)) continue;
            return controller;
        }
        throw new MethodNotFoundException(PathBuilder.buildPath(jsonPath), requestType);
    }
}

