/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.dispatcher.controller;

import io.katharsis.core.internal.dispatcher.path.JsonPath;
import io.katharsis.errorhandling.exception.RequestBodyException;
import io.katharsis.legacy.internal.RepositoryMethodParameterProvider;
import io.katharsis.repository.request.HttpMethod;
import io.katharsis.repository.request.QueryAdapter;
import io.katharsis.repository.response.JsonApiResponse;
import io.katharsis.repository.response.Response;
import io.katharsis.resource.Document;
import io.katharsis.resource.registry.RegistryEntry;

public abstract class BaseController {
    public abstract boolean isAcceptable(JsonPath var1, String var2);

    public abstract Response handle(JsonPath var1, QueryAdapter var2, RepositoryMethodParameterProvider var3, Document var4);

    protected void verifyTypes(HttpMethod methodType, String resourceEndpointName, RegistryEntry endpointRegistryEntry, RegistryEntry bodyRegistryEntry) {
        if (endpointRegistryEntry.equals(bodyRegistryEntry)) {
            return;
        }
        if (bodyRegistryEntry == null || !bodyRegistryEntry.isParent(endpointRegistryEntry)) {
            String message = String.format("Inconsistent type definition between path and body: body type: %s, request type: %s", new Object[]{methodType, resourceEndpointName});
            throw new RequestBodyException(methodType, resourceEndpointName, message);
        }
    }

    protected Object extractResource(Object responseOrResource) {
        if (responseOrResource instanceof JsonApiResponse) {
            return ((JsonApiResponse)responseOrResource).getEntity();
        }
        return responseOrResource;
    }
}

