/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.query;

import io.katharsis.core.internal.utils.StringUtils;
import io.katharsis.legacy.queryParams.include.Inclusion;
import io.katharsis.legacy.queryParams.params.IncludedFieldsParams;
import io.katharsis.legacy.queryParams.params.IncludedRelationsParams;
import io.katharsis.legacy.queryParams.params.TypedParams;
import io.katharsis.queryspec.IncludeFieldSpec;
import io.katharsis.queryspec.IncludeRelationSpec;
import io.katharsis.queryspec.QuerySpec;
import io.katharsis.repository.request.QueryAdapter;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class QuerySpecAdapter
implements QueryAdapter {
    private QuerySpec querySpec;
    private ResourceRegistry resourceRegistry;

    public QuerySpecAdapter(QuerySpec querySpec, ResourceRegistry resourceRegistry) {
        this.querySpec = querySpec;
        this.resourceRegistry = resourceRegistry;
    }

    public QuerySpec getQuerySpec() {
        return this.querySpec;
    }

    @Override
    public boolean hasIncludedRelations() {
        if (!this.querySpec.getIncludedRelations().isEmpty()) {
            return true;
        }
        for (QuerySpec relatedSpec : this.querySpec.getRelatedSpecs().values()) {
            if (relatedSpec.getIncludedRelations().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public TypedParams<IncludedRelationsParams> getIncludedRelations() {
        HashMap<String, IncludedRelationsParams> params = new HashMap<String, IncludedRelationsParams>();
        this.addRelations(params, this.querySpec);
        for (QuerySpec relatedSpec : this.querySpec.getRelatedSpecs().values()) {
            this.addRelations(params, relatedSpec);
        }
        return new TypedParams<IncludedRelationsParams>(params);
    }

    private void addRelations(Map<String, IncludedRelationsParams> params, QuerySpec spec) {
        if (!spec.getIncludedRelations().isEmpty()) {
            HashSet<Inclusion> set = new HashSet<Inclusion>();
            for (IncludeRelationSpec relation : spec.getIncludedRelations()) {
                set.add(new Inclusion(StringUtils.join(".", relation.getAttributePath())));
            }
            params.put(this.getResourceTypee(spec), new IncludedRelationsParams(set));
        }
    }

    private String getResourceTypee(QuerySpec spec) {
        RegistryEntry entry = this.resourceRegistry.findEntry(spec.getResourceClass());
        ResourceInformation resourceInformation = entry.getResourceInformation();
        return resourceInformation.getResourceType();
    }

    @Override
    public TypedParams<IncludedFieldsParams> getIncludedFields() {
        HashMap<String, IncludedFieldsParams> params = new HashMap<String, IncludedFieldsParams>();
        this.addFields(params, this.querySpec);
        for (QuerySpec relatedSpec : this.querySpec.getRelatedSpecs().values()) {
            this.addFields(params, relatedSpec);
        }
        return new TypedParams<IncludedFieldsParams>(params);
    }

    private void addFields(Map<String, IncludedFieldsParams> params, QuerySpec spec) {
        if (!spec.getIncludedFields().isEmpty()) {
            HashSet<String> set = new HashSet<String>();
            for (IncludeFieldSpec relation : spec.getIncludedFields()) {
                set.add(StringUtils.join(".", relation.getAttributePath()));
            }
            params.put(this.getResourceTypee(spec), new IncludedFieldsParams(set));
        }
    }

    @Override
    public ResourceInformation getResourceInformation() {
        return this.resourceRegistry.findEntry(this.querySpec.getResourceClass()).getResourceInformation();
    }

    @Override
    public Long getLimit() {
        return this.querySpec.getLimit();
    }

    @Override
    public long getOffset() {
        return this.querySpec.getOffset();
    }

    @Override
    public QueryAdapter duplicate() {
        return new QuerySpecAdapter(this.querySpec.duplicate(), this.resourceRegistry);
    }

    @Override
    public void setLimit(Long limit) {
        this.querySpec.setLimit(limit);
    }

    @Override
    public void setOffset(long offset) {
        this.querySpec.setOffset(offset);
    }
}

