/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.repository.adapter;

import io.katharsis.core.internal.repository.adapter.RepositoryRequestSpecImpl;
import io.katharsis.core.internal.repository.adapter.ResponseRepositoryAdapter;
import io.katharsis.core.internal.utils.MultivaluedMap;
import io.katharsis.legacy.internal.AnnotatedRelationshipRepositoryAdapter;
import io.katharsis.legacy.repository.RelationshipRepository;
import io.katharsis.module.ModuleRegistry;
import io.katharsis.queryspec.QuerySpec;
import io.katharsis.repository.BulkRelationshipRepositoryV2;
import io.katharsis.repository.RelationshipRepositoryV2;
import io.katharsis.repository.filter.RepositoryFilterContext;
import io.katharsis.repository.request.HttpMethod;
import io.katharsis.repository.request.QueryAdapter;
import io.katharsis.repository.request.RepositoryRequestSpec;
import io.katharsis.repository.response.JsonApiResponse;
import io.katharsis.resource.information.ResourceField;
import io.katharsis.resource.information.ResourceInformation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelationshipRepositoryAdapter<T, I extends Serializable, D, J extends Serializable>
extends ResponseRepositoryAdapter {
    private final Object relationshipRepository;
    private final boolean isAnnotated;

    public RelationshipRepositoryAdapter(ResourceInformation resourceInformation, ModuleRegistry moduleRegistry, Object relationshipRepository) {
        super(resourceInformation, moduleRegistry);
        this.relationshipRepository = relationshipRepository;
        this.isAnnotated = relationshipRepository instanceof AnnotatedRelationshipRepositoryAdapter;
    }

    public JsonApiResponse setRelation(T source, J targetId, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Serializable targetId = request.getId();
                ResourceField field = request.getRelationshipField();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (RelationshipRepositoryAdapter.this.isAnnotated) {
                    ((AnnotatedRelationshipRepositoryAdapter)RelationshipRepositoryAdapter.this.relationshipRepository).setRelation(source, targetId, field.getUnderlyingName(), queryAdapter);
                } else if (RelationshipRepositoryAdapter.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    ((RelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository).setRelation(source, targetId, field.getUnderlyingName());
                } else {
                    ((RelationshipRepository)RelationshipRepositoryAdapter.this.relationshipRepository).setRelation(source, targetId, field.getUnderlyingName());
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.PATCH, source, queryAdapter, Arrays.asList(targetId), field);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse setRelations(T source, Iterable<J> targetIds, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Iterable targetIds = request.getIds();
                ResourceField field = request.getRelationshipField();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (RelationshipRepositoryAdapter.this.isAnnotated) {
                    ((AnnotatedRelationshipRepositoryAdapter)RelationshipRepositoryAdapter.this.relationshipRepository).setRelations(source, targetIds, field.getUnderlyingName(), queryAdapter);
                } else if (RelationshipRepositoryAdapter.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    ((RelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository).setRelations(source, targetIds, field.getUnderlyingName());
                } else {
                    ((RelationshipRepository)RelationshipRepositoryAdapter.this.relationshipRepository).setRelations(source, targetIds, field.getUnderlyingName());
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.PATCH, source, queryAdapter, targetIds, field);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse addRelations(T source, Iterable<J> targetIds, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Iterable targetIds = request.getIds();
                ResourceField field = request.getRelationshipField();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (RelationshipRepositoryAdapter.this.isAnnotated) {
                    ((AnnotatedRelationshipRepositoryAdapter)RelationshipRepositoryAdapter.this.relationshipRepository).addRelations(source, targetIds, field.getUnderlyingName(), queryAdapter);
                } else if (RelationshipRepositoryAdapter.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    ((RelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository).addRelations(source, targetIds, field.getUnderlyingName());
                } else {
                    ((RelationshipRepository)RelationshipRepositoryAdapter.this.relationshipRepository).addRelations(source, targetIds, field.getUnderlyingName());
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.POST, source, queryAdapter, targetIds, field);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse removeRelations(T source, Iterable<J> targetIds, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Iterable targetIds = request.getIds();
                ResourceField field = request.getRelationshipField();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (RelationshipRepositoryAdapter.this.isAnnotated) {
                    ((AnnotatedRelationshipRepositoryAdapter)RelationshipRepositoryAdapter.this.relationshipRepository).removeRelations(source, targetIds, field.getUnderlyingName(), queryAdapter);
                } else if (RelationshipRepositoryAdapter.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    ((RelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository).removeRelations(source, targetIds, field.getUnderlyingName());
                } else {
                    ((RelationshipRepository)RelationshipRepositoryAdapter.this.relationshipRepository).removeRelations(source, targetIds, field.getUnderlyingName());
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.DELETE, source, queryAdapter, targetIds, field);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse findOneTarget(I sourceId, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                Object resource;
                RepositoryRequestSpec request = context.getRequest();
                Serializable sourceId = request.getId();
                ResourceField field = request.getRelationshipField();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (RelationshipRepositoryAdapter.this.isAnnotated) {
                    resource = ((AnnotatedRelationshipRepositoryAdapter)RelationshipRepositoryAdapter.this.relationshipRepository).findOneTarget(sourceId, field.getUnderlyingName(), queryAdapter);
                } else if (RelationshipRepositoryAdapter.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    RelationshipRepositoryV2 querySpecRepository = (RelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository;
                    Class targetResourceClass = querySpecRepository.getTargetResourceClass();
                    ResourceInformation targetResourceInformation = RelationshipRepositoryAdapter.this.moduleRegistry.getResourceRegistry().findEntry(targetResourceClass).getResourceInformation();
                    resource = querySpecRepository.findOneTarget(sourceId, field.getUnderlyingName(), request.getQuerySpec(targetResourceInformation));
                } else {
                    resource = ((RelationshipRepository)RelationshipRepositoryAdapter.this.relationshipRepository).findOneTarget(sourceId, field.getUnderlyingName(), request.getQueryParams());
                }
                return RelationshipRepositoryAdapter.this.getResponse(RelationshipRepositoryAdapter.this.relationshipRepository, resource, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, Arrays.asList(sourceId), field);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse findManyTargets(I sourceId, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                Iterable resources;
                RepositoryRequestSpec request = context.getRequest();
                Serializable sourceId = request.getId();
                ResourceField field = request.getRelationshipField();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (RelationshipRepositoryAdapter.this.isAnnotated) {
                    resources = ((AnnotatedRelationshipRepositoryAdapter)RelationshipRepositoryAdapter.this.relationshipRepository).findManyTargets(sourceId, field.getUnderlyingName(), queryAdapter);
                } else if (RelationshipRepositoryAdapter.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    RelationshipRepositoryV2 querySpecRepository = (RelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository;
                    Class targetResourceClass = querySpecRepository.getTargetResourceClass();
                    ResourceInformation targetResourceInformation = RelationshipRepositoryAdapter.this.moduleRegistry.getResourceRegistry().findEntry(targetResourceClass).getResourceInformation();
                    resources = querySpecRepository.findManyTargets(sourceId, field.getUnderlyingName(), request.getQuerySpec(targetResourceInformation));
                } else {
                    resources = ((RelationshipRepository)RelationshipRepositoryAdapter.this.relationshipRepository).findManyTargets(sourceId, field.getUnderlyingName(), request.getQueryParams());
                }
                return RelationshipRepositoryAdapter.this.getResponse(RelationshipRepositoryAdapter.this.relationshipRepository, resources, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, Arrays.asList(sourceId), field);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public Map<I, JsonApiResponse> findBulkManyTargets(List<I> sourceIds, ResourceField field, QueryAdapter queryAdapter) {
        if (this.relationshipRepository instanceof BulkRelationshipRepositoryV2) {
            ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl<I>(){

                @Override
                protected Map<I, JsonApiResponse> invoke(RepositoryFilterContext context) {
                    RepositoryRequestSpec request = context.getRequest();
                    Iterable sourceIds = request.getIds();
                    ResourceField field = request.getRelationshipField();
                    QueryAdapter queryAdapter = request.getQueryAdapter();
                    BulkRelationshipRepositoryV2 bulkRepository = (BulkRelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository;
                    Class targetResourceClass = bulkRepository.getTargetResourceClass();
                    ResourceInformation targetResourceInformation = RelationshipRepositoryAdapter.this.moduleRegistry.getResourceRegistry().findEntry(targetResourceClass).getResourceInformation();
                    QuerySpec querySpec = request.getQuerySpec(targetResourceInformation);
                    MultivaluedMap targetsMap = bulkRepository.findTargets(sourceIds, field.getUnderlyingName(), querySpec);
                    return RelationshipRepositoryAdapter.this.toResponses(targetsMap, true, queryAdapter, field, HttpMethod.GET);
                }
            };
            RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, sourceIds, field);
            return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
        }
        HashMap<Serializable, JsonApiResponse> responseMap = new HashMap<Serializable, JsonApiResponse>();
        for (Serializable sourceId : sourceIds) {
            JsonApiResponse response = this.findManyTargets(sourceId, field, queryAdapter);
            responseMap.put(sourceId, response);
        }
        return responseMap;
    }

    public Map<I, JsonApiResponse> findBulkOneTargets(List<I> sourceIds, ResourceField field, QueryAdapter queryAdapter) {
        if (this.relationshipRepository instanceof BulkRelationshipRepositoryV2) {
            ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl<I>(){

                @Override
                protected Map<I, JsonApiResponse> invoke(RepositoryFilterContext context) {
                    RepositoryRequestSpec request = context.getRequest();
                    Iterable sourceIds = request.getIds();
                    ResourceField field = request.getRelationshipField();
                    QueryAdapter queryAdapter = request.getQueryAdapter();
                    BulkRelationshipRepositoryV2 bulkRepository = (BulkRelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository;
                    Class targetResourceClass = bulkRepository.getTargetResourceClass();
                    ResourceInformation targetResourceInformation = RelationshipRepositoryAdapter.this.moduleRegistry.getResourceRegistry().findEntry(targetResourceClass).getResourceInformation();
                    MultivaluedMap targetsMap = bulkRepository.findTargets(sourceIds, field.getUnderlyingName(), request.getQuerySpec(targetResourceInformation));
                    return RelationshipRepositoryAdapter.this.toResponses(targetsMap, false, queryAdapter, field, HttpMethod.GET);
                }
            };
            RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, sourceIds, field);
            return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
        }
        HashMap<Serializable, JsonApiResponse> responseMap = new HashMap<Serializable, JsonApiResponse>();
        for (Serializable sourceId : sourceIds) {
            JsonApiResponse response = this.findOneTarget(sourceId, field, queryAdapter);
            responseMap.put(sourceId, response);
        }
        return responseMap;
    }

    private Map<I, JsonApiResponse> toResponses(MultivaluedMap<I, D> targetsMap, boolean isMany, QueryAdapter queryAdapter, ResourceField field, HttpMethod method) {
        HashMap<Serializable, JsonApiResponse> responseMap = new HashMap<Serializable, JsonApiResponse>();
        for (Serializable sourceId : targetsMap.keySet()) {
            List<D> targets = isMany ? targetsMap.getList(sourceId) : targetsMap.getUnique(sourceId);
            RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, method, null, queryAdapter, Collections.singleton(sourceId), field);
            JsonApiResponse response = this.getResponse(this.relationshipRepository, targets, requestSpec);
            responseMap.put(sourceId, response);
        }
        return responseMap;
    }

    public Object getRelationshipRepository() {
        return this.relationshipRepository;
    }

    @Override
    protected ResourceInformation getResourceInformation(Object repository) {
        Class clazz = ((RelationshipRepositoryV2)repository).getTargetResourceClass();
        return this.moduleRegistry.getResourceRegistry().findEntry(clazz).getResourceInformation();
    }
}

