/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.repository.adapter;

import io.katharsis.core.internal.query.QuerySpecAdapter;
import io.katharsis.core.internal.utils.JsonApiUrlBuilder;
import io.katharsis.core.internal.utils.PreconditionUtil;
import io.katharsis.legacy.internal.AnnotatedRepositoryAdapter;
import io.katharsis.legacy.repository.LinksRepository;
import io.katharsis.legacy.repository.MetaRepository;
import io.katharsis.module.ModuleRegistry;
import io.katharsis.repository.LinksRepositoryV2;
import io.katharsis.repository.MetaRepositoryV2;
import io.katharsis.repository.filter.RepositoryBulkRequestFilterChain;
import io.katharsis.repository.filter.RepositoryFilter;
import io.katharsis.repository.filter.RepositoryFilterContext;
import io.katharsis.repository.filter.RepositoryLinksFilterChain;
import io.katharsis.repository.filter.RepositoryMetaFilterChain;
import io.katharsis.repository.filter.RepositoryRequestFilterChain;
import io.katharsis.repository.filter.RepositoryResultFilterChain;
import io.katharsis.repository.request.QueryAdapter;
import io.katharsis.repository.request.RepositoryRequestSpec;
import io.katharsis.repository.response.JsonApiResponse;
import io.katharsis.resource.information.ResourceField;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.links.DefaultPagedLinksInformation;
import io.katharsis.resource.links.LinksInformation;
import io.katharsis.resource.links.PagedLinksInformation;
import io.katharsis.resource.list.DefaultResourceList;
import io.katharsis.resource.list.PagedResultList;
import io.katharsis.resource.list.ResourceList;
import io.katharsis.resource.meta.MetaInformation;
import io.katharsis.resource.meta.PagedMetaInformation;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ResponseRepositoryAdapter {
    protected ResourceInformation resourceInformation;
    protected ModuleRegistry moduleRegistry;

    public ResponseRepositoryAdapter(ResourceInformation resourceInformation, ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.resourceInformation = resourceInformation;
    }

    protected <T> Iterable<T> filterResult(Iterable<?> resources, RepositoryRequestSpec requestSpec) {
        RepositoryResultFilterChainImpl chain = new RepositoryResultFilterChainImpl(resources);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    protected JsonApiResponse getResponse(Object repository, Object result, RepositoryRequestSpec requestSpec) {
        Iterable resultEntity;
        if (result instanceof JsonApiResponse) {
            return (JsonApiResponse)result;
        }
        boolean isCollection = result instanceof Iterable;
        List<Object> resources = isCollection ? (List<Object>)result : Collections.singletonList(result);
        Iterable filteredResult = this.filterResult(resources, requestSpec);
        MetaInformation metaInformation = this.getMetaInformation(repository, resources, requestSpec);
        LinksInformation linksInformation = this.getLinksInformation(repository, resources, requestSpec);
        if (isCollection) {
            resultEntity = filteredResult;
        } else {
            Iterator iterator = filteredResult.iterator();
            if (iterator.hasNext()) {
                resultEntity = iterator.next();
                PreconditionUtil.assertFalse("expected unique result", iterator.hasNext());
            } else {
                resultEntity = null;
            }
        }
        return new JsonApiResponse().setEntity(resultEntity).setLinksInformation(linksInformation).setMetaInformation(metaInformation);
    }

    private MetaInformation getMetaInformation(Object repository, Iterable<?> resources, RepositoryRequestSpec requestSpec) {
        RepositoryMetaFilterChainImpl chain = new RepositoryMetaFilterChainImpl(repository);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec), resources);
    }

    private MetaInformation doGetMetaInformation(Object repository, Iterable<?> resources, RepositoryRequestSpec requestSpec) {
        if (resources instanceof ResourceList) {
            ResourceList resourceList = (ResourceList)resources;
            return resourceList.getMeta();
        }
        QueryAdapter queryAdapter = requestSpec.getQueryAdapter();
        if (repository instanceof AnnotatedRepositoryAdapter) {
            if (((AnnotatedRepositoryAdapter)repository).metaRepositoryAvailable()) {
                return ((AnnotatedRepositoryAdapter)repository).getMetaInformation(resources, queryAdapter);
            }
        } else {
            if (repository instanceof MetaRepositoryV2) {
                return ((MetaRepositoryV2)repository).getMetaInformation(resources, requestSpec.getQuerySpec(this.getResourceInformation(repository)));
            }
            if (repository instanceof MetaRepository) {
                return ((MetaRepository)repository).getMetaInformation(resources, requestSpec.getQueryParams());
            }
        }
        return null;
    }

    private LinksInformation getLinksInformation(Object repository, Iterable<?> resources, RepositoryRequestSpec requestSpec) {
        RepositoryLinksFilterChainImpl chain = new RepositoryLinksFilterChainImpl(repository);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec), resources);
    }

    protected RepositoryFilterContext newRepositoryFilterContext(final RepositoryRequestSpec requestSpec) {
        return new RepositoryFilterContext(){

            @Override
            public RepositoryRequestSpec getRequest() {
                return requestSpec;
            }
        };
    }

    private LinksInformation doGetLinksInformation(Object repository, Iterable<?> resources, RepositoryRequestSpec requestSpec) {
        if (resources instanceof ResourceList) {
            ResourceList resourceList = (ResourceList)resources;
            boolean createLinksInformation = resourceList instanceof DefaultResourceList;
            LinksInformation newLinksInfo = this.enrichLinksInformation(resourceList.getLinks(), resources, requestSpec, createLinksInformation);
            if (createLinksInformation) {
                ((DefaultResourceList)resources).setLinks(newLinksInfo);
            }
            return resourceList.getLinks();
        }
        LinksInformation linksInformation = null;
        if (repository instanceof AnnotatedRepositoryAdapter) {
            if (((AnnotatedRepositoryAdapter)repository).linksRepositoryAvailable()) {
                linksInformation = ((LinksRepository)repository).getLinksInformation(resources, requestSpec.getQueryParams());
            }
        } else if (repository instanceof LinksRepositoryV2) {
            linksInformation = ((LinksRepositoryV2)repository).getLinksInformation(resources, requestSpec.getQuerySpec(this.getResourceInformation(repository)));
        } else if (repository instanceof LinksRepository) {
            linksInformation = ((LinksRepository)repository).getLinksInformation(resources, requestSpec.getQueryParams());
        }
        boolean createLinksInformation = true;
        return this.enrichLinksInformation(linksInformation, resources, requestSpec, createLinksInformation);
    }

    private LinksInformation enrichLinksInformation(LinksInformation linksInformation, Iterable<?> resources, RepositoryRequestSpec requestSpec, boolean createLinksInformation) {
        QueryAdapter queryAdapter = requestSpec.getQueryAdapter();
        LinksInformation enrichedLinksInformation = linksInformation;
        if (queryAdapter instanceof QuerySpecAdapter && (queryAdapter.getOffset() != 0L || queryAdapter.getLimit() != null)) {
            enrichedLinksInformation = this.enrichPageLinksInformation(enrichedLinksInformation, resources, queryAdapter, requestSpec, true);
        }
        return enrichedLinksInformation;
    }

    private LinksInformation enrichPageLinksInformation(LinksInformation linksInformation, Iterable<?> resources, QueryAdapter queryAdapter, RepositoryRequestSpec requestSpec, boolean createLinksInformation) {
        Long totalCount;
        if ((linksInformation == null && createLinksInformation || linksInformation instanceof PagedLinksInformation) && (totalCount = this.getTotalCount(resources)) != null) {
            PagedLinksInformation pagedLinksInformation = (PagedLinksInformation)linksInformation;
            if (pagedLinksInformation == null) {
                pagedLinksInformation = new DefaultPagedLinksInformation();
            }
            if (!this.hasPageLinks(pagedLinksInformation)) {
                this.doEnrichPageLinksInformation(pagedLinksInformation, totalCount, queryAdapter, requestSpec);
            }
            return pagedLinksInformation;
        }
        return linksInformation;
    }

    private Long getTotalCount(Iterable<?> resources) {
        ResourceList list;
        PagedMetaInformation pagedMeta;
        if (resources instanceof PagedResultList) {
            return ((PagedResultList)resources).getTotalCount();
        }
        if (resources instanceof ResourceList && (pagedMeta = (list = (ResourceList)resources).getMeta(PagedMetaInformation.class)) != null) {
            return pagedMeta.getTotalResourceCount();
        }
        return null;
    }

    private boolean hasPageLinks(PagedLinksInformation pagedLinksInformation) {
        return pagedLinksInformation.getFirst() != null || pagedLinksInformation.getLast() != null || pagedLinksInformation.getPrev() != null || pagedLinksInformation.getNext() != null;
    }

    private void doEnrichPageLinksInformation(PagedLinksInformation pagedLinksInformation, long total, QueryAdapter queryAdapter, RepositoryRequestSpec requestSpec) {
        long pageSize = queryAdapter.getLimit();
        long offset = queryAdapter.getOffset();
        long currentPage = offset / pageSize;
        if (currentPage * pageSize != offset) {
            throw new IllegalArgumentException("offset " + offset + " is not a multiple of limit " + pageSize);
        }
        long totalPages = (total + pageSize - 1L) / pageSize;
        QueryAdapter pageSpec = queryAdapter.duplicate();
        pageSpec.setLimit(pageSize);
        if (totalPages > 0L) {
            pageSpec.setOffset(0L);
            pagedLinksInformation.setFirst(this.toUrl(pageSpec, requestSpec));
            pageSpec.setOffset((totalPages - 1L) * pageSize);
            pagedLinksInformation.setLast(this.toUrl(pageSpec, requestSpec));
            if (currentPage > 0L) {
                pageSpec.setOffset((currentPage - 1L) * pageSize);
                pagedLinksInformation.setPrev(this.toUrl(pageSpec, requestSpec));
            }
            if (currentPage < totalPages - 1L) {
                pageSpec.setOffset((currentPage + 1L) * pageSize);
                pagedLinksInformation.setNext(this.toUrl(pageSpec, requestSpec));
            }
        }
    }

    private <T> String toUrl(QueryAdapter queryAdapter, RepositoryRequestSpec requestSpec) {
        JsonApiUrlBuilder urlBuilder = new JsonApiUrlBuilder(this.moduleRegistry.getResourceRegistry());
        Serializable relationshipSourceId = requestSpec.getId();
        ResourceField relationshipField = requestSpec.getRelationshipField();
        ResourceInformation rootInfo = relationshipField == null ? queryAdapter.getResourceInformation() : relationshipField.getParentResourceInformation();
        return urlBuilder.buildUrl(rootInfo, (Object)relationshipSourceId, queryAdapter, relationshipField != null ? relationshipField.getJsonName() : null);
    }

    protected abstract ResourceInformation getResourceInformation(Object var1);

    protected abstract class RepositoryBulkRequestFilterChainImpl<K>
    implements RepositoryBulkRequestFilterChain<K> {
        protected int filterIndex = 0;

        protected RepositoryBulkRequestFilterChainImpl() {
        }

        @Override
        public Map<K, JsonApiResponse> doFilter(RepositoryFilterContext context) {
            List<RepositoryFilter> filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters();
            if (this.filterIndex == filters.size()) {
                return this.invoke(context);
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterBulkRequest(context, this);
        }

        protected abstract Map<K, JsonApiResponse> invoke(RepositoryFilterContext var1);
    }

    protected abstract class RepositoryRequestFilterChainImpl
    implements RepositoryRequestFilterChain {
        protected int filterIndex = 0;

        protected RepositoryRequestFilterChainImpl() {
        }

        @Override
        public JsonApiResponse doFilter(RepositoryFilterContext context) {
            List<RepositoryFilter> filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters();
            if (this.filterIndex == filters.size()) {
                return this.invoke(context);
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterRequest(context, this);
        }

        protected abstract JsonApiResponse invoke(RepositoryFilterContext var1);
    }

    class RepositoryResultFilterChainImpl<T>
    implements RepositoryResultFilterChain<T> {
        protected int filterIndex = 0;
        private Iterable<T> result;

        public RepositoryResultFilterChainImpl(Iterable<T> result) {
            this.result = result;
        }

        @Override
        public Iterable<T> doFilter(RepositoryFilterContext context) {
            List<RepositoryFilter> filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters();
            if (this.filterIndex == filters.size()) {
                return this.result;
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterResult(context, this);
        }
    }

    class RepositoryLinksFilterChainImpl
    implements RepositoryLinksFilterChain {
        protected int filterIndex = 0;
        private Object repository;

        public RepositoryLinksFilterChainImpl(Object repository) {
            this.repository = repository;
        }

        @Override
        public <T> LinksInformation doFilter(RepositoryFilterContext context, Iterable<T> resources) {
            List<RepositoryFilter> filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters();
            if (this.filterIndex == filters.size()) {
                return ResponseRepositoryAdapter.this.doGetLinksInformation(this.repository, resources, context.getRequest());
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterLinks(context, resources, this);
        }
    }

    class RepositoryMetaFilterChainImpl
    implements RepositoryMetaFilterChain {
        protected int filterIndex = 0;
        private Object repository;

        public RepositoryMetaFilterChainImpl(Object repository) {
            this.repository = repository;
        }

        @Override
        public <T> MetaInformation doFilter(RepositoryFilterContext context, Iterable<T> resources) {
            List<RepositoryFilter> filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters();
            if (this.filterIndex == filters.size()) {
                return ResponseRepositoryAdapter.this.doGetMetaInformation(this.repository, resources, context.getRequest());
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterMeta(context, resources, this);
        }
    }
}

