/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.resource;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.katharsis.core.internal.utils.PropertyUtils;
import io.katharsis.legacy.queryParams.include.Inclusion;
import io.katharsis.legacy.queryParams.params.IncludedFieldsParams;
import io.katharsis.legacy.queryParams.params.IncludedRelationsParams;
import io.katharsis.legacy.queryParams.params.TypedParams;
import io.katharsis.repository.request.QueryAdapter;
import io.katharsis.resource.LinksContainer;
import io.katharsis.resource.MetaContainer;
import io.katharsis.resource.ResourceIdentifier;
import io.katharsis.resource.information.ResourceField;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.links.LinksInformation;
import io.katharsis.resource.links.RelatedLinksInformation;
import io.katharsis.resource.links.SelfLinksInformation;
import io.katharsis.resource.meta.MetaInformation;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DocumentMapperUtil {
    private ResourceRegistry resourceRegistry;
    private ObjectMapper objectMapper;

    public DocumentMapperUtil(ResourceRegistry resourceRegistry, ObjectMapper objectMapper) {
        this.resourceRegistry = resourceRegistry;
        this.objectMapper = objectMapper;
    }

    public String getRelationshipLink(ResourceInformation resourceInformation, Object entity, ResourceField field, boolean related) {
        String resourceUrl = this.resourceRegistry.getResourceUrl(resourceInformation);
        String resourceId = this.getIdString(entity, resourceInformation);
        return resourceUrl + "/" + resourceId + (!related ? "/relationships/" : "/") + field.getJsonName();
    }

    public List<ResourceIdentifier> toResourceIds(Collection<?> entities) {
        ArrayList<ResourceIdentifier> results = new ArrayList<ResourceIdentifier>();
        for (Object entity : entities) {
            results.add(this.toResourceId(entity));
        }
        return results;
    }

    public ResourceIdentifier toResourceId(Object entity) {
        if (entity == null) {
            return null;
        }
        RegistryEntry entry = this.resourceRegistry.findEntry(entity.getClass());
        ResourceInformation resourceInformation = entry.getResourceInformation();
        String strId = this.getIdString(entity, resourceInformation);
        return new ResourceIdentifier(strId, resourceInformation.getResourceType());
    }

    public String getIdString(Object entity, ResourceInformation resourceInformation) {
        ResourceField idField = resourceInformation.getIdField();
        Object sourceId = PropertyUtils.getProperty(entity, idField.getUnderlyingName());
        return resourceInformation.toIdString(sourceId);
    }

    protected static List<ResourceField> getRequestedFields(ResourceInformation resourceInformation, QueryAdapter queryAdapter, List<ResourceField> fields, boolean relation) {
        IncludedFieldsParams includedFields;
        TypedParams<IncludedFieldsParams> includedFieldsSet = queryAdapter != null ? queryAdapter.getIncludedFields() : null;
        IncludedFieldsParams includedFieldsParams = includedFields = includedFieldsSet != null ? includedFieldsSet.getParams().get(resourceInformation.getResourceType()) : null;
        if (DocumentMapperUtil.noResourceIncludedFieldsSpecified(includedFields)) {
            return fields;
        }
        Set<String> includedFieldNames = includedFields.getParams();
        if (relation) {
            IncludedRelationsParams includedRelations;
            TypedParams<IncludedRelationsParams> includedRelationsSet = queryAdapter.getIncludedRelations();
            IncludedRelationsParams includedRelationsParams = includedRelations = includedRelationsSet != null ? includedRelationsSet.getParams().get(resourceInformation.getResourceType()) : null;
            if (includedRelations != null) {
                includedFieldNames = new HashSet<String>(includedFieldNames);
                for (Inclusion include : includedRelations.getParams()) {
                    includedFieldNames.add(include.getPath());
                }
            }
        }
        ArrayList<ResourceField> results = new ArrayList<ResourceField>();
        for (ResourceField field : fields) {
            if (!includedFieldNames.contains(field.getJsonName())) continue;
            results.add(field);
        }
        return results;
    }

    public void setLinks(LinksContainer container, LinksInformation linksInformation) {
        if (linksInformation != null) {
            container.setLinks((ObjectNode)this.objectMapper.valueToTree((Object)linksInformation));
        }
    }

    public void setMeta(MetaContainer container, MetaInformation metaInformation) {
        if (metaInformation != null) {
            container.setMeta((ObjectNode)this.objectMapper.valueToTree((Object)metaInformation));
        }
    }

    protected static boolean noResourceIncludedFieldsSpecified(IncludedFieldsParams typeIncludedFields) {
        return typeIncludedFields == null || typeIncludedFields.getParams().isEmpty();
    }

    public static <T> List<T> toList(Object entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof List) {
            return (List)entity;
        }
        if (entity instanceof Iterable) {
            ArrayList result = new ArrayList();
            for (Object element : (Iterable)entity) {
                result.add(element);
            }
            return result;
        }
        return Collections.singletonList(entity);
    }

    public ResourceInformation getResourceInformation(Class<?> dataClass) {
        return this.resourceRegistry.findEntry(dataClass).getResourceInformation();
    }

    public ResourceInformation getResourceInformation(String resourceType) {
        return this.resourceRegistry.getEntry(resourceType).getResourceInformation();
    }

    public String getSelfUrl(ResourceInformation resourceInformation, Object entity) {
        String resourceUrl = this.resourceRegistry.getResourceUrl(resourceInformation);
        return resourceUrl + "/" + this.getIdString(entity, resourceInformation);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected static class DefaultSelfRelatedLinksInformation
    implements SelfLinksInformation,
    RelatedLinksInformation {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String related;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String self;

        protected DefaultSelfRelatedLinksInformation() {
        }

        @Override
        public String getRelated() {
            return this.related;
        }

        @Override
        public void setRelated(String related) {
            this.related = related;
        }

        @Override
        public String getSelf() {
            return this.self;
        }

        @Override
        public void setSelf(String self) {
            this.self = self;
        }
    }
}

