/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.legacy.internal;

import io.katharsis.core.internal.utils.ClassUtils;
import io.katharsis.legacy.internal.AnnotatedRepositoryAdapter;
import io.katharsis.legacy.internal.ParametersFactory;
import io.katharsis.legacy.repository.annotations.JsonApiDelete;
import io.katharsis.legacy.repository.annotations.JsonApiFindAll;
import io.katharsis.legacy.repository.annotations.JsonApiFindAllWithIds;
import io.katharsis.legacy.repository.annotations.JsonApiFindOne;
import io.katharsis.legacy.repository.annotations.JsonApiSave;
import io.katharsis.repository.request.QueryAdapter;
import java.io.Serializable;
import java.lang.reflect.Method;

public class AnnotatedResourceRepositoryAdapter<T, ID extends Serializable>
extends AnnotatedRepositoryAdapter<T> {
    private Method findOneMethod;
    private Method findAllMethod;
    private Method findAllWithIds;
    private Method saveMethod;
    private Method deleteMethod;

    public AnnotatedResourceRepositoryAdapter(Object implementationObject, ParametersFactory parametersFactory) {
        super(implementationObject, parametersFactory);
    }

    public Object findOne(ID id, QueryAdapter queryAdapter) {
        Class<JsonApiFindOne> annotationType = JsonApiFindOne.class;
        if (this.findOneMethod == null) {
            this.findOneMethod = ClassUtils.findMethodWith(this.implementationClass, annotationType);
        }
        return this.invokeOperation(this.findOneMethod, annotationType, new Object[]{id}, queryAdapter);
    }

    public Object findAll(QueryAdapter queryAdapter) {
        Class<JsonApiFindAll> annotationType = JsonApiFindAll.class;
        if (this.findAllMethod == null) {
            this.findAllMethod = ClassUtils.findMethodWith(this.implementationClass, annotationType);
        }
        return this.invokeOperation(this.findAllMethod, annotationType, new Object[0], queryAdapter);
    }

    public Object findAll(Iterable<ID> ids, QueryAdapter queryAdapter) {
        Class<JsonApiFindAllWithIds> annotationType = JsonApiFindAllWithIds.class;
        if (this.findAllWithIds == null) {
            this.findAllWithIds = ClassUtils.findMethodWith(this.implementationClass, annotationType);
        }
        return this.invokeOperation(this.findAllWithIds, annotationType, new Object[]{ids}, queryAdapter);
    }

    public <S extends T> Object save(S entity) {
        Class<JsonApiSave> annotationType = JsonApiSave.class;
        if (this.saveMethod == null) {
            this.saveMethod = ClassUtils.findMethodWith(this.implementationClass, annotationType);
        }
        return this.invokeOperation(this.saveMethod, annotationType, new Object[]{entity});
    }

    public void delete(ID id, QueryAdapter queryAdapter) {
        Class<JsonApiDelete> annotationType = JsonApiDelete.class;
        if (this.deleteMethod == null) {
            this.deleteMethod = ClassUtils.findMethodWith(this.implementationClass, annotationType);
        }
        this.invokeOperation(this.deleteMethod, annotationType, new Object[]{id}, queryAdapter);
    }
}

