/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.legacy.registry;

import io.katharsis.core.internal.registry.DirectResponseRelationshipEntry;
import io.katharsis.core.internal.registry.DirectResponseResourceEntry;
import io.katharsis.errorhandling.exception.RepositoryInstanceNotFoundException;
import io.katharsis.legacy.locator.JsonServiceLocator;
import io.katharsis.legacy.registry.RepositoryEntryBuilder;
import io.katharsis.legacy.registry.RepositoryInstanceBuilder;
import io.katharsis.legacy.repository.RelationshipRepository;
import io.katharsis.legacy.repository.ResourceRepository;
import io.katharsis.repository.RelationshipRepositoryV2;
import io.katharsis.repository.ResourceRepositoryV2;
import io.katharsis.resource.registry.ResourceEntry;
import io.katharsis.resource.registry.ResourceLookup;
import io.katharsis.resource.registry.ResponseRelationshipEntry;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.jodah.typetools.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectRepositoryEntryBuilder
implements RepositoryEntryBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectRepositoryEntryBuilder.class);
    private final JsonServiceLocator jsonServiceLocator;

    public DirectRepositoryEntryBuilder(JsonServiceLocator jsonServiceLocator) {
        this.jsonServiceLocator = jsonServiceLocator;
    }

    @Override
    public ResourceEntry buildResourceRepository(ResourceLookup lookup, Class<?> resourceClass) {
        Class<?> repoClass = this.getRepoClassType(lookup.getResourceRepositoryClasses(), resourceClass);
        if (repoClass == null) {
            return null;
        }
        DirectResponseResourceEntry directResourceEntry = new DirectResponseResourceEntry(new RepositoryInstanceBuilder<ResourceRepository>(this.jsonServiceLocator, repoClass));
        return directResourceEntry;
    }

    private Class<?> getRepoClassType(Set<Class<?>> repositoryClasses, Class<?> resourceClass) {
        for (Class<?> repoClass : repositoryClasses) {
            Class[] typeArgs;
            if (ResourceRepository.class.isAssignableFrom(repoClass) && (typeArgs = TypeResolver.resolveRawArguments(ResourceRepository.class, repoClass))[0] == resourceClass) {
                return repoClass;
            }
            if (!ResourceRepositoryV2.class.isAssignableFrom(repoClass) || (typeArgs = TypeResolver.resolveRawArguments(ResourceRepositoryV2.class, repoClass))[0] != resourceClass) continue;
            return repoClass;
        }
        return null;
    }

    @Override
    public List<ResponseRelationshipEntry> buildRelationshipRepositories(ResourceLookup lookup, Class<?> resourceClass) {
        Set<Class<?>> relationshipRepositoryClasses = lookup.getResourceRepositoryClasses();
        Set<Class<?>> relationshipRepositories = this.findRelationshipRepositories(resourceClass, relationshipRepositoryClasses);
        LinkedList<ResponseRelationshipEntry> relationshipEntries = new LinkedList<ResponseRelationshipEntry>();
        for (Class<?> relationshipRepositoryClass : relationshipRepositories) {
            Object relationshipRepository = this.jsonServiceLocator.getInstance(relationshipRepositoryClass);
            if (relationshipRepository == null) {
                throw new RepositoryInstanceNotFoundException(relationshipRepositoryClass.getCanonicalName());
            }
            LOGGER.debug("Assigned {} RelationshipRepository  to {} resource class", (Object)relationshipRepositoryClass.getCanonicalName(), (Object)resourceClass.getCanonicalName());
            DirectResponseRelationshipEntry relationshipEntry = new DirectResponseRelationshipEntry(new RepositoryInstanceBuilder(this.jsonServiceLocator, relationshipRepositoryClass));
            relationshipEntries.add(relationshipEntry);
        }
        return relationshipEntries;
    }

    private Set<Class<?>> findRelationshipRepositories(Class resourceClass, Set<Class<?>> relationshipRepositoryClasses) {
        HashSet relationshipRepositories = new HashSet();
        for (Class<?> repoClass : relationshipRepositoryClasses) {
            Class[] typeArgs;
            if (RelationshipRepository.class.isAssignableFrom(repoClass) && (typeArgs = TypeResolver.resolveRawArguments(RelationshipRepository.class, repoClass))[0] == resourceClass) {
                relationshipRepositories.add(repoClass);
            }
            if (!RelationshipRepositoryV2.class.isAssignableFrom(repoClass) || (typeArgs = TypeResolver.resolveRawArguments(RelationshipRepositoryV2.class, repoClass))[0] != resourceClass) continue;
            relationshipRepositories.add(repoClass);
        }
        return relationshipRepositories;
    }
}

