/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.module;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.core.internal.exception.ExceptionMapperLookup;
import io.katharsis.core.internal.registry.DirectResponseRelationshipEntry;
import io.katharsis.core.internal.registry.DirectResponseResourceEntry;
import io.katharsis.core.internal.repository.information.ResourceRepositoryInformationImpl;
import io.katharsis.core.internal.utils.ClassUtils;
import io.katharsis.core.internal.utils.MultivaluedMap;
import io.katharsis.core.internal.utils.PreconditionUtil;
import io.katharsis.errorhandling.mapper.ExceptionMapper;
import io.katharsis.errorhandling.mapper.JsonApiExceptionMapper;
import io.katharsis.legacy.registry.AnnotatedRelationshipEntryBuilder;
import io.katharsis.legacy.registry.AnnotatedResourceEntry;
import io.katharsis.legacy.registry.DefaultResourceInformationBuilderContext;
import io.katharsis.legacy.registry.RepositoryInstanceBuilder;
import io.katharsis.legacy.repository.annotations.JsonApiRelationshipRepository;
import io.katharsis.legacy.repository.annotations.JsonApiResourceRepository;
import io.katharsis.module.InitializingModule;
import io.katharsis.module.Module;
import io.katharsis.module.ServiceDiscovery;
import io.katharsis.module.SimpleModule;
import io.katharsis.repository.RelationshipRepositoryV2;
import io.katharsis.repository.Repository;
import io.katharsis.repository.ResourceRepositoryV2;
import io.katharsis.repository.decorate.RelationshipRepositoryDecorator;
import io.katharsis.repository.decorate.RepositoryDecoratorFactory;
import io.katharsis.repository.decorate.ResourceRepositoryDecorator;
import io.katharsis.repository.filter.DocumentFilter;
import io.katharsis.repository.filter.RepositoryFilter;
import io.katharsis.repository.information.RelationshipRepositoryInformation;
import io.katharsis.repository.information.RepositoryInformation;
import io.katharsis.repository.information.RepositoryInformationBuilder;
import io.katharsis.repository.information.RepositoryInformationBuilderContext;
import io.katharsis.repository.information.ResourceRepositoryInformation;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.information.ResourceInformationBuilder;
import io.katharsis.resource.information.ResourceInformationBuilderContext;
import io.katharsis.resource.registry.MultiResourceLookup;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceEntry;
import io.katharsis.resource.registry.ResourceLookup;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.resource.registry.ResourceRegistryAware;
import io.katharsis.resource.registry.ResponseRelationshipEntry;
import io.katharsis.security.SecurityProvider;
import io.katharsis.utils.parser.TypeParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModuleRegistry {
    private TypeParser typeParser = new TypeParser();
    private ObjectMapper objectMapper;
    private ResourceRegistry resourceRegistry;
    private List<Module> modules = new ArrayList<Module>();
    private SimpleModule aggregatedModule = new SimpleModule(null);
    private volatile boolean initialized;
    private ServiceDiscovery serviceDiscovery;
    private boolean isServer = true;

    public ModuleRegistry() {
        this(true);
    }

    public ModuleRegistry(boolean isServer) {
        this.isServer = isServer;
    }

    public void addModule(Module module) {
        module.setupModule(new ModuleContextImpl());
        this.modules.add(module);
    }

    public ResourceRegistry getResourceRegistry() {
        if (this.resourceRegistry == null) {
            throw new IllegalStateException("resourceRegistry not yet available");
        }
        return this.resourceRegistry;
    }

    public List<com.fasterxml.jackson.databind.Module> getJacksonModules() {
        return this.aggregatedModule.getJacksonModules();
    }

    protected void checkNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("already initialized, cannot be changed anymore");
        }
    }

    public ResourceInformationBuilder getResourceInformationBuilder() {
        CombinedResourceInformationBuilder resourceInformationBuilder = new CombinedResourceInformationBuilder(this.aggregatedModule.getResourceInformationBuilders());
        DefaultResourceInformationBuilderContext context = new DefaultResourceInformationBuilderContext(resourceInformationBuilder, this.typeParser);
        resourceInformationBuilder.init(context);
        return resourceInformationBuilder;
    }

    public RepositoryInformationBuilder getRepositoryInformationBuilder() {
        return new CombinedRepositoryInformationBuilder(this.aggregatedModule.getRepositoryInformationBuilders());
    }

    public ResourceLookup getResourceLookup() {
        return new MultiResourceLookup(this.aggregatedModule.getResourceLookups());
    }

    public SecurityProvider getSecurityProvider() {
        List<SecurityProvider> securityProviders = this.aggregatedModule.getSecurityProviders();
        PreconditionUtil.assertEquals("exactly one security provide must be installed, got: " + securityProviders, 1, securityProviders.size());
        return securityProviders.get(0);
    }

    public ServiceDiscovery getServiceDiscovery() {
        PreconditionUtil.assertNotNull("serviceDiscovery not yet available", this.serviceDiscovery);
        return this.serviceDiscovery;
    }

    public void init(ObjectMapper objectMapper) {
        if (!this.initialized) {
            this.initialized = true;
            this.objectMapper = objectMapper;
            this.objectMapper.registerModules(this.getJacksonModules());
            this.applyRepositoryRegistration(this.resourceRegistry);
            for (Module module : this.modules) {
                if (!(module instanceof InitializingModule)) continue;
                ((InitializingModule)module).init();
            }
        }
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    private void applyRepositoryRegistration(ResourceRegistry resourceRegistry) {
        List<Object> repositories = this.aggregatedModule.getRepositories();
        RepositoryInformationBuilder repositoryInformationBuilder = this.getRepositoryInformationBuilder();
        RepositoryInformationBuilderContext builderContext = new RepositoryInformationBuilderContext(){

            @Override
            public ResourceInformationBuilder getResourceInformationBuilder() {
                return ModuleRegistry.this.getResourceInformationBuilder();
            }

            @Override
            public TypeParser getTypeParser() {
                return ModuleRegistry.this.typeParser;
            }
        };
        MultivaluedMap<Class, RepositoryInformation> repositoryMap = new MultivaluedMap<Class, RepositoryInformation>();
        HashMap<RepositoryInformation, Object> repositoryImplementations = new HashMap<RepositoryInformation, Object>();
        for (Object repository : repositories) {
            RepositoryInformation info;
            if (repository instanceof ResourceRepositoryDecorator || repository instanceof RelationshipRepositoryDecorator) continue;
            RepositoryInformation repositoryInformation = repositoryInformationBuilder.build(repository, builderContext);
            if (repositoryInformation instanceof ResourceRepositoryInformation) {
                info = (ResourceRepositoryInformation)repositoryInformation;
                repositoryImplementations.put(info, repository);
                repositoryMap.add(info.getResourceInformation().getResourceClass(), repositoryInformation);
                continue;
            }
            info = (RelationshipRepositoryInformation)repositoryInformation;
            repositoryImplementations.put(info, repository);
            repositoryMap.add(info.getSourceResourceInformation().getResourceClass(), repositoryInformation);
        }
        for (Class resourceClass : repositoryMap.keySet()) {
            ResourceRepositoryInformation resourceRepositoryInformation = null;
            ArrayList<ResponseRelationshipEntry> relationshipEntries = new ArrayList<ResponseRelationshipEntry>();
            ResourceEntry resourceEntry = null;
            List repositoryInformations = repositoryMap.getList(resourceClass);
            for (RepositoryInformation repositoryInformation : repositoryInformations) {
                if (repositoryInformation instanceof ResourceRepositoryInformation) {
                    resourceRepositoryInformation = (ResourceRepositoryInformation)repositoryInformation;
                    Object repository = repositoryImplementations.get(resourceRepositoryInformation);
                    resourceEntry = this.setupResourceRepository(resourceRepositoryInformation, repository);
                    continue;
                }
                RelationshipRepositoryInformation relationshipRepositoryInformation = (RelationshipRepositoryInformation)repositoryInformation;
                Object repository = repositoryImplementations.get(repositoryInformation);
                this.setupRelationship(relationshipEntries, relationshipRepositoryInformation, repository);
            }
            if (resourceRepositoryInformation == null) {
                ResourceInformationBuilder resourceInformationBuilder = this.getResourceInformationBuilder();
                DefaultResourceInformationBuilderContext context = new DefaultResourceInformationBuilderContext(resourceInformationBuilder, this.typeParser);
                ResourceInformation resourceInformation = resourceInformationBuilder.build(resourceClass);
                resourceRepositoryInformation = new ResourceRepositoryInformationImpl(resourceClass, resourceInformation.getResourceType(), resourceInformation);
            }
            RegistryEntry registryEntry = new RegistryEntry(resourceRepositoryInformation, resourceEntry, relationshipEntries);
            resourceRegistry.addEntry(resourceClass, registryEntry);
        }
    }

    private ResourceEntry setupResourceRepository(ResourceRepositoryInformation resourceRepositoryInformation, Object repository) {
        final Object decoratedRepository = this.decorateRepository(repository);
        RepositoryInstanceBuilder repositoryInstanceBuilder = new RepositoryInstanceBuilder(null, null){

            public Object buildRepository() {
                return decoratedRepository;
            }
        };
        if (ClassUtils.getAnnotation(decoratedRepository.getClass(), JsonApiResourceRepository.class).isPresent()) {
            return new AnnotatedResourceEntry(this, repositoryInstanceBuilder);
        }
        return new DirectResponseResourceEntry(repositoryInstanceBuilder);
    }

    private Object decorateRepository(Object repository) {
        Repository decoratedRepository = repository;
        List<RepositoryDecoratorFactory> repositoryDecorators = this.getRepositoryDecoratorFactories();
        for (RepositoryDecoratorFactory repositoryDecorator : repositoryDecorators) {
            Repository decorator = null;
            if (decoratedRepository instanceof RelationshipRepositoryV2) {
                decorator = repositoryDecorator.decorateRepository(decoratedRepository);
            } else if (decoratedRepository instanceof ResourceRepositoryV2) {
                decorator = repositoryDecorator.decorateRepository((ResourceRepositoryV2)decoratedRepository);
            }
            if (decorator == null) continue;
            decorator.setDecoratedObject(decoratedRepository);
            decoratedRepository = decorator;
        }
        if (decoratedRepository instanceof ResourceRegistryAware) {
            ((ResourceRegistryAware)((Object)decoratedRepository)).setResourceRegistry(this.resourceRegistry);
        }
        return decoratedRepository;
    }

    private void setupRelationship(List<ResponseRelationshipEntry> relationshipEntries, final RelationshipRepositoryInformation relationshipRepositoryInformation, Object relRepository) {
        final Object decoratedRepository = this.decorateRepository(relRepository);
        RepositoryInstanceBuilder<Object> relationshipInstanceBuilder = new RepositoryInstanceBuilder<Object>(null, null){

            @Override
            public Object buildRepository() {
                return decoratedRepository;
            }

            @Override
            public Class getRepositoryClass() {
                return relationshipRepositoryInformation.getRepositoryClass();
            }
        };
        if (ClassUtils.getAnnotation(relRepository.getClass(), JsonApiRelationshipRepository.class).isPresent()) {
            relationshipEntries.add(new AnnotatedRelationshipEntryBuilder(this, relationshipInstanceBuilder));
        } else {
            DirectResponseRelationshipEntry relationshipEntry = new DirectResponseRelationshipEntry(relationshipInstanceBuilder){

                @Override
                public Class<?> getTargetAffiliation() {
                    return relationshipRepositoryInformation.getResourceInformation().getResourceClass();
                }
            };
            relationshipEntries.add(relationshipEntry);
        }
    }

    public List<DocumentFilter> getFilters() {
        return this.aggregatedModule.getFilters();
    }

    public List<RepositoryFilter> getRepositoryFilters() {
        return this.aggregatedModule.getRepositoryFilters();
    }

    public List<RepositoryDecoratorFactory> getRepositoryDecoratorFactories() {
        return this.aggregatedModule.getRepositoryDecoratorFactories();
    }

    public ExceptionMapperLookup getExceptionMapperLookup() {
        return new CombinedExceptionMapperLookup(this.aggregatedModule.getExceptionMapperLookups());
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void setResourceRegistry(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }

    public TypeParser getTypeParser() {
        return this.typeParser;
    }

    static class CombinedExceptionMapperLookup
    implements ExceptionMapperLookup {
        private Collection<ExceptionMapperLookup> lookups;

        public CombinedExceptionMapperLookup(List<ExceptionMapperLookup> lookups) {
            this.lookups = lookups;
        }

        @Override
        public Set<JsonApiExceptionMapper> getExceptionMappers() {
            HashSet<JsonApiExceptionMapper> set = new HashSet<JsonApiExceptionMapper>();
            for (ExceptionMapperLookup lookup : this.lookups) {
                set.addAll(lookup.getExceptionMappers());
            }
            return set;
        }
    }

    static class CombinedRepositoryInformationBuilder
    implements RepositoryInformationBuilder {
        private Collection<RepositoryInformationBuilder> builders;

        public CombinedRepositoryInformationBuilder(List<RepositoryInformationBuilder> builders) {
            this.builders = builders;
        }

        @Override
        public boolean accept(Object repository) {
            for (RepositoryInformationBuilder builder : this.builders) {
                if (!builder.accept(repository)) continue;
                return true;
            }
            return false;
        }

        @Override
        public RepositoryInformation build(Object repository, RepositoryInformationBuilderContext context) {
            for (RepositoryInformationBuilder builder : this.builders) {
                if (!builder.accept(repository)) continue;
                return builder.build(repository, context);
            }
            throw new UnsupportedOperationException("no RepositoryInformationBuilder for " + repository.getClass().getName() + " available");
        }

        @Override
        public boolean accept(Class<?> repositoryClass) {
            for (RepositoryInformationBuilder builder : this.builders) {
                if (!builder.accept(repositoryClass)) continue;
                return true;
            }
            return false;
        }

        @Override
        public RepositoryInformation build(Class<?> repositoryClass, RepositoryInformationBuilderContext context) {
            for (RepositoryInformationBuilder builder : this.builders) {
                if (!builder.accept(repositoryClass)) continue;
                return builder.build(repositoryClass, context);
            }
            throw new UnsupportedOperationException("no RepositoryInformationBuilder for " + repositoryClass.getName() + " available");
        }
    }

    static class CombinedResourceInformationBuilder
    implements ResourceInformationBuilder {
        private Collection<ResourceInformationBuilder> builders;

        public CombinedResourceInformationBuilder(List<ResourceInformationBuilder> builders) {
            this.builders = builders;
        }

        @Override
        public boolean accept(Class<?> resourceClass) {
            for (ResourceInformationBuilder builder : this.builders) {
                if (!builder.accept(resourceClass)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ResourceInformation build(Class<?> resourceClass) {
            for (ResourceInformationBuilder builder : this.builders) {
                if (!builder.accept(resourceClass)) continue;
                return builder.build(resourceClass);
            }
            throw new UnsupportedOperationException("no ResourceInformationBuilder for " + resourceClass.getName() + " available");
        }

        @Override
        public String getResourceType(Class<?> resourceClass) {
            for (ResourceInformationBuilder builder : this.builders) {
                if (!builder.accept(resourceClass)) continue;
                return builder.getResourceType(resourceClass);
            }
            return null;
        }

        @Override
        public void init(ResourceInformationBuilderContext context) {
            for (ResourceInformationBuilder builder : this.builders) {
                builder.init(context);
            }
        }
    }

    class ModuleContextImpl
    implements Module.ModuleContext {
        ModuleContextImpl() {
        }

        @Override
        public void addResourceInformationBuilder(ResourceInformationBuilder resourceInformationBuilder) {
            ModuleRegistry.this.checkNotInitialized();
            ModuleRegistry.this.aggregatedModule.addResourceInformationBuilder(resourceInformationBuilder);
        }

        @Override
        public void addRepositoryInformationBuilder(RepositoryInformationBuilder repositoryInformationBuilder) {
            ModuleRegistry.this.checkNotInitialized();
            ModuleRegistry.this.aggregatedModule.addRepositoryInformationBuilder(repositoryInformationBuilder);
        }

        @Override
        public void addResourceLookup(ResourceLookup resourceLookup) {
            ModuleRegistry.this.checkNotInitialized();
            ModuleRegistry.this.aggregatedModule.addResourceLookup(resourceLookup);
        }

        @Override
        public void addJacksonModule(com.fasterxml.jackson.databind.Module module) {
            ModuleRegistry.this.checkNotInitialized();
            ModuleRegistry.this.aggregatedModule.addJacksonModule(module);
            if (ModuleRegistry.this.objectMapper != null) {
                ModuleRegistry.this.objectMapper.registerModule(module);
            }
        }

        @Override
        public ResourceRegistry getResourceRegistry() {
            if (ModuleRegistry.this.resourceRegistry == null) {
                throw new IllegalStateException("resourceRegistry not yet available");
            }
            return ModuleRegistry.this.resourceRegistry;
        }

        @Override
        public void addFilter(DocumentFilter filter) {
            ModuleRegistry.this.checkNotInitialized();
            ModuleRegistry.this.aggregatedModule.addFilter(filter);
        }

        @Override
        public void addExceptionMapperLookup(ExceptionMapperLookup exceptionMapperLookup) {
            ModuleRegistry.this.checkNotInitialized();
            ModuleRegistry.this.aggregatedModule.addExceptionMapperLookup(exceptionMapperLookup);
        }

        @Override
        public void addExceptionMapper(ExceptionMapper<?> exceptionMapper) {
            ModuleRegistry.this.checkNotInitialized();
            ModuleRegistry.this.aggregatedModule.addExceptionMapper(exceptionMapper);
        }

        @Override
        public void addRepository(Class<?> type, Object repository) {
            ModuleRegistry.this.checkNotInitialized();
            ModuleRegistry.this.aggregatedModule.addRepository(repository);
        }

        @Override
        public void addRepository(Class<?> sourceType, Class<?> targetType, Object repository) {
            ModuleRegistry.this.checkNotInitialized();
            ModuleRegistry.this.aggregatedModule.addRepository(repository);
        }

        @Override
        public void addSecurityProvider(SecurityProvider securityProvider) {
            ModuleRegistry.this.checkNotInitialized();
            ModuleRegistry.this.aggregatedModule.addSecurityProvider(securityProvider);
        }

        @Override
        public SecurityProvider getSecurityProvider() {
            return ModuleRegistry.this.getSecurityProvider();
        }

        @Override
        public ServiceDiscovery getServiceDiscovery() {
            return ModuleRegistry.this.getServiceDiscovery();
        }

        @Override
        public void addRepositoryFilter(RepositoryFilter filter) {
            ModuleRegistry.this.checkNotInitialized();
            ModuleRegistry.this.aggregatedModule.addRepositoryFilter(filter);
        }

        @Override
        public void addRepositoryDecoratorFactory(RepositoryDecoratorFactory decoratorFactory) {
            ModuleRegistry.this.checkNotInitialized();
            ModuleRegistry.this.aggregatedModule.addRepositoryDecoratorFactory(decoratorFactory);
        }

        @Override
        public void addRepository(Object repository) {
            ModuleRegistry.this.aggregatedModule.addRepository(repository);
        }

        @Override
        public boolean isServer() {
            return ModuleRegistry.this.isServer;
        }

        @Override
        public TypeParser getTypeParser() {
            return ModuleRegistry.this.typeParser;
        }
    }
}

