/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.queryspec;

import io.katharsis.core.internal.utils.PropertyException;
import io.katharsis.core.internal.utils.PropertyUtils;
import io.katharsis.errorhandling.exception.BadRequestException;
import io.katharsis.errorhandling.exception.ParametersDeserializationException;
import io.katharsis.queryspec.Direction;
import io.katharsis.queryspec.FilterOperator;
import io.katharsis.queryspec.FilterSpec;
import io.katharsis.queryspec.QuerySpec;
import io.katharsis.queryspec.QuerySpecDeserializer;
import io.katharsis.queryspec.QuerySpecDeserializerContext;
import io.katharsis.queryspec.SortSpec;
import io.katharsis.resource.RestrictedQueryParamsMembers;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.utils.parser.TypeParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultQuerySpecDeserializer
implements QuerySpecDeserializer {
    private static final String OFFSET_PARAMETER = "offset";
    private static final String LIMIT_PARAMETER = "limit";
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("(\\w+)(\\[([^\\]]+)\\])?([\\w\\[\\]]*)");
    private TypeParser typeParser;
    private FilterOperator defaultOperator = FilterOperator.EQ;
    private long defaultOffset = 0L;
    private Long defaultLimit = null;
    private Long maxPageLimit = null;
    private Set<FilterOperator> supportedOperators = new HashSet<FilterOperator>();
    private ResourceRegistry resourceRegistry;
    private boolean allowUnknownAttributes = false;

    public DefaultQuerySpecDeserializer() {
        this.supportedOperators.add(FilterOperator.LIKE);
        this.supportedOperators.add(FilterOperator.EQ);
        this.supportedOperators.add(FilterOperator.NEQ);
        this.supportedOperators.add(FilterOperator.GT);
        this.supportedOperators.add(FilterOperator.GE);
        this.supportedOperators.add(FilterOperator.LT);
        this.supportedOperators.add(FilterOperator.LE);
    }

    public boolean getAllowUnknownAttributes() {
        return this.allowUnknownAttributes;
    }

    public void setAllowUnknownAttributes(boolean allowUnknownAttributes) {
        this.allowUnknownAttributes = allowUnknownAttributes;
    }

    public long getDefaultOffset() {
        return this.defaultOffset;
    }

    public void setDefaultOffset(long defaultOffset) {
        this.defaultOffset = defaultOffset;
    }

    public Long getDefaultLimit() {
        return this.defaultLimit;
    }

    public void setDefaultLimit(Long defaultLimit) {
        this.defaultLimit = defaultLimit;
    }

    public Long getMaxPageLimit() {
        return this.maxPageLimit;
    }

    public void setMaxPageLimit(Long maxPageLimit) {
        this.maxPageLimit = maxPageLimit;
    }

    public FilterOperator getDefaultOperator() {
        return this.defaultOperator;
    }

    public void setDefaultOperator(FilterOperator defaultOperator) {
        this.defaultOperator = defaultOperator;
    }

    public Set<FilterOperator> getSupportedOperators() {
        return this.supportedOperators;
    }

    public void addSupportedOperator(FilterOperator supportedOperator) {
        this.supportedOperators.add(supportedOperator);
    }

    @Override
    public void init(QuerySpecDeserializerContext ctx) {
        this.resourceRegistry = ctx.getResourceRegistry();
        this.typeParser = ctx.getTypeParser();
    }

    @Override
    public QuerySpec deserialize(ResourceInformation resourceInformation, Map<String, Set<String>> parameterMap) {
        QuerySpec rootQuerySpec = new QuerySpec(resourceInformation.getResourceClass());
        this.setupDefaults(rootQuerySpec);
        List<Parameter> parameters = this.parseParameters(parameterMap, resourceInformation);
        block7: for (Parameter parameter : parameters) {
            QuerySpec querySpec = rootQuerySpec.getQuerySpec(parameter.resourceInformation);
            if (querySpec == null) {
                querySpec = rootQuerySpec.getOrCreateQuerySpec(parameter.resourceInformation);
                this.setupDefaults(querySpec);
            }
            switch (parameter.paramType) {
                case sort: {
                    this.deserializeSort(querySpec, parameter);
                    continue block7;
                }
                case filter: {
                    this.deserializeFilter(querySpec, parameter);
                    continue block7;
                }
                case include: {
                    this.deserializeIncludes(querySpec, parameter);
                    continue block7;
                }
                case fields: {
                    this.deserializeFields(querySpec, parameter);
                    continue block7;
                }
                case page: {
                    this.deserializePage(querySpec, parameter);
                    continue block7;
                }
            }
            throw new IllegalStateException(parameter.paramType.toString());
        }
        return rootQuerySpec;
    }

    private void setupDefaults(QuerySpec querySpec) {
        querySpec.setOffset(this.defaultOffset);
        querySpec.setLimit(this.defaultLimit);
    }

    private void deserializeIncludes(QuerySpec querySpec, Parameter parameter) {
        this.checkNoParameterName(parameter);
        for (String values : parameter.values) {
            for (String value : this.splitValues(values)) {
                List<String> attributePath = this.splitAttributePath(value, parameter);
                querySpec.includeRelation(attributePath);
            }
        }
    }

    private void checkNoParameterName(Parameter parameter) {
        if (parameter.name != null) {
            throw new ParametersDeserializationException("invalid parameter " + parameter);
        }
    }

    private String[] splitValues(String values) {
        return values.split(",");
    }

    private void deserializeFields(QuerySpec querySpec, Parameter parameter) {
        this.checkNoParameterName(parameter);
        for (String values : parameter.values) {
            for (String value : this.splitValues(values)) {
                List<String> attributePath = this.splitAttributePath(value, parameter);
                querySpec.includeField(attributePath);
            }
        }
    }

    private void deserializePage(QuerySpec querySpec, Parameter parameter) {
        if (!parameter.name.startsWith("[") || !parameter.name.endsWith("]")) {
            throw new ParametersDeserializationException(parameter.toString());
        }
        String name = parameter.name.substring(1, parameter.name.length() - 1);
        if (OFFSET_PARAMETER.equalsIgnoreCase(name)) {
            querySpec.setOffset(parameter.getLongValue());
        } else if (LIMIT_PARAMETER.equalsIgnoreCase(name)) {
            Long limit = parameter.getLongValue();
            if (this.getMaxPageLimit() != null && limit != null && limit > this.getMaxPageLimit()) {
                String error = String.format("%s parameter value %d is larger than the maximum allowed of of %d", LIMIT_PARAMETER, limit, this.getMaxPageLimit());
                throw new BadRequestException(error);
            }
            querySpec.setLimit(limit);
        } else {
            throw new ParametersDeserializationException(parameter.toString());
        }
    }

    private void deserializeFilter(QuerySpec querySpec, Parameter parameter) {
        List<String> attributePath = this.splitKeyPath(parameter.name, parameter);
        String lastPathElement = attributePath.get(attributePath.size() - 1);
        FilterOperator filterOp = null;
        for (FilterOperator op : this.supportedOperators) {
            if (!op.getName().equalsIgnoreCase(lastPathElement)) continue;
            filterOp = op;
            attributePath = attributePath.subList(0, attributePath.size() - 1);
            break;
        }
        if (filterOp == null) {
            filterOp = this.defaultOperator;
        }
        Class<?> attributeType = this.getAttributeType(querySpec, attributePath);
        HashSet typedValues = new HashSet();
        for (String stringValue : parameter.values) {
            Object value = this.typeParser.parse(stringValue, attributeType);
            typedValues.add(value);
        }
        HashSet value = typedValues.size() == 1 ? typedValues.iterator().next() : typedValues;
        querySpec.addFilter(new FilterSpec(attributePath, filterOp, value));
    }

    private Class<?> getAttributeType(QuerySpec querySpec, List<String> attributePath) {
        try {
            return PropertyUtils.getPropertyClass(querySpec.getResourceClass(), attributePath);
        }
        catch (PropertyException e) {
            if (this.allowUnknownAttributes) {
                return String.class;
            }
            throw e;
        }
    }

    private void deserializeSort(QuerySpec querySpec, Parameter parameter) {
        this.checkNoParameterName(parameter);
        for (String values : parameter.values) {
            for (String value : this.splitValues(values)) {
                boolean desc = value.startsWith("-");
                if (desc) {
                    value = value.substring(1);
                }
                List<String> attributePath = this.splitAttributePath(value, parameter);
                Direction dir = desc ? Direction.DESC : Direction.ASC;
                querySpec.addSort(new SortSpec(attributePath, dir));
            }
        }
    }

    private List<Parameter> parseParameters(Map<String, Set<String>> params, ResourceInformation rootResourceInformation) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        Set<Map.Entry<String, Set<String>>> entrySet = params.entrySet();
        for (Map.Entry<String, Set<String>> entry : entrySet) {
            Matcher m = PARAMETER_PATTERN.matcher(entry.getKey());
            boolean accepted = m.matches();
            if (!accepted) {
                throw new ParametersDeserializationException("failed to parse parameter " + entry.getKey());
            }
            String strParamType = m.group(1);
            String resourceType = m.group(3);
            String path = m.group(4);
            RegistryEntry registryEntry = resourceType != null ? this.resourceRegistry.getEntry(resourceType) : null;
            Parameter param = new Parameter();
            param.fullKey = entry.getKey();
            param.paramType = RestrictedQueryParamsMembers.valueOf(strParamType.toLowerCase());
            param.values = entry.getValue();
            if (registryEntry == null) {
                param.resourceInformation = rootResourceInformation;
                String attrName = resourceType;
                param.name = attrName != null ? "[" + attrName + "]" + DefaultQuerySpecDeserializer.nullToEmpty(path) : DefaultQuerySpecDeserializer.emptyToNull(path);
            } else {
                param.resourceInformation = registryEntry.getResourceInformation();
                param.name = DefaultQuerySpecDeserializer.emptyToNull(path);
            }
            list.add(param);
        }
        return list;
    }

    private static String emptyToNull(String value) {
        return value.length() != 0 ? value : null;
    }

    private static String nullToEmpty(String value) {
        return value != null && value.length() > 0 ? value : "";
    }

    private List<String> splitKeyPath(String pathString, Parameter param) {
        if (!pathString.startsWith("[") || !pathString.endsWith("]")) {
            throw new ParametersDeserializationException("invalid attribute path in " + param.toString());
        }
        String temp = pathString.substring(1, pathString.length() - 1);
        String[] elements = temp.split("\\]\\[");
        ArrayList<String> results = new ArrayList<String>();
        for (String element : elements) {
            results.addAll(Arrays.asList(element.split("\\.")));
        }
        return results;
    }

    private List<String> splitAttributePath(String pathString, Parameter param) {
        return Arrays.asList(pathString.split("\\."));
    }

    class Parameter {
        String fullKey;
        RestrictedQueryParamsMembers paramType;
        ResourceInformation resourceInformation;
        String name;
        Set<String> values;

        Parameter() {
        }

        public Long getLongValue() {
            if (this.values.size() != 1) {
                throw new ParametersDeserializationException("expected a Long for " + this.toString());
            }
            try {
                return Long.parseLong(this.values.iterator().next());
            }
            catch (NumberFormatException e) {
                throw new ParametersDeserializationException("expected a Long for " + this.toString());
            }
        }

        public String toString() {
            return this.fullKey + "=" + this.values;
        }
    }
}

