/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.repository;

import io.katharsis.core.internal.utils.PreconditionUtil;
import io.katharsis.errorhandling.exception.ResourceNotFoundException;
import io.katharsis.queryspec.FilterOperator;
import io.katharsis.queryspec.FilterSpec;
import io.katharsis.queryspec.QuerySpec;
import io.katharsis.repository.ResourceRepositoryV2;
import io.katharsis.resource.list.ResourceList;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.resource.registry.ResourceRegistryAware;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;

public abstract class ResourceRepositoryBase<T, I extends Serializable>
implements ResourceRepositoryV2<T, I>,
ResourceRegistryAware {
    private Class<T> resourceClass;
    private ResourceRegistry resourceRegistry;

    protected ResourceRepositoryBase(Class<T> resourceClass) {
        this.resourceClass = resourceClass;
    }

    @Override
    public Class<T> getResourceClass() {
        return this.resourceClass;
    }

    @Override
    public T findOne(I id, QuerySpec querySpec) {
        RegistryEntry entry = this.resourceRegistry.findEntry(this.resourceClass);
        String idName = entry.getResourceInformation().getIdField().getUnderlyingName();
        QuerySpec idQuerySpec = querySpec.duplicate();
        idQuerySpec.addFilter(new FilterSpec(Arrays.asList(idName), FilterOperator.EQ, id));
        ResourceList iterable = this.findAll(idQuerySpec);
        Iterator iterator = iterable.iterator();
        if (iterator.hasNext()) {
            Object resource = iterator.next();
            PreconditionUtil.assertFalse("expected unique result", iterator.hasNext());
            return resource;
        }
        throw new ResourceNotFoundException("resource not found");
    }

    @Override
    public ResourceList<T> findAll(Iterable<I> ids, QuerySpec querySpec) {
        RegistryEntry entry = this.resourceRegistry.findEntry(this.resourceClass);
        String idName = entry.getResourceInformation().getIdField().getUnderlyingName();
        QuerySpec idQuerySpec = querySpec.duplicate();
        idQuerySpec.addFilter(new FilterSpec(Arrays.asList(idName), FilterOperator.EQ, ids));
        return this.findAll(idQuerySpec);
    }

    @Override
    public <S extends T> S save(S resource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <S extends T> S create(S resource) {
        return this.save(resource);
    }

    @Override
    public void delete(I id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setResourceRegistry(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }
}

