/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.utils;

import com.google.common.base.Objects;
import java.util.NoSuchElementException;

public class Nullable<T> {
    private static final Nullable<?> EMPTY = new Nullable();
    private static final Nullable<?> NULL = new Nullable<Object>(null);
    private final T value;
    private boolean present;

    private Nullable() {
        this.value = null;
        this.present = false;
    }

    private Nullable(T value) {
        this.value = value;
        this.present = true;
    }

    public boolean isPresent() {
        return this.present;
    }

    public T get() {
        if (!this.present) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public static <T> Nullable<T> empty() {
        return EMPTY;
    }

    public static <T> Nullable<T> of(T value) {
        return new Nullable<T>(value);
    }

    public static <T> Nullable<T> ofNullable(T value) {
        return value == null ? Nullable.empty() : Nullable.of(value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.present ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Nullable)) {
            return false;
        }
        Nullable other = (Nullable)obj;
        return Objects.equal((Object)this.present, (Object)other.present) && Objects.equal(this.value, other.value);
    }

    public static <T> Nullable<T> nullValue() {
        return NULL;
    }
}

