/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.spring.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.core.internal.exception.ExceptionMapperRegistry;
import io.katharsis.core.internal.exception.ExceptionMapperRegistryBuilder;
import io.katharsis.legacy.locator.JsonServiceLocator;
import io.katharsis.legacy.registry.ResourceRegistryBuilder;
import io.katharsis.module.ModuleRegistry;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.resource.registry.ServiceUrlProvider;
import io.katharsis.spring.boot.KatharsisSpringBootProperties;
import io.katharsis.spring.legacy.SpringServiceLocator;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={KatharsisSpringBootProperties.class})
public class KatharsisRegistryConfiguration {
    @Autowired
    private KatharsisSpringBootProperties properties;
    @Autowired
    private SpringServiceLocator serviceLocator;
    @Autowired
    private ModuleRegistry moduleRegistry;
    @Autowired
    private ObjectMapper objectMapper;

    @Bean
    public ResourceRegistry resourceRegistry(ServiceUrlProvider serviceUrlProvider) {
        ResourceRegistryBuilder registryBuilder = new ResourceRegistryBuilder(this.moduleRegistry, (JsonServiceLocator)this.serviceLocator, this.moduleRegistry.getResourceInformationBuilder());
        ResourceRegistry resourceRegistry = registryBuilder.build(this.properties.getResourcePackage(), this.moduleRegistry, serviceUrlProvider);
        this.moduleRegistry.init(this.objectMapper);
        return resourceRegistry;
    }

    @Bean
    public ExceptionMapperRegistry exceptionMapperRegistry() throws Exception {
        ExceptionMapperRegistryBuilder mapperRegistryBuilder = new ExceptionMapperRegistryBuilder();
        return mapperRegistryBuilder.build(this.properties.getResourcePackage());
    }

    @Bean
    public ServiceUrlProvider getServiceUrlProvider() {
        return new ServiceUrlProvider(){
            @Value(value="${katharsis.pathPrefix}")
            private String pathPrefix;
            @Resource
            private HttpServletRequest request;

            public String getUrl() {
                String scheme = this.request.getScheme();
                String host = this.request.getHeader("host");
                return scheme + "://" + host + this.pathPrefix;
            }
        };
    }
}

