/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.file;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.collections.SizeKt;
import io.kotest.matchers.file.ContentKt;
import io.kotest.matchers.file.MatchersKt;
import io.kotest.matchers.paths.PathsKt;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\u001a\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\n\u001a\u00020\u0002\u001a\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\n\u001a\u00020\u0002\u001a\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014\u001a\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0002\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0011\u001a\u0012\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110!*\u00020\u0002H\u0002\u001a\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020!*\u00020\u0002H\u0002\u001a\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020!*\u00020\u00022\u0006\u0010#\u001a\u00020$H\u0002\u001a\n\u0010%\u001a\u00020&*\u00020\u0002\u001a\n\u0010'\u001a\u00020&*\u00020\u0002\u001a\n\u0010(\u001a\u00020&*\u00020\u0002\u001a\n\u0010)\u001a\u00020&*\u00020\u0002\u001a\n\u0010*\u001a\u00020+*\u00020\u0002\u001a\n\u0010,\u001a\u00020&*\u00020\u0002\u001a\n\u0010-\u001a\u00020&*\u00020\u0002\u001a\n\u0010.\u001a\u00020&*\u00020\u0002\u001a\u0015\u0010/\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010/\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u001eH\u0086\u0004\u001a\n\u00100\u001a\u00020&*\u00020\u0002\u001a\n\u00101\u001a\u00020&*\u00020\u0002\u001a\u0015\u00102\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u00102\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u001eH\u0086\u0004\u001a\n\u00103\u001a\u00020&*\u00020\u0002\u001a\n\u00104\u001a\u00020&*\u00020\u0002\u001a\u0015\u00105\u001a\u00020&*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u00106\u001a\u00020+*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0004\u001a\n\u00107\u001a\u00020&*\u00020\u0002\u001a\u0015\u00108\u001a\u00020&*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0004\u001a\u0015\u00109\u001a\u00020&*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010:\u001a\u00020&*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002H\u0086\u0004\u001aJ\u0010:\u001a\u00020&*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u000226\u0010;\u001a2\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b=\u0012\b\b\u0010\u0012\u0004\b\b(>\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b=\u0012\b\b\u0010\u0012\u0004\b\b(?\u0012\u0004\u0012\u00020@0<\u001a>\u0010:\u001a\u00020&*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00022\u0014\b\u0002\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020@0B2\u0014\b\u0002\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020@0B\u001a\u0015\u0010D\u001a\u00020&*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002H\u0086\u0004\u001aJ\u0010D\u001a\u00020&*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u000226\u0010;\u001a2\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b=\u0012\b\b\u0010\u0012\u0004\b\b(>\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b=\u0012\b\b\u0010\u0012\u0004\b\b(?\u0012\u0004\u0012\u00020@0<\u001a>\u0010D\u001a\u00020&*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00022\u0014\b\u0002\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020@0B2\u0014\b\u0002\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020@0B\u001a\n\u0010E\u001a\u00020&*\u00020\u0002\u001a\n\u0010F\u001a\u00020&*\u00020\u0002\u001a\n\u0010G\u001a\u00020&*\u00020\u0002\u001a\n\u0010H\u001a\u00020&*\u00020\u0002\u001a\n\u0010I\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010J\u001a\u00020&*\u00020\u0002\u001a\n\u0010K\u001a\u00020&*\u00020\u0002\u001a\n\u0010L\u001a\u00020&*\u00020\u0002\u001a\u0015\u0010M\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010M\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u001eH\u0086\u0004\u001a\n\u0010N\u001a\u00020&*\u00020\u0002\u001a\n\u0010O\u001a\u00020&*\u00020\u0002\u001a\u0015\u0010P\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010P\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u001eH\u0086\u0004\u001a\n\u0010Q\u001a\u00020&*\u00020\u0002\u001a\n\u0010R\u001a\u00020&*\u00020\u0002\u001a\u0015\u0010S\u001a\u00020&*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010T\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0004\u001a\n\u0010U\u001a\u00020&*\u00020\u0002\u001a\u0015\u0010V\u001a\u00020&*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0004\u001a\u0015\u0010W\u001a\u00020&*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010X\u001a\u00020&*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010X\u001a\u00020&*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0004\u001a\u0015\u0010X\u001a\u00020&*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010X\u001a\u00020&*\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0004\u001a\u0015\u0010Y\u001a\u00020&*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010Y\u001a\u00020&*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0004\u001a\u0015\u0010Y\u001a\u00020&*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010Y\u001a\u00020&*\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0004\u00a8\u0006Z"}, d2={"aDirectory", "Lio/kotest/matchers/Matcher;", "Ljava/io/File;", "aFile", "beAbsolute", "beCanonicalPath", "beEmptyDirectory", "beExecutable", "beHidden", "beLarger", "other", "beReadable", "beRelative", "beSmaller", "beWriteable", "containFile", "name", "", "containNFiles", "n", "", "emptyFile", "exist", "haveFileSize", "size", "", "haveParent", "startWithPath", "file", "path", "Ljava/nio/file/Path;", "prefix", "safeList", "", "safeListFiles", "filter", "Ljava/io/FileFilter;", "shouldBeADirectory", "", "shouldBeAFile", "shouldBeAbsolute", "shouldBeCanonical", "shouldBeEmpty", "", "shouldBeEmptyDirectory", "shouldBeExecutable", "shouldBeHidden", "shouldBeLarger", "shouldBeReadable", "shouldBeRelative", "shouldBeSmaller", "shouldBeSymbolicLink", "shouldBeWriteable", "shouldContainFile", "shouldContainNFiles", "shouldExist", "shouldHaveFileSize", "shouldHaveParent", "shouldHaveSameStructureAndContentAs", "compare", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "expect", "actual", "", "filterLhs", "Lkotlin/Function1;", "filterRhs", "shouldHaveSameStructureAs", "shouldNotBeADirectory", "shouldNotBeAFile", "shouldNotBeAbsolute", "shouldNotBeCanonical", "shouldNotBeEmpty", "shouldNotBeEmptyDirectory", "shouldNotBeExecutable", "shouldNotBeHidden", "shouldNotBeLarger", "shouldNotBeReadable", "shouldNotBeRelative", "shouldNotBeSmaller", "shouldNotBeSymbolicLink", "shouldNotBeWriteable", "shouldNotContainFile", "shouldNotContainNFiles", "shouldNotExist", "shouldNotHaveFileSize", "shouldNotHaveParent", "shouldNotStartWithPath", "shouldStartWithPath", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nmatchers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 matchers.kt\nio/kotest/matchers/file/MatchersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,338:1\n3433#2,7:339\n3433#2,7:346\n*S KotlinDebug\n*F\n+ 1 matchers.kt\nio/kotest/matchers/file/MatchersKt\n*L\n274#1:339,7\n314#1:346,7\n*E\n"})
public final class MatchersKt {
    private static final List<String> safeList(File $this$safeList) {
        Object object = $this$safeList.list();
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final List<File> safeListFiles(File $this$safeListFiles) {
        Object object = $this$safeListFiles.listFiles();
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final List<File> safeListFiles(File $this$safeListFiles, FileFilter filter) {
        Object object = $this$safeListFiles.listFiles(filter);
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static final void shouldBeEmptyDirectory(@NotNull File $this$shouldBeEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeEmptyDirectory, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeEmptyDirectory, MatchersKt.beEmptyDirectory());
    }

    public static final void shouldNotBeEmptyDirectory(@NotNull File $this$shouldNotBeEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeEmptyDirectory, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeEmptyDirectory, MatchersKt.beEmptyDirectory());
    }

    @NotNull
    public static final Matcher<File> beEmptyDirectory() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                MatcherResult matcherResult;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (value.isDirectory()) {
                    List contents2 = MatchersKt.access$safeList(value);
                    matcherResult = MatcherResult.Companion.invoke(contents2.isEmpty(), (Function0)new Function0<String>(value, (List<String>)contents2){
                        final /* synthetic */ File $value;
                        final /* synthetic */ List<String> $contents;
                        {
                            this.$value = $value;
                            this.$contents = $contents;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return this.$value + " should be an empty directory but contained " + this.$contents.size() + " file(s) [" + CollectionsKt.joinToString$default((Iterable)this.$contents, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ']';
                        }
                    }, (Function0)new Function0<String>(value){
                        final /* synthetic */ File $value;
                        {
                            this.$value = $value;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return this.$value + " should not be a non empty directory";
                        }
                    });
                } else {
                    matcherResult = MatcherResult.Companion.invoke(false, (Function0)new Function0<String>(value){
                        final /* synthetic */ File $value;
                        {
                            this.$value = $value;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return this.$value + " should be an empty directory but was a file";
                        }
                    }, (Function0)new Function0<String>(value){
                        final /* synthetic */ File $value;
                        {
                            this.$value = $value;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return this.$value + " should not be a non empty directory";
                        }
                    });
                }
                return matcherResult;
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    @NotNull
    public static final Object shouldContainNFiles(@NotNull File $this$shouldContainNFiles, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainNFiles, (String)"<this>");
        return ShouldKt.shouldBe((Object)$this$shouldContainNFiles, MatchersKt.containNFiles(n));
    }

    @NotNull
    public static final File shouldNotContainNFiles(@NotNull File $this$shouldNotContainNFiles, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainNFiles, (String)"<this>");
        return (File)ShouldKt.shouldNotBe((Object)$this$shouldNotContainNFiles, MatchersKt.containNFiles(n));
    }

    @NotNull
    public static final Matcher<File> containNFiles(int n) {
        return (Matcher)new Matcher<File>(n){
            final /* synthetic */ int $n;
            {
                this.$n = $n;
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isDirectory() && MatchersKt.access$safeList(value).size() == this.$n, (Function0)new Function0<String>(value, this.$n){
                    final /* synthetic */ File $value;
                    final /* synthetic */ int $n;
                    {
                        this.$value = $value;
                        this.$n = $n;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.$value + " should be a directory and contain " + this.$n + " files";
                    }
                }, (Function0)new Function0<String>(value, this.$n){
                    final /* synthetic */ File $value;
                    final /* synthetic */ int $n;
                    {
                        this.$value = $value;
                        this.$n = $n;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.$value + " should not be a directory containing " + this.$n + " files";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    @NotNull
    public static final Object shouldBeEmpty(@NotNull File $this$shouldBeEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeEmpty, (String)"<this>");
        return ShouldKt.shouldBe((Object)$this$shouldBeEmpty, MatchersKt.emptyFile());
    }

    @NotNull
    public static final File shouldNotBeEmpty(@NotNull File $this$shouldNotBeEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeEmpty, (String)"<this>");
        return (File)ShouldKt.shouldNotBe((Object)$this$shouldNotBeEmpty, MatchersKt.emptyFile());
    }

    @NotNull
    public static final Matcher<File> emptyFile() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.length() == 0L, (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should be empty";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not be empty";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldExist(@NotNull File $this$shouldExist) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldExist, (String)"<this>");
        ShouldKt.should((Object)$this$shouldExist, MatchersKt.exist());
    }

    public static final void shouldNotExist(@NotNull File $this$shouldNotExist) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotExist, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotExist, MatchersKt.exist());
    }

    @NotNull
    public static final Matcher<File> exist() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.exists(), (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should exist";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not exist";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldContainFile(@NotNull File $this$shouldContainFile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.should((Object)$this$shouldContainFile, MatchersKt.containFile(name));
    }

    public static final void shouldNotContainFile(@NotNull File $this$shouldNotContainFile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.shouldNot((Object)$this$shouldNotContainFile, MatchersKt.containFile(name));
    }

    @NotNull
    public static final Matcher<File> containFile(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Matcher)new Matcher<File>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                List contents2 = MatchersKt.access$safeList(value);
                boolean passed = value.isDirectory() && contents2.contains(this.$name);
                return MatcherResult.Companion.invoke(passed, (Function0)new Function0<String>(value, this.$name, (List<String>)contents2){
                    final /* synthetic */ File $value;
                    final /* synthetic */ String $name;
                    final /* synthetic */ List<String> $contents;
                    {
                        this.$value = $value;
                        this.$name = $name;
                        this.$contents = $contents;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Directory " + this.$value + " should contain a file with filename " + this.$name + " (detected " + this.$contents.size() + " other files)";
                    }
                }, (Function0)new Function0<String>(value, this.$name){
                    final /* synthetic */ File $value;
                    final /* synthetic */ String $name;
                    {
                        this.$value = $value;
                        this.$name = $name;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Directory " + this.$value + " should not contain a file with filename " + this.$name;
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeSymbolicLink(@NotNull File $this$shouldBeSymbolicLink) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeSymbolicLink, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeSymbolicLink.toPath(), PathsKt.beSymbolicLink());
    }

    public static final void shouldNotBeSymbolicLink(@NotNull File $this$shouldNotBeSymbolicLink) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeSymbolicLink, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeSymbolicLink.toPath(), PathsKt.beSymbolicLink());
    }

    public static final void shouldHaveParent(@NotNull File $this$shouldHaveParent, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.should((Object)$this$shouldHaveParent, MatchersKt.haveParent(name));
    }

    public static final void shouldNotHaveParent(@NotNull File $this$shouldNotHaveParent, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveParent, MatchersKt.haveParent(name));
    }

    @NotNull
    public static final Matcher<File> haveParent(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Matcher)new Matcher<File>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            private final boolean isParentEqualExpected(File parent) {
                return parent != null && (Intrinsics.areEqual((Object)parent.getName(), (Object)this.$name) || this.isParentEqualExpected(parent.getParentFile()));
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(this.isParentEqualExpected(value.getParentFile()), (Function0)new Function0<String>(value, this.$name){
                    final /* synthetic */ File $value;
                    final /* synthetic */ String $name;
                    {
                        this.$value = $value;
                        this.$name = $name;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should have parent " + this.$name;
                    }
                }, (Function0)new Function0<String>(value, this.$name){
                    final /* synthetic */ File $value;
                    final /* synthetic */ String $name;
                    {
                        this.$value = $value;
                        this.$name = $name;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not have parent " + this.$name;
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeADirectory(@NotNull File $this$shouldBeADirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeADirectory, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeADirectory, MatchersKt.aDirectory());
    }

    public static final void shouldNotBeADirectory(@NotNull File $this$shouldNotBeADirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeADirectory, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeADirectory, MatchersKt.aDirectory());
    }

    @NotNull
    public static final Matcher<File> aDirectory() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isDirectory(), (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should be a directory";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not be a directory";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeAFile(@NotNull File $this$shouldBeAFile) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeAFile, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeAFile, MatchersKt.aFile());
    }

    public static final void shouldNotBeAFile(@NotNull File $this$shouldNotBeAFile) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeAFile, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeAFile, MatchersKt.aFile());
    }

    @NotNull
    public static final Matcher<File> aFile() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isFile(), (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should be a file";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not be a file";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeSmaller(@NotNull File $this$shouldBeSmaller, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        ShouldKt.should((Object)$this$shouldBeSmaller, MatchersKt.beSmaller(file));
    }

    public static final void shouldBeSmaller(@NotNull File $this$shouldBeSmaller, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.should((Object)$this$shouldBeSmaller, MatchersKt.beSmaller(other));
    }

    public static final void shouldNotBeSmaller(@NotNull File $this$shouldNotBeSmaller, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        ShouldKt.shouldNot((Object)$this$shouldNotBeSmaller, MatchersKt.beSmaller(file));
    }

    public static final void shouldNotBeSmaller(@NotNull File $this$shouldNotBeSmaller, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNot((Object)$this$shouldNotBeSmaller, MatchersKt.beSmaller(other));
    }

    @NotNull
    public static final Matcher<File> beSmaller(@NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (Matcher)new Matcher<File>(other){
            final /* synthetic */ File $other;
            {
                this.$other = $other;
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                long sizea = value.length();
                long sizeb = this.$other.length();
                return MatcherResult.Companion.invoke(value.length() < this.$other.length(), (Function0)new Function0<String>(value, sizea, this.$other, sizeb){
                    final /* synthetic */ File $value;
                    final /* synthetic */ long $sizea;
                    final /* synthetic */ File $other;
                    final /* synthetic */ long $sizeb;
                    {
                        this.$value = $value;
                        this.$sizea = $sizea;
                        this.$other = $other;
                        this.$sizeb = $sizeb;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " (" + this.$sizea + " bytes) should be smaller than " + this.$other + " (" + this.$sizeb + " bytes)";
                    }
                }, (Function0)new Function0<String>(value, sizea, this.$other, sizeb){
                    final /* synthetic */ File $value;
                    final /* synthetic */ long $sizea;
                    final /* synthetic */ File $other;
                    final /* synthetic */ long $sizeb;
                    {
                        this.$value = $value;
                        this.$sizea = $sizea;
                        this.$other = $other;
                        this.$sizeb = $sizeb;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " (" + this.$sizea + " bytes) should not be smaller than " + this.$other + " (" + this.$sizeb + " bytes)";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeLarger(@NotNull File $this$shouldBeLarger, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        ShouldKt.should((Object)$this$shouldBeLarger, MatchersKt.beLarger(file));
    }

    public static final void shouldBeLarger(@NotNull File $this$shouldBeLarger, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.should((Object)$this$shouldBeLarger, MatchersKt.beLarger(other));
    }

    public static final void shouldNotBeLarger(@NotNull File $this$shouldNotBeLarger, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        ShouldKt.shouldNot((Object)$this$shouldNotBeLarger, MatchersKt.beLarger(file));
    }

    public static final void shouldNotBeLarger(@NotNull File $this$shouldNotBeLarger, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNot((Object)$this$shouldNotBeLarger, MatchersKt.beLarger(other));
    }

    @NotNull
    public static final Matcher<File> beLarger(@NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (Matcher)new Matcher<File>(other){
            final /* synthetic */ File $other;
            {
                this.$other = $other;
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                long sizea = value.length();
                long sizeb = this.$other.length();
                return MatcherResult.Companion.invoke(value.length() > this.$other.length(), (Function0)new Function0<String>(value, sizea, this.$other, sizeb){
                    final /* synthetic */ File $value;
                    final /* synthetic */ long $sizea;
                    final /* synthetic */ File $other;
                    final /* synthetic */ long $sizeb;
                    {
                        this.$value = $value;
                        this.$sizea = $sizea;
                        this.$other = $other;
                        this.$sizeb = $sizeb;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " (" + this.$sizea + " bytes) should be larger than " + this.$other + " (" + this.$sizeb + " bytes)";
                    }
                }, (Function0)new Function0<String>(value, sizea, this.$other, sizeb){
                    final /* synthetic */ File $value;
                    final /* synthetic */ long $sizea;
                    final /* synthetic */ File $other;
                    final /* synthetic */ long $sizeb;
                    {
                        this.$value = $value;
                        this.$sizea = $sizea;
                        this.$other = $other;
                        this.$sizeb = $sizeb;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " (" + this.$sizea + " bytes) should not be larger than " + this.$other + " (" + this.$sizeb + " bytes)";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeCanonical(@NotNull File $this$shouldBeCanonical) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeCanonical, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeCanonical, MatchersKt.beCanonicalPath());
    }

    public static final void shouldNotBeCanonical(@NotNull File $this$shouldNotBeCanonical) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeCanonical, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeCanonical, MatchersKt.beCanonicalPath());
    }

    @NotNull
    public static final Matcher<File> beCanonicalPath() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Intrinsics.areEqual((Object)value.getCanonicalPath(), (Object)value.getPath()), (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should be canonical";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not be canonical";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeAbsolute(@NotNull File $this$shouldBeAbsolute) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeAbsolute, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeAbsolute, MatchersKt.beAbsolute());
    }

    public static final void shouldNotBeAbsolute(@NotNull File $this$shouldNotBeAbsolute) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeAbsolute, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeAbsolute, MatchersKt.beAbsolute());
    }

    @NotNull
    public static final Matcher<File> beAbsolute() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isAbsolute(), (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should be absolute";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not be absolute";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeRelative(@NotNull File $this$shouldBeRelative) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeRelative, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeRelative, MatchersKt.beRelative());
    }

    public static final void shouldNotBeRelative(@NotNull File $this$shouldNotBeRelative) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeRelative, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeRelative, MatchersKt.beRelative());
    }

    @NotNull
    public static final Matcher<File> beRelative() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(!value.isAbsolute(), (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should be relative";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not be relative";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldHaveFileSize(@NotNull File $this$shouldHaveFileSize, long size) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveFileSize, (String)"<this>");
        ShouldKt.should((Object)$this$shouldHaveFileSize, MatchersKt.haveFileSize(size));
    }

    public static final void shouldNotHaveFileSize(@NotNull File $this$shouldNotHaveFileSize, long size) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveFileSize, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveFileSize, MatchersKt.haveFileSize(size));
    }

    @NotNull
    public static final Matcher<File> haveFileSize(long size) {
        return (Matcher)new Matcher<File>(size){
            final /* synthetic */ long $size;
            {
                this.$size = $size;
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.length() == this.$size, (Function0)new Function0<String>(value, this.$size){
                    final /* synthetic */ File $value;
                    final /* synthetic */ long $size;
                    {
                        this.$value = $value;
                        this.$size = $size;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should have size " + this.$size;
                    }
                }, (Function0)new Function0<String>(value, this.$size){
                    final /* synthetic */ File $value;
                    final /* synthetic */ long $size;
                    {
                        this.$value = $value;
                        this.$size = $size;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not have size " + this.$size;
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeWriteable(@NotNull File $this$shouldBeWriteable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeWriteable, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeWriteable, MatchersKt.beWriteable());
    }

    public static final void shouldNotBeWriteable(@NotNull File $this$shouldNotBeWriteable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeWriteable, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeWriteable, MatchersKt.beWriteable());
    }

    @NotNull
    public static final Matcher<File> beWriteable() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.canWrite(), (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should be writeable";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not be writeable";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeExecutable(@NotNull File $this$shouldBeExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeExecutable, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeExecutable, MatchersKt.beExecutable());
    }

    public static final void shouldNotBeExecutable(@NotNull File $this$shouldNotBeExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeExecutable, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeExecutable, MatchersKt.beExecutable());
    }

    @NotNull
    public static final Matcher<File> beExecutable() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.canExecute(), (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should be executable";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not be executable";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeHidden(@NotNull File $this$shouldBeHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeHidden, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeHidden, MatchersKt.beHidden());
    }

    public static final void shouldNotBeHidden(@NotNull File $this$shouldNotBeHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeHidden, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeHidden, MatchersKt.beHidden());
    }

    @NotNull
    public static final Matcher<File> beHidden() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isHidden(), (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should be hidden";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not be hidden";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeReadable(@NotNull File $this$shouldBeReadable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeReadable, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeReadable, MatchersKt.beReadable());
    }

    public static final void shouldNotBeReadable(@NotNull File $this$shouldNotBeReadable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeReadable, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeReadable, MatchersKt.beReadable());
    }

    @NotNull
    public static final Matcher<File> beReadable() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.canRead(), (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should be readable";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ File $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not be readable";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldStartWithPath(@NotNull File $this$shouldStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.should((Object)$this$shouldStartWithPath, MatchersKt.startWithPath(path));
    }

    public static final void shouldNotStartWithPath(@NotNull File $this$shouldNotStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWithPath, MatchersKt.startWithPath(path));
    }

    public static final void shouldStartWithPath(@NotNull File $this$shouldStartWithPath, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        ShouldKt.should((Object)$this$shouldStartWithPath, MatchersKt.startWithPath(prefix));
    }

    public static final void shouldNotStartWithPath(@NotNull File $this$shouldNotStartWithPath, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWithPath, MatchersKt.startWithPath(prefix));
    }

    public static final void shouldStartWithPath(@NotNull File $this$shouldStartWithPath, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ShouldKt.should((Object)$this$shouldStartWithPath, MatchersKt.startWithPath(file));
    }

    public static final void shouldNotStartWithPath(@NotNull File $this$shouldNotStartWithPath, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWithPath, MatchersKt.startWithPath(file));
    }

    public static final void shouldStartWithPath(@NotNull Path $this$shouldStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.should((Object)$this$shouldStartWithPath.toFile(), MatchersKt.startWithPath(path));
    }

    public static final void shouldNotStartWithPath(@NotNull Path $this$shouldNotStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWithPath.toFile(), MatchersKt.startWithPath(path));
    }

    @NotNull
    public static final Matcher<File> startWithPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return MatchersKt.startWithPath(file);
    }

    @NotNull
    public static final Matcher<File> startWithPath(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return MatchersKt.startWithPath(string);
    }

    @NotNull
    public static final Matcher<File> startWithPath(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return (Matcher)new Matcher<File>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String string = value.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return MatcherResult.Companion.invoke(StringsKt.startsWith$default((String)string, (String)this.$prefix, (boolean)false, (int)2, null), (Function0)new Function0<String>(value, this.$prefix){
                    final /* synthetic */ File $value;
                    final /* synthetic */ String $prefix;
                    {
                        this.$value = $value;
                        this.$prefix = $prefix;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should start with " + this.$prefix;
                    }
                }, (Function0)new Function0<String>(value, this.$prefix){
                    final /* synthetic */ File $value;
                    final /* synthetic */ String $prefix;
                    {
                        this.$value = $value;
                        this.$prefix = $prefix;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not start with " + this.$prefix;
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldHaveSameStructureAs(@NotNull File $this$shouldHaveSameStructureAs, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveSameStructureAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MatchersKt.shouldHaveSameStructureAs($this$shouldHaveSameStructureAs, file, (Function2<? super File, ? super File, Boolean>)((Function2)shouldHaveSameStructureAs.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    public static final void shouldHaveSameStructureAs(@NotNull File $this$shouldHaveSameStructureAs, @NotNull File file, @NotNull Function2<? super File, ? super File, Boolean> compare) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveSameStructureAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(compare, (String)"compare");
        List expectFiles = SequencesKt.toList((Sequence)((Sequence)FilesKt.walkTopDown((File)$this$shouldHaveSameStructureAs)));
        List actualFiles = SequencesKt.toList((Sequence)((Sequence)FilesKt.walkTopDown((File)file)));
        String expectParentPath = $this$shouldHaveSameStructureAs.getPath();
        String actualParentPath = file.getPath();
        SizeKt.shouldBeSameSizeAs(expectFiles, (Collection)actualFiles);
        Iterable $this$zip$iv = expectFiles;
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = ((Iterable)actualFiles).iterator();
        ArrayList<Unit> list$iv = new ArrayList<Unit>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)actualFiles, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            Object object;
            void actual;
            void expect;
            File file2 = (File)second$iv.next();
            File file3 = (File)first$iv.next();
            ArrayList<Unit> arrayList = list$iv;
            boolean bl = false;
            if (((Boolean)compare.invoke((Object)expect, (Object)actual)).booleanValue()) {
                object = Unit.INSTANCE;
            } else if (expect.isDirectory()) {
                MatchersKt.shouldBeADirectory((File)actual);
                object = Unit.INSTANCE;
            } else if (expect.isFile()) {
                String string = expect.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                Intrinsics.checkNotNull((Object)expectParentPath);
                String string2 = StringsKt.removePrefix((String)string, (CharSequence)expectParentPath);
                String string3 = actual.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                Intrinsics.checkNotNull((Object)actualParentPath);
                object = ShouldKt.shouldBe((Object)string2, (Object)StringsKt.removePrefix((String)string3, (CharSequence)actualParentPath));
            } else {
                throw new IllegalStateException("There is an unexpected error analyzing file trees".toString());
            }
            arrayList.add((Unit)object);
        }
    }

    public static final void shouldHaveSameStructureAs(@NotNull File $this$shouldHaveSameStructureAs, @NotNull File file, @NotNull Function1<? super File, Boolean> filterLhs, @NotNull Function1<? super File, Boolean> filterRhs) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveSameStructureAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(filterLhs, (String)"filterLhs");
        Intrinsics.checkNotNullParameter(filterRhs, (String)"filterRhs");
        MatchersKt.shouldHaveSameStructureAs($this$shouldHaveSameStructureAs, file, (Function2<? super File, ? super File, Boolean>)((Function2)new Function2<File, File, Boolean>(filterLhs, filterRhs){
            final /* synthetic */ Function1<File, Boolean> $filterLhs;
            final /* synthetic */ Function1<File, Boolean> $filterRhs;
            {
                this.$filterLhs = $filterLhs;
                this.$filterRhs = $filterRhs;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull File expect, @NotNull File actual) {
                Intrinsics.checkNotNullParameter((Object)expect, (String)"expect");
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                return (Boolean)this.$filterLhs.invoke((Object)expect) != false || (Boolean)this.$filterRhs.invoke((Object)actual) != false;
            }
        }));
    }

    public static /* synthetic */ void shouldHaveSameStructureAs$default(File file, File file2, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = shouldHaveSameStructureAs.3.INSTANCE;
        }
        if ((n & 4) != 0) {
            function12 = shouldHaveSameStructureAs.4.INSTANCE;
        }
        MatchersKt.shouldHaveSameStructureAs(file, file2, (Function1<? super File, Boolean>)function1, (Function1<? super File, Boolean>)function12);
    }

    public static final void shouldHaveSameStructureAndContentAs(@NotNull File $this$shouldHaveSameStructureAndContentAs, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveSameStructureAndContentAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MatchersKt.shouldHaveSameStructureAndContentAs($this$shouldHaveSameStructureAndContentAs, file, (Function2<? super File, ? super File, Boolean>)((Function2)shouldHaveSameStructureAndContentAs.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    public static final void shouldHaveSameStructureAndContentAs(@NotNull File $this$shouldHaveSameStructureAndContentAs, @NotNull File file, @NotNull Function2<? super File, ? super File, Boolean> compare) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveSameStructureAndContentAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(compare, (String)"compare");
        List expectFiles = SequencesKt.toList((Sequence)((Sequence)FilesKt.walkTopDown((File)$this$shouldHaveSameStructureAndContentAs)));
        List actualFiles = SequencesKt.toList((Sequence)((Sequence)FilesKt.walkTopDown((File)file)));
        String expectParentPath = $this$shouldHaveSameStructureAndContentAs.getPath();
        String actualParentPath = file.getPath();
        SizeKt.shouldBeSameSizeAs(expectFiles, (Collection)actualFiles);
        Iterable $this$zip$iv = expectFiles;
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = ((Iterable)actualFiles).iterator();
        ArrayList<Unit> list$iv = new ArrayList<Unit>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)actualFiles, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void actual;
            void expect;
            File file2 = (File)second$iv.next();
            File file3 = (File)first$iv.next();
            ArrayList<Unit> arrayList = list$iv;
            boolean bl = false;
            if (!((Boolean)compare.invoke((Object)expect, (Object)actual)).booleanValue()) {
                if (expect.isDirectory()) {
                    MatchersKt.shouldBeADirectory((File)actual);
                } else if (expect.isFile()) {
                    String string = expect.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    Intrinsics.checkNotNull((Object)expectParentPath);
                    String string2 = StringsKt.removePrefix((String)string, (CharSequence)expectParentPath);
                    String string3 = actual.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                    Intrinsics.checkNotNull((Object)actualParentPath);
                    ShouldKt.shouldBe((Object)string2, (Object)StringsKt.removePrefix((String)string3, (CharSequence)actualParentPath));
                    ContentKt.shouldHaveSameContentAs$default((File)expect, (File)actual, null, 2, null);
                } else {
                    throw new IllegalStateException("There is an unexpected error analyzing file trees".toString());
                }
            }
            arrayList.add(Unit.INSTANCE);
        }
    }

    public static final void shouldHaveSameStructureAndContentAs(@NotNull File $this$shouldHaveSameStructureAndContentAs, @NotNull File file, @NotNull Function1<? super File, Boolean> filterLhs, @NotNull Function1<? super File, Boolean> filterRhs) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveSameStructureAndContentAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(filterLhs, (String)"filterLhs");
        Intrinsics.checkNotNullParameter(filterRhs, (String)"filterRhs");
        MatchersKt.shouldHaveSameStructureAndContentAs($this$shouldHaveSameStructureAndContentAs, file, (Function2<? super File, ? super File, Boolean>)((Function2)new Function2<File, File, Boolean>(filterLhs, filterRhs){
            final /* synthetic */ Function1<File, Boolean> $filterLhs;
            final /* synthetic */ Function1<File, Boolean> $filterRhs;
            {
                this.$filterLhs = $filterLhs;
                this.$filterRhs = $filterRhs;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull File expect, @NotNull File actual) {
                Intrinsics.checkNotNullParameter((Object)expect, (String)"expect");
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                return (Boolean)this.$filterLhs.invoke((Object)expect) != false || (Boolean)this.$filterRhs.invoke((Object)actual) != false;
            }
        }));
    }

    public static /* synthetic */ void shouldHaveSameStructureAndContentAs$default(File file, File file2, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = shouldHaveSameStructureAndContentAs.3.INSTANCE;
        }
        if ((n & 4) != 0) {
            function12 = shouldHaveSameStructureAndContentAs.4.INSTANCE;
        }
        MatchersKt.shouldHaveSameStructureAndContentAs(file, file2, (Function1<? super File, Boolean>)function1, (Function1<? super File, Boolean>)function12);
    }

    public static final /* synthetic */ List access$safeList(File $receiver) {
        return MatchersKt.safeList($receiver);
    }
}

