/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.eq;

import io.kotest.assertions.Actual;
import io.kotest.assertions.Expected;
import io.kotest.assertions.FailuresKt;
import io.kotest.assertions.eq.Eq;
import io.kotest.assertions.eq.EqKt;
import io.kotest.assertions.eq.IsOrderedSetKt;
import io.kotest.assertions.print.PrintKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\tJ*\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J*\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00122\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J6\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00152\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00122\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0016\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/kotest/assertions/eq/IterableEq;", "Lio/kotest/assertions/eq/Eq;", "", "()V", "disallowed", "", "trigger", "asIterable", "it", "", "checkEquality", "", "actual", "expected", "strictNumberEq", "", "checkIterableCompatibility", "checkSetEquality", "", "equals", "equalsIgnoringOrder", "Lkotlin/Pair;", "errorWithTypeDetails", "generateError", "isValidIterable", "kotest-assertions-shared"})
@SourceDebugExtension(value={"SMAP\nIterableEq.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IterableEq.kt\nio/kotest/assertions/eq/IterableEq\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1726#2,2:225\n1747#2,3:227\n1747#2,3:230\n1747#2,3:233\n1747#2,3:236\n1728#2:239\n1#3:240\n*S KotlinDebug\n*F\n+ 1 IterableEq.kt\nio/kotest/assertions/eq/IterableEq\n*L\n105#1:225,2\n109#1:227,3\n112#1:230,3\n115#1:233,3\n120#1:236,3\n105#1:239\n*E\n"})
public final class IterableEq
implements Eq<Iterable<?>> {
    @NotNull
    public static final IterableEq INSTANCE = new IterableEq();
    @NotNull
    public static final String trigger = "Disallowed";
    @NotNull
    private static final String disallowed = "Disallowed nesting iterator";

    private IterableEq() {
    }

    public final boolean isValidIterable(@NotNull Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it;
        return object instanceof String ? false : (((object instanceof List ? true : object instanceof Set) ? true : object instanceof Object[]) ? true : object instanceof Collection);
    }

    @NotNull
    public final Iterable<?> asIterable(@NotNull Object it) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!(!(it instanceof String))) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        Object object = it;
        if (object instanceof Object[]) {
            iterable = ArraysKt.asList((Object[])((Object[])it));
        } else if (object instanceof List) {
            iterable = (Iterable)it;
        } else if (object instanceof Set) {
            iterable = (Iterable)it;
        } else if (object instanceof Collection) {
            iterable = (Iterable)it;
        } else {
            throw new IllegalStateException(("Cannot convert " + it + " to Iterable<*>").toString());
        }
        return iterable;
    }

    @Override
    @Nullable
    public Throwable equals(@NotNull Iterable<?> actual, @NotNull Iterable<?> expected, boolean strictNumberEq) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        if (actual instanceof Set && expected instanceof Set) {
            throwable = this.checkSetEquality((Set)actual, (Set)expected, strictNumberEq);
        } else if (IsOrderedSetKt.isOrderedSet(actual) || IsOrderedSetKt.isOrderedSet(expected)) {
            throwable = this.checkIterableCompatibility(actual, expected);
            if (throwable == null) {
                throwable = this.checkEquality(actual, expected, strictNumberEq);
            }
        } else if (actual instanceof Set || expected instanceof Set) {
            throwable = this.errorWithTypeDetails(actual, expected);
        } else {
            throwable = this.checkIterableCompatibility(actual, expected);
            if (throwable == null) {
                throwable = this.checkEquality(actual, expected, strictNumberEq);
            }
        }
        return throwable;
    }

    private final Throwable checkSetEquality(Set<?> actual, Set<?> expected, boolean strictNumberEq) {
        Throwable throwable;
        if (actual.size() != expected.size()) {
            throwable = this.generateError(actual, expected);
        } else {
            Pair<Boolean, Throwable> pair = this.equalsIgnoringOrder(actual, expected, strictNumberEq);
            boolean isEqual = (Boolean)pair.component1();
            Throwable innerError = (Throwable)pair.component2();
            throwable = innerError;
            if (throwable == null) {
                throwable = isEqual ? null : this.generateError(actual, expected);
            }
        }
        return throwable;
    }

    private final Throwable checkIterableCompatibility(Iterable<?> actual, Iterable<?> expected) {
        boolean isCompatible = (actual instanceof Collection || actual instanceof Object[]) && expected instanceof Collection || expected instanceof Object[] || Reflection.getOrCreateKotlinClass(actual.getClass()).isInstance(expected) && Reflection.getOrCreateKotlinClass(expected.getClass()).isInstance(actual);
        return isCompatible ? null : this.errorWithTypeDetails(actual, expected);
    }

    private final Pair<Boolean, Throwable> equalsIgnoringOrder(Set<?> actual, Set<?> expected, boolean strictNumberEq) {
        boolean bl;
        Ref.ObjectRef innerError;
        block24: {
            innerError = new Ref.ObjectRef();
            Iterable $this$all$iv = actual;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    boolean bl2;
                    block23: {
                        Object it;
                        Object element$iv;
                        Iterator iterator2;
                        boolean $i$f$any;
                        Iterable $this$any$iv;
                        Object element$iv2;
                        Object elementInActualSet = element$iv2 = iterator.next();
                        boolean bl3 = false;
                        Object t = elementInActualSet;
                        if (t instanceof Set) {
                            $this$any$iv = expected;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                iterator2 = $this$any$iv.iterator();
                                while (iterator2.hasNext()) {
                                    it = element$iv = iterator2.next();
                                    boolean bl4 = false;
                                    if (!(it instanceof Set && IterableEq.equalsIgnoringOrder$equalWithDetection(strictNumberEq, (Ref.ObjectRef<Throwable>)innerError, elementInActualSet, it))) continue;
                                    bl2 = true;
                                    break block23;
                                }
                                bl2 = false;
                            }
                        } else if (t instanceof Map) {
                            $this$any$iv = expected;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                iterator2 = $this$any$iv.iterator();
                                while (iterator2.hasNext()) {
                                    it = element$iv = iterator2.next();
                                    boolean bl5 = false;
                                    if (!(it instanceof Map && IterableEq.equalsIgnoringOrder$equalWithDetection(strictNumberEq, (Ref.ObjectRef<Throwable>)innerError, elementInActualSet, it))) continue;
                                    bl2 = true;
                                    break block23;
                                }
                                bl2 = false;
                            }
                        } else if (t instanceof Collection ? true : t instanceof Object[]) {
                            $this$any$iv = expected;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                iterator2 = $this$any$iv.iterator();
                                while (iterator2.hasNext()) {
                                    it = element$iv = iterator2.next();
                                    boolean bl6 = false;
                                    boolean bl7 = !(it instanceof Set) && (it instanceof Collection || it instanceof Object[]) && IterableEq.equalsIgnoringOrder$equalWithDetection(strictNumberEq, (Ref.ObjectRef<Throwable>)innerError, elementInActualSet, it);
                                    if (!bl7) continue;
                                    bl2 = true;
                                    break block23;
                                }
                                bl2 = false;
                            }
                        } else if (t instanceof Iterable) {
                            $this$any$iv = expected;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                iterator2 = $this$any$iv.iterator();
                                while (iterator2.hasNext()) {
                                    it = element$iv = iterator2.next();
                                    boolean bl8 = false;
                                    boolean bl9 = !(it instanceof Set) && !(it instanceof Collection) && !(it instanceof Object[]) && it instanceof Iterable && IterableEq.equalsIgnoringOrder$equalWithDetection(strictNumberEq, (Ref.ObjectRef<Throwable>)innerError, elementInActualSet, it);
                                    if (!bl9) continue;
                                    bl2 = true;
                                    break block23;
                                }
                                bl2 = false;
                            }
                        } else {
                            bl2 = CollectionsKt.contains((Iterable)expected, elementInActualSet);
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break block24;
                }
                bl = true;
            }
        }
        Object object = innerError.element;
        Boolean bl10 = bl;
        return new Pair((Object)bl10, object);
    }

    private final Throwable errorWithTypeDetails(Iterable<?> actual, Iterable<?> expected) {
        String string;
        String string2;
        String actualTypeName;
        String string3 = Reflection.getOrCreateKotlinClass(actual.getClass()).getSimpleName();
        if (string3 == null) {
            string3 = actualTypeName = Reflection.getOrCreateKotlinClass(actual.getClass());
        }
        if ((string2 = Reflection.getOrCreateKotlinClass(expected.getClass()).getSimpleName()) == null) {
            string2 = Reflection.getOrCreateKotlinClass(expected.getClass());
        }
        String expectedTypeName = string2;
        String tag = actualTypeName + " with " + expectedTypeName + '\n';
        if (actual instanceof Set || expected instanceof Set) {
            Pair pair = actual instanceof Set ? TuplesKt.to((Object)actualTypeName, (Object)expectedTypeName) : TuplesKt.to((Object)expectedTypeName, (Object)actualTypeName);
            Object setType = pair.component1();
            Object nonSetType = pair.component2();
            string = "Disallowed: Sets can only be compared to sets, unless both types provide a stable iteration order.\n" + setType + " does not provide a stable iteration order and was compared with " + nonSetType + " which is not a Set";
        } else {
            string = actual instanceof Collection || actual instanceof Object[] || expected instanceof Collection || expected instanceof Object[] ? "Disallowed typed contract\nMay not compare " + tag : "Disallowed promiscuous iterators\nMay not compare " + tag;
        }
        String detailErrorMessage = string;
        return (Throwable)((Object)FailuresKt.failure(detailErrorMessage));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Throwable checkEquality(Iterable<?> actual, Iterable<?> expected, boolean strictNumberEq) {
        Throwable throwable;
        StringBuilder stringBuilder;
        Iterator<?> iter1 = actual.iterator();
        Iterator<?> iter2 = expected.iterator();
        List elementDifferAtIndex = new ArrayList();
        Ref.ObjectRef nestedIteratorError = new Ref.ObjectRef();
        Ref.BooleanRef accrueDetails = new Ref.BooleanRef();
        accrueDetails.element = true;
        int index = 0;
        Integer unexpectedElementAtIndex = null;
        Integer missingElementAt = null;
        while (iter1.hasNext()) {
            Object a = iter1.next();
            if (iter2.hasNext()) {
                Throwable t;
                Throwable throwable2;
                Object b = iter2.next();
                Object obj = a;
                boolean bl = obj != null ? obj.equals(b) : false;
                if (bl) {
                    throwable2 = null;
                } else {
                    boolean bl2;
                    String it;
                    if (IterableEq.checkEquality$nestedIterator(a, actual) != null) {
                        boolean bl3 = false;
                        bl2 = IterableEq.checkEquality$setDisallowedState((Ref.ObjectRef<String>)nestedIteratorError, accrueDetails, it);
                    } else {
                        bl2 = false;
                    }
                    if (bl2) {
                        Object object = nestedIteratorError.element;
                        Intrinsics.checkNotNull((Object)object);
                        throwable2 = (Throwable)((Object)FailuresKt.failure((String)object));
                    } else {
                        boolean bl4;
                        if (IterableEq.checkEquality$nestedIterator(b, expected) != null) {
                            boolean bl5 = false;
                            bl4 = IterableEq.checkEquality$setDisallowedState((Ref.ObjectRef<String>)nestedIteratorError, accrueDetails, it);
                        } else {
                            bl4 = false;
                        }
                        if (bl4) {
                            Object object = nestedIteratorError.element;
                            Intrinsics.checkNotNull((Object)object);
                            throwable2 = (Throwable)((Object)FailuresKt.failure((String)object));
                        } else {
                            throwable2 = t = IterableEq.checkEquality$equalXorDisallowed((Ref.ObjectRef<String>)nestedIteratorError, accrueDetails, EqKt.eq(a, b, strictNumberEq));
                        }
                    }
                }
                if (!accrueDetails.element) break;
                if (t != null) {
                    elementDifferAtIndex.add(index);
                }
            } else {
                unexpectedElementAtIndex = index;
            }
            ++index;
        }
        if (iter2.hasNext() && accrueDetails.element) {
            missingElementAt = index;
        }
        StringBuilder $this$checkEquality_u24lambda_u2410 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!((Collection)elementDifferAtIndex).isEmpty()) {
            $this$checkEquality_u24lambda_u2410.append("Element differ at index: " + PrintKt.print(elementDifferAtIndex).getValue() + '\n');
        }
        if (unexpectedElementAtIndex != null) {
            $this$checkEquality_u24lambda_u2410.append("Unexpected elements from index " + unexpectedElementAtIndex + '\n');
        }
        if (missingElementAt != null) {
            $this$checkEquality_u24lambda_u2410.append("Missing elements from index " + missingElementAt + '\n');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String detailErrorMessage = string;
        Object object = (String)nestedIteratorError.element;
        if (object != null) {
            String it = object;
            boolean bl6 = false;
            AssertionError assertionError = FailuresKt.failure(it);
            object = assertionError;
            if (assertionError != null) {
                throwable = (Throwable)object;
                return throwable;
            }
        }
        if (StringsKt.isBlank((CharSequence)detailErrorMessage)) return null;
        boolean bl7 = true;
        if (!bl7) return null;
        throwable = FailuresKt.failure(new Expected(PrintKt.print(expected)), new Actual(PrintKt.print(actual)), detailErrorMessage);
        return throwable;
    }

    private final Throwable generateError(Object actual, Object expected) {
        return FailuresKt.failure$default(new Expected(PrintKt.print(expected)), new Actual(PrintKt.print(actual)), null, 4, null);
    }

    @Override
    @Nullable
    public Throwable equals(@NotNull Iterable<?> actual, @NotNull Iterable<?> expected) {
        return Eq.DefaultImpls.equals(this, actual, expected);
    }

    private static final boolean equalsIgnoringOrder$equalWithDetection(boolean $strictNumberEq, Ref.ObjectRef<Throwable> innerError, Object elementInActualSet, Object it) {
        boolean bl;
        Throwable throwable = EqKt.eq(elementInActualSet, it, $strictNumberEq);
        if (throwable != null) {
            Throwable it2 = throwable;
            boolean bl2 = false;
            if (innerError.element == null) {
                String string = it2.getMessage();
                boolean bl3 = string != null ? StringsKt.startsWith$default((String)string, (String)trigger, (boolean)false, (int)2, null) : false;
                if (bl3) {
                    innerError.element = it2;
                }
            }
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private static final <T> String checkEquality$nestedIterator(T item, Iterable<?> oracle) {
        String string;
        T t = item;
        if (t != null) {
            T it = t;
            boolean bl = false;
            if (it instanceof Iterable && !(it instanceof Collection) && (Reflection.getOrCreateKotlinClass(it.getClass()).isInstance(oracle) || Reflection.getOrCreateKotlinClass(oracle.getClass()).isInstance(it))) {
                StringBuilder stringBuilder = new StringBuilder().append("Disallowed nesting iterator ").append(it).append(" (");
                String string2 = Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName();
                if (string2 == null) {
                    string2 = "anonymous";
                }
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append(") within ").append(oracle).append(" (");
                String string3 = Reflection.getOrCreateKotlinClass(oracle.getClass()).getSimpleName();
                if (string3 == null) {
                    string3 = "anonymous";
                }
                string = stringBuilder2.append(string3).append("); (use custom test code instead)").toString();
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    private static final boolean checkEquality$setDisallowedState(Ref.ObjectRef<String> nestedIteratorError, Ref.BooleanRef accrueDetails, String disallowedMsg) {
        nestedIteratorError.element = disallowedMsg;
        accrueDetails.element = false;
        return true;
    }

    private static final Throwable checkEquality$equalXorDisallowed(Ref.ObjectRef<String> nestedIteratorError, Ref.BooleanRef accrueDetails, Throwable signal) {
        Throwable throwable;
        Throwable throwable2 = signal;
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            String string = it.getMessage();
            boolean bl2 = string != null ? StringsKt.startsWith$default((String)string, (String)disallowed, (boolean)false, (int)2, null) : false;
            if (bl2) {
                String string2 = it.getMessage();
                Intrinsics.checkNotNull((Object)string2);
                IterableEq.checkEquality$setDisallowedState(nestedIteratorError, accrueDetails, string2);
                Object object = nestedIteratorError.element;
                Intrinsics.checkNotNull((Object)object);
                throwable = (Throwable)((Object)FailuresKt.failure((String)object));
            } else {
                throwable = it;
            }
        } else {
            throwable = null;
        }
        return throwable;
    }
}

