/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.server.sessions.SessionTransportTransformer;
import io.ktor.util.CryptoKt;
import java.nio.charset.Charset;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001a\u0018\u0000 -2\u00020\u0001:\u0001-BP\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012#\b\u0002\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eBN\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012#\b\u0002\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0018\u0010#\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0002J \u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H\u0002J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\f2\u0006\u0010+\u001a\u00020\fH\u0016J\u0010\u0010,\u001a\u00020\f2\u0006\u0010+\u001a\u00020\fH\u0016R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR,\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R\u0011\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001b\u00a8\u0006."}, d2={"Lio/ktor/server/sessions/SessionTransportTransformerEncrypt;", "Lio/ktor/server/sessions/SessionTransportTransformer;", "encryptionKey", "", "signKey", "ivGenerator", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "size", "encryptAlgorithm", "", "signAlgorithm", "([B[BLkotlin/jvm/functions/Function1;Ljava/lang/String;Ljava/lang/String;)V", "encryptionKeySpec", "Ljavax/crypto/spec/SecretKeySpec;", "signKeySpec", "(Ljavax/crypto/spec/SecretKeySpec;Ljavax/crypto/spec/SecretKeySpec;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Ljava/lang/String;)V", "charset", "Ljava/nio/charset/Charset;", "getEncryptAlgorithm", "()Ljava/lang/String;", "encryptionKeySize", "getEncryptionKeySize", "()I", "getEncryptionKeySpec", "()Ljavax/crypto/spec/SecretKeySpec;", "getIvGenerator", "()Lkotlin/jvm/functions/Function1;", "getSignAlgorithm", "getSignKeySpec", "decrypt", "initVector", "encrypted", "encrypt", "decrypted", "encryptDecrypt", "mode", "input", "mac", "value", "transformRead", "transportValue", "transformWrite", "Companion", "ktor-server-sessions"})
public final class SessionTransportTransformerEncrypt
implements SessionTransportTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SecretKeySpec encryptionKeySpec;
    @NotNull
    private final SecretKeySpec signKeySpec;
    @NotNull
    private final Function1<Integer, byte[]> ivGenerator;
    @NotNull
    private final String encryptAlgorithm;
    @NotNull
    private final String signAlgorithm;
    @NotNull
    private final Charset charset;
    private static final Logger log = LoggerFactory.getLogger((String)Reflection.getOrCreateKotlinClass(SessionTransportTransformerEncrypt.class).getQualifiedName());

    public SessionTransportTransformerEncrypt(@NotNull SecretKeySpec encryptionKeySpec, @NotNull SecretKeySpec signKeySpec, @NotNull Function1<? super Integer, byte[]> ivGenerator, @NotNull String encryptAlgorithm, @NotNull String signAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)encryptionKeySpec, (String)"encryptionKeySpec");
        Intrinsics.checkNotNullParameter((Object)signKeySpec, (String)"signKeySpec");
        Intrinsics.checkNotNullParameter(ivGenerator, (String)"ivGenerator");
        Intrinsics.checkNotNullParameter((Object)encryptAlgorithm, (String)"encryptAlgorithm");
        Intrinsics.checkNotNullParameter((Object)signAlgorithm, (String)"signAlgorithm");
        this.encryptionKeySpec = encryptionKeySpec;
        this.signKeySpec = signKeySpec;
        this.ivGenerator = ivGenerator;
        this.encryptAlgorithm = encryptAlgorithm;
        this.signAlgorithm = signAlgorithm;
        this.charset = Charsets.UTF_8;
        this.encrypt((byte[])this.ivGenerator.invoke((Object)this.getEncryptionKeySize()), new byte[0]);
        this.mac(new byte[0]);
    }

    public /* synthetic */ SessionTransportTransformerEncrypt(SecretKeySpec secretKeySpec, SecretKeySpec secretKeySpec2, Function1 function1, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            String string3 = secretKeySpec.getAlgorithm();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encryptionKeySpec.algorithm");
            string = string3;
        }
        if ((n & 0x10) != 0) {
            String string4 = secretKeySpec2.getAlgorithm();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"signKeySpec.algorithm");
            string2 = string4;
        }
        this(secretKeySpec, secretKeySpec2, (Function1<? super Integer, byte[]>)function1, string, string2);
    }

    @NotNull
    public final SecretKeySpec getEncryptionKeySpec() {
        return this.encryptionKeySpec;
    }

    @NotNull
    public final SecretKeySpec getSignKeySpec() {
        return this.signKeySpec;
    }

    @NotNull
    public final Function1<Integer, byte[]> getIvGenerator() {
        return this.ivGenerator;
    }

    @NotNull
    public final String getEncryptAlgorithm() {
        return this.encryptAlgorithm;
    }

    @NotNull
    public final String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public final int getEncryptionKeySize() {
        return this.encryptionKeySpec.getEncoded().length;
    }

    public SessionTransportTransformerEncrypt(@NotNull byte[] encryptionKey, @NotNull byte[] signKey, @NotNull Function1<? super Integer, byte[]> ivGenerator, @NotNull String encryptAlgorithm, @NotNull String signAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
        Intrinsics.checkNotNullParameter((Object)signKey, (String)"signKey");
        Intrinsics.checkNotNullParameter(ivGenerator, (String)"ivGenerator");
        Intrinsics.checkNotNullParameter((Object)encryptAlgorithm, (String)"encryptAlgorithm");
        Intrinsics.checkNotNullParameter((Object)signAlgorithm, (String)"signAlgorithm");
        this(new SecretKeySpec(encryptionKey, encryptAlgorithm), new SecretKeySpec(signKey, signAlgorithm), ivGenerator, null, null, 24, null);
    }

    public /* synthetic */ SessionTransportTransformerEncrypt(byte[] byArray, byte[] byArray2, Function1 function1, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 2.INSTANCE;
        }
        if ((n & 8) != 0) {
            string = "AES";
        }
        if ((n & 0x10) != 0) {
            string2 = "HmacSHA256";
        }
        this(byArray, byArray2, (Function1<? super Integer, byte[]>)function1, string, string2);
    }

    @Override
    @Nullable
    public String transformRead(@NotNull String transportValue) {
        Intrinsics.checkNotNullParameter((Object)transportValue, (String)"transportValue");
        try {
            String encryptedMac = StringsKt.substringAfterLast((String)transportValue, (char)'/', (String)"");
            byte[] iv = CryptoKt.hex((String)StringsKt.substringBeforeLast$default((String)transportValue, (char)'/', null, (int)2, null));
            byte[] encrypted = CryptoKt.hex((String)StringsKt.substringBeforeLast$default((String)encryptedMac, (char)':', null, (int)2, null));
            String macHex = StringsKt.substringAfterLast((String)encryptedMac, (char)':', (String)"");
            byte[] decrypted = this.decrypt(iv, encrypted);
            if (!Intrinsics.areEqual((Object)CryptoKt.hex((byte[])this.mac(decrypted)), (Object)macHex)) {
                return null;
            }
            return new String(decrypted, this.charset);
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug(e.toString());
            }
            return null;
        }
    }

    @Override
    @NotNull
    public String transformWrite(@NotNull String transportValue) {
        Intrinsics.checkNotNullParameter((Object)transportValue, (String)"transportValue");
        byte[] iv = (byte[])this.ivGenerator.invoke((Object)this.getEncryptionKeySize());
        byte[] byArray = transportValue.getBytes(this.charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] decrypted = byArray;
        byte[] encrypted = this.encrypt(iv, decrypted);
        byte[] mac = this.mac(decrypted);
        return CryptoKt.hex((byte[])iv) + '/' + CryptoKt.hex((byte[])encrypted) + ':' + CryptoKt.hex((byte[])mac);
    }

    private final byte[] encrypt(byte[] initVector, byte[] decrypted) {
        return this.encryptDecrypt(1, initVector, decrypted);
    }

    private final byte[] decrypt(byte[] initVector, byte[] encrypted) {
        return this.encryptDecrypt(2, initVector, encrypted);
    }

    private final byte[] encryptDecrypt(int mode, byte[] initVector, byte[] input) {
        IvParameterSpec iv = new IvParameterSpec(initVector);
        Cipher cipher = Cipher.getInstance(this.encryptAlgorithm + "/CBC/PKCS5PADDING");
        cipher.init(mode, (Key)this.encryptionKeySpec, iv);
        byte[] byArray = cipher.doFinal(input);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(input)");
        return byArray;
    }

    private final byte[] mac(byte[] value) {
        Mac $this$mac_u24lambda_u240 = Mac.getInstance(this.signAlgorithm);
        boolean bl = false;
        $this$mac_u24lambda_u240.init(this.signKeySpec);
        byte[] byArray = $this$mac_u24lambda_u240.doFinal(value);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(signAlgorith\u2026     doFinal(value)\n    }");
        return byArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/ktor/server/sessions/SessionTransportTransformerEncrypt$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ktor-server-sessions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

