/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time. How often to update the EventSeries is up to the event reporters. The default event reporter in \"k8s.io/client-go/tools/events/event_broadcaster.go\" shows how this struct is updated on heartbeats and can guide customized reporter implementations.")
public class EventsV1EventSeries {
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count;
    public static final String SERIALIZED_NAME_LAST_OBSERVED_TIME = "lastObservedTime";
    @SerializedName(value="lastObservedTime")
    private DateTime lastObservedTime;

    public EventsV1EventSeries count(Integer count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(required=true, value="count is the number of occurrences in this series up to the last heartbeat time.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public EventsV1EventSeries lastObservedTime(DateTime lastObservedTime) {
        this.lastObservedTime = lastObservedTime;
        return this;
    }

    @ApiModelProperty(required=true, value="lastObservedTime is the time when last Event from the series was seen before last heartbeat.")
    public DateTime getLastObservedTime() {
        return this.lastObservedTime;
    }

    public void setLastObservedTime(DateTime lastObservedTime) {
        this.lastObservedTime = lastObservedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventsV1EventSeries eventsV1EventSeries = (EventsV1EventSeries)o;
        return Objects.equals(this.count, eventsV1EventSeries.count) && Objects.equals(this.lastObservedTime, eventsV1EventSeries.lastObservedTime);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.lastObservedTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventsV1EventSeries {\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    lastObservedTime: ").append(this.toIndentedString(this.lastObservedTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

