/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import io.kubernetes.client.openapi.models.V1APIResource;
import io.kubernetes.client.openapi.models.V1APIResourceFluent;
import io.kubernetes.client.openapi.models.V1APIResourceFluentImpl;
import java.util.Objects;

public class V1APIResourceBuilder
extends V1APIResourceFluentImpl<V1APIResourceBuilder>
implements VisitableBuilder<V1APIResource, V1APIResourceBuilder> {
    V1APIResourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1APIResourceBuilder() {
        this(true);
    }

    public V1APIResourceBuilder(Boolean validationEnabled) {
        this(new V1APIResource(), validationEnabled);
    }

    public V1APIResourceBuilder(V1APIResourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public V1APIResourceBuilder(V1APIResourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new V1APIResource(), validationEnabled);
    }

    public V1APIResourceBuilder(V1APIResourceFluent<?> fluent, V1APIResource instance) {
        this(fluent, instance, true);
    }

    public V1APIResourceBuilder(V1APIResourceFluent<?> fluent, V1APIResource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCategories(instance.getCategories());
        fluent.withGroup(instance.getGroup());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withNamespaced(instance.getNamespaced());
        fluent.withShortNames(instance.getShortNames());
        fluent.withSingularName(instance.getSingularName());
        fluent.withStorageVersionHash(instance.getStorageVersionHash());
        fluent.withVerbs(instance.getVerbs());
        fluent.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    public V1APIResourceBuilder(V1APIResource instance) {
        this(instance, (Boolean)true);
    }

    public V1APIResourceBuilder(V1APIResource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCategories(instance.getCategories());
        this.withGroup(instance.getGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withNamespaced(instance.getNamespaced());
        this.withShortNames(instance.getShortNames());
        this.withSingularName(instance.getSingularName());
        this.withStorageVersionHash(instance.getStorageVersionHash());
        this.withVerbs(instance.getVerbs());
        this.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public V1APIResource build() {
        V1APIResource buildable = new V1APIResource();
        buildable.setCategories(this.fluent.getCategories());
        buildable.setGroup(this.fluent.getGroup());
        buildable.setKind(this.fluent.getKind());
        buildable.setName(this.fluent.getName());
        buildable.setNamespaced(this.fluent.isNamespaced());
        buildable.setShortNames(this.fluent.getShortNames());
        buildable.setSingularName(this.fluent.getSingularName());
        buildable.setStorageVersionHash(this.fluent.getStorageVersionHash());
        buildable.setVerbs(this.fluent.getVerbs());
        buildable.setVersion(this.fluent.getVersion());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1APIResourceBuilder that = (V1APIResourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

