/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import io.kubernetes.client.openapi.models.V1NodeSystemInfo;
import io.kubernetes.client.openapi.models.V1NodeSystemInfoFluent;
import io.kubernetes.client.openapi.models.V1NodeSystemInfoFluentImpl;
import java.util.Objects;

public class V1NodeSystemInfoBuilder
extends V1NodeSystemInfoFluentImpl<V1NodeSystemInfoBuilder>
implements VisitableBuilder<V1NodeSystemInfo, V1NodeSystemInfoBuilder> {
    V1NodeSystemInfoFluent<?> fluent;
    Boolean validationEnabled;

    public V1NodeSystemInfoBuilder() {
        this(true);
    }

    public V1NodeSystemInfoBuilder(Boolean validationEnabled) {
        this(new V1NodeSystemInfo(), validationEnabled);
    }

    public V1NodeSystemInfoBuilder(V1NodeSystemInfoFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public V1NodeSystemInfoBuilder(V1NodeSystemInfoFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new V1NodeSystemInfo(), validationEnabled);
    }

    public V1NodeSystemInfoBuilder(V1NodeSystemInfoFluent<?> fluent, V1NodeSystemInfo instance) {
        this(fluent, instance, true);
    }

    public V1NodeSystemInfoBuilder(V1NodeSystemInfoFluent<?> fluent, V1NodeSystemInfo instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withArchitecture(instance.getArchitecture());
        fluent.withBootID(instance.getBootID());
        fluent.withContainerRuntimeVersion(instance.getContainerRuntimeVersion());
        fluent.withKernelVersion(instance.getKernelVersion());
        fluent.withKubeProxyVersion(instance.getKubeProxyVersion());
        fluent.withKubeletVersion(instance.getKubeletVersion());
        fluent.withMachineID(instance.getMachineID());
        fluent.withOperatingSystem(instance.getOperatingSystem());
        fluent.withOsImage(instance.getOsImage());
        fluent.withSystemUUID(instance.getSystemUUID());
        this.validationEnabled = validationEnabled;
    }

    public V1NodeSystemInfoBuilder(V1NodeSystemInfo instance) {
        this(instance, (Boolean)true);
    }

    public V1NodeSystemInfoBuilder(V1NodeSystemInfo instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withArchitecture(instance.getArchitecture());
        this.withBootID(instance.getBootID());
        this.withContainerRuntimeVersion(instance.getContainerRuntimeVersion());
        this.withKernelVersion(instance.getKernelVersion());
        this.withKubeProxyVersion(instance.getKubeProxyVersion());
        this.withKubeletVersion(instance.getKubeletVersion());
        this.withMachineID(instance.getMachineID());
        this.withOperatingSystem(instance.getOperatingSystem());
        this.withOsImage(instance.getOsImage());
        this.withSystemUUID(instance.getSystemUUID());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public V1NodeSystemInfo build() {
        V1NodeSystemInfo buildable = new V1NodeSystemInfo();
        buildable.setArchitecture(this.fluent.getArchitecture());
        buildable.setBootID(this.fluent.getBootID());
        buildable.setContainerRuntimeVersion(this.fluent.getContainerRuntimeVersion());
        buildable.setKernelVersion(this.fluent.getKernelVersion());
        buildable.setKubeProxyVersion(this.fluent.getKubeProxyVersion());
        buildable.setKubeletVersion(this.fluent.getKubeletVersion());
        buildable.setMachineID(this.fluent.getMachineID());
        buildable.setOperatingSystem(this.fluent.getOperatingSystem());
        buildable.setOsImage(this.fluent.getOsImage());
        buildable.setSystemUUID(this.fluent.getSystemUUID());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NodeSystemInfoBuilder that = (V1NodeSystemInfoBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

