/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="JobSpec describes how the job execution will look like.")
public class V1JobSpec {
    public static final String SERIALIZED_NAME_ACTIVE_DEADLINE_SECONDS = "activeDeadlineSeconds";
    @SerializedName(value="activeDeadlineSeconds")
    private Long activeDeadlineSeconds;
    public static final String SERIALIZED_NAME_BACKOFF_LIMIT = "backoffLimit";
    @SerializedName(value="backoffLimit")
    private Integer backoffLimit;
    public static final String SERIALIZED_NAME_COMPLETION_MODE = "completionMode";
    @SerializedName(value="completionMode")
    private String completionMode;
    public static final String SERIALIZED_NAME_COMPLETIONS = "completions";
    @SerializedName(value="completions")
    private Integer completions;
    public static final String SERIALIZED_NAME_MANUAL_SELECTOR = "manualSelector";
    @SerializedName(value="manualSelector")
    private Boolean manualSelector;
    public static final String SERIALIZED_NAME_PARALLELISM = "parallelism";
    @SerializedName(value="parallelism")
    private Integer parallelism;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private V1LabelSelector selector;
    public static final String SERIALIZED_NAME_SUSPEND = "suspend";
    @SerializedName(value="suspend")
    private Boolean suspend;
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    private V1PodTemplateSpec template;
    public static final String SERIALIZED_NAME_TTL_SECONDS_AFTER_FINISHED = "ttlSecondsAfterFinished";
    @SerializedName(value="ttlSecondsAfterFinished")
    private Integer ttlSecondsAfterFinished;

    public V1JobSpec activeDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it; value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again.")
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public void setActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
    }

    public V1JobSpec backoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the number of retries before marking this job failed. Defaults to 6")
    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    public void setBackoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
    }

    public V1JobSpec completionMode(String completionMode) {
        this.completionMode = completionMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CompletionMode specifies how Pod completions are tracked. It can be `NonIndexed` (default) or `Indexed`.  `NonIndexed` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other.  `Indexed` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is `Indexed`, .spec.completions must be specified and `.spec.parallelism` must be less than or equal to 10^5. In addition, The Pod name takes the form `$(job-name)-$(index)-$(random-string)`, the Pod hostname takes the form `$(job-name)-$(index)`.  This field is beta-level. More completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, the controller skips updates for the Job.")
    public String getCompletionMode() {
        return this.completionMode;
    }

    public void setCompletionMode(String completionMode) {
        this.completionMode = completionMode;
    }

    public V1JobSpec completions(Integer completions) {
        this.completions = completions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the desired number of successfully finished pods the job should be run with.  Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/")
    public Integer getCompletions() {
        return this.completions;
    }

    public void setCompletions(Integer completions) {
        this.completions = completions;
    }

    public V1JobSpec manualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="manualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector")
    public Boolean getManualSelector() {
        return this.manualSelector;
    }

    public void setManualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
    }

    public V1JobSpec parallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/")
    public Integer getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    public V1JobSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1JobSpec suspend(Boolean suspend) {
        this.suspend = suspend;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Suspend specifies whether the Job controller should create Pods or not. If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. Defaults to false.  This field is beta-level, gated by SuspendJob feature flag (enabled by default).")
    public Boolean getSuspend() {
        return this.suspend;
    }

    public void setSuspend(Boolean suspend) {
        this.suspend = suspend;
    }

    public V1JobSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public V1JobSpec ttlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.")
    public Integer getTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished;
    }

    public void setTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1JobSpec v1JobSpec = (V1JobSpec)o;
        return Objects.equals(this.activeDeadlineSeconds, v1JobSpec.activeDeadlineSeconds) && Objects.equals(this.backoffLimit, v1JobSpec.backoffLimit) && Objects.equals(this.completionMode, v1JobSpec.completionMode) && Objects.equals(this.completions, v1JobSpec.completions) && Objects.equals(this.manualSelector, v1JobSpec.manualSelector) && Objects.equals(this.parallelism, v1JobSpec.parallelism) && Objects.equals(this.selector, v1JobSpec.selector) && Objects.equals(this.suspend, v1JobSpec.suspend) && Objects.equals(this.template, v1JobSpec.template) && Objects.equals(this.ttlSecondsAfterFinished, v1JobSpec.ttlSecondsAfterFinished);
    }

    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.backoffLimit, this.completionMode, this.completions, this.manualSelector, this.parallelism, this.selector, this.suspend, this.template, this.ttlSecondsAfterFinished);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1JobSpec {\n");
        sb.append("    activeDeadlineSeconds: ").append(this.toIndentedString(this.activeDeadlineSeconds)).append("\n");
        sb.append("    backoffLimit: ").append(this.toIndentedString(this.backoffLimit)).append("\n");
        sb.append("    completionMode: ").append(this.toIndentedString(this.completionMode)).append("\n");
        sb.append("    completions: ").append(this.toIndentedString(this.completions)).append("\n");
        sb.append("    manualSelector: ").append(this.toIndentedString(this.manualSelector)).append("\n");
        sb.append("    parallelism: ").append(this.toIndentedString(this.parallelism)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    suspend: ").append(this.toIndentedString(this.suspend)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    ttlSecondsAfterFinished: ").append(this.toIndentedString(this.ttlSecondsAfterFinished)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

