/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="SelectableField specifies the JSON path of a field that may be used with field selectors.")
public class V1SelectableField {
    public static final String SERIALIZED_NAME_JSON_PATH = "jsonPath";
    @SerializedName(value="jsonPath")
    private String jsonPath;

    public V1SelectableField jsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
        return this;
    }

    @ApiModelProperty(required=true, value="jsonPath is a simple JSON path which is evaluated against each custom resource to produce a field selector value. Only JSON paths without the array notation are allowed. Must point to a field of type string, boolean or integer. Types with enum values and strings with formats are allowed. If jsonPath refers to absent field in a resource, the jsonPath evaluates to an empty string. Must not point to metdata fields. Required.")
    public String getJsonPath() {
        return this.jsonPath;
    }

    public void setJsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SelectableField v1SelectableField = (V1SelectableField)o;
        return Objects.equals(this.jsonPath, v1SelectableField.jsonPath);
    }

    public int hashCode() {
        return Objects.hash(this.jsonPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1SelectableField {\n");
        sb.append("    jsonPath: ").append(this.toIndentedString(this.jsonPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

