/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassParametersReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceClass is used by administrators to influence how resources are allocated.  This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.")
public class V1alpha2ResourceClass
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_DRIVER_NAME = "driverName";
    @SerializedName(value="driverName")
    private String driverName;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_PARAMETERS_REF = "parametersRef";
    @SerializedName(value="parametersRef")
    private V1alpha2ResourceClassParametersReference parametersRef;
    public static final String SERIALIZED_NAME_STRUCTURED_PARAMETERS = "structuredParameters";
    @SerializedName(value="structuredParameters")
    private Boolean structuredParameters;
    public static final String SERIALIZED_NAME_SUITABLE_NODES = "suitableNodes";
    @SerializedName(value="suitableNodes")
    private V1NodeSelector suitableNodes;

    public V1alpha2ResourceClass apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1alpha2ResourceClass driverName(String driverName) {
        this.driverName = driverName;
        return this;
    }

    @ApiModelProperty(required=true, value="DriverName defines the name of the dynamic resource driver that is used for allocation of a ResourceClaim that uses this class.  Resource drivers have a unique name in forward domain order (acme.example.com).")
    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public V1alpha2ResourceClass kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1alpha2ResourceClass metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1alpha2ResourceClass parametersRef(V1alpha2ResourceClassParametersReference parametersRef) {
        this.parametersRef = parametersRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha2ResourceClassParametersReference getParametersRef() {
        return this.parametersRef;
    }

    public void setParametersRef(V1alpha2ResourceClassParametersReference parametersRef) {
        this.parametersRef = parametersRef;
    }

    public V1alpha2ResourceClass structuredParameters(Boolean structuredParameters) {
        this.structuredParameters = structuredParameters;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If and only if allocation of claims using this class is handled via structured parameters, then StructuredParameters must be set to true.")
    public Boolean getStructuredParameters() {
        return this.structuredParameters;
    }

    public void setStructuredParameters(Boolean structuredParameters) {
        this.structuredParameters = structuredParameters;
    }

    public V1alpha2ResourceClass suitableNodes(V1NodeSelector suitableNodes) {
        this.suitableNodes = suitableNodes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeSelector getSuitableNodes() {
        return this.suitableNodes;
    }

    public void setSuitableNodes(V1NodeSelector suitableNodes) {
        this.suitableNodes = suitableNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2ResourceClass v1alpha2ResourceClass = (V1alpha2ResourceClass)o;
        return Objects.equals(this.apiVersion, v1alpha2ResourceClass.apiVersion) && Objects.equals(this.driverName, v1alpha2ResourceClass.driverName) && Objects.equals(this.kind, v1alpha2ResourceClass.kind) && Objects.equals(this.metadata, v1alpha2ResourceClass.metadata) && Objects.equals(this.parametersRef, v1alpha2ResourceClass.parametersRef) && Objects.equals(this.structuredParameters, v1alpha2ResourceClass.structuredParameters) && Objects.equals(this.suitableNodes, v1alpha2ResourceClass.suitableNodes);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.driverName, this.kind, this.metadata, this.parametersRef, this.structuredParameters, this.suitableNodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2ResourceClass {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    driverName: ").append(this.toIndentedString(this.driverName)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    parametersRef: ").append(this.toIndentedString(this.parametersRef)).append("\n");
        sb.append("    structuredParameters: ").append(this.toIndentedString(this.structuredParameters)).append("\n");
        sb.append("    suitableNodes: ").append(this.toIndentedString(this.suitableNodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

